import { StiLocalizationService } from "../../../services/sti-localization.service";
import { StiLabelAlignment } from "../../../system/enums";
import { StiElementCreator } from "./StiElementCreator";
export default class StiImageCreator extends StiElementCreator {
    static createPropertyEditors(properties, element) {
        properties.push({ type: "divider" });
        properties.push({
            type: "image",
            property: "image",
            label: StiLocalizationService.get("Cloud", "LabelPicture"),
        });
        properties.push({
            type: "TextEditor",
            property: "hyperlink",
            label: StiLocalizationService.get("PropertyMain", "Hyperlink"),
        });
        properties.push({ type: "divider" });
        properties.push({ type: "BooleanWithArrowEditor", property: "showBorderEditor", label: "" });
        properties.push({ type: "divider" });
        properties.push({
            type: "nameEditor",
            property: "name",
            label: StiLocalizationService.get("PropertyMain", "Name"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "componentHeight",
            property: "height",
            label: StiLocalizationService.get("PropertyMain", "Height"),
        });
        properties.push({
            type: "PaddingEditor",
            property: "padding",
            label: StiLocalizationService.get("PropertyMain", "Padding"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "tooltip",
            label: StiLocalizationService.get("PropertyMain", "ToolTip"),
        });
        properties.push({
            type: "checkbox",
            property: "readOnly",
            checkbox: StiLocalizationService.get("PropertyMain", "ReadOnly"),
        });
        properties.push({
            type: "checkbox",
            property: "visible",
            checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "label.value",
            label: StiLocalizationService.get("PropertyMain", "Label"),
        });
        properties.push({ type: "labelAlignment", property: "label.alignment", label: "" });
        if (element.label.alignment != StiLabelAlignment.Top) {
            properties.push({
                type: "Number",
                property: "label.width",
                label: StiLocalizationService.get("PropertyMain", "Width"),
            });
        }
        properties.push({
            type: "FontEditor",
            property: "label",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "label.color",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "description.value",
            label: StiLocalizationService.get("PropertyMain", "Description"),
        });
        properties.push({
            type: "FontEditor",
            property: "description",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "description.color",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        return properties;
    }
}
//# sourceMappingURL=data:application/json;base64,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