import { OnInit, ElementRef, OnChanges, EventEmitter, OnDestroy } from '@angular/core';
import { ProxyService } from './proxy.service';
import { HttpClient } from '@angular/common/http';
import * as i0 from "@angular/core";
export declare class StimulsoftDesignerComponent implements OnInit, OnChanges, OnDestroy {
    private proxy;
    private httpClient;
    designerEl: ElementRef;
    /**
     * Occurs when designer loaded
     */
    designerLoaded: EventEmitter<any>;
    /**
     * Url to server instance (designer controller)
     * Example: http://server.url:51528/api/designer
     */
    requestUrl: string;
    /**
     * The width of Designer
     */
    width: string;
    /**
     * The height of Designer
     */
    height: string;
    postParametersFunction: any;
    id: string;
    id2: string;
    designer: any;
    chartScripts: any;
    scriptLoading: boolean;
    private loaded;
    constructor(proxy: ProxyService, httpClient: HttpClient);
    ngOnDestroy(): void;
    ngOnInit(): void;
    ngOnChanges(changes: import('@angular/core').SimpleChanges): void;
    addScript(): void;
    designerLoadedF(): void;
    showDesigner(): void;
    get head(): HTMLHeadElement;
    static ɵfac: i0.ɵɵFactoryDeclaration<StimulsoftDesignerComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<StimulsoftDesignerComponent, "stimulsoft-designer-angular", never, { "requestUrl": { "alias": "requestUrl"; "required": false; }; "width": { "alias": "width"; "required": false; }; "height": { "alias": "height"; "required": false; }; "postParametersFunction": { "alias": "postParametersFunction"; "required": false; }; "id": { "alias": "id"; "required": false; }; }, { "designerLoaded": "designerLoaded"; }, never, ["*"], false, never>;
}
