﻿
StiJsViewer.prototype.InitializeDashboardsPanel = function () {
    var dashboardsPanel = document.createElement("div");
    this.controls.dashboardsPanel = dashboardsPanel;
    this.controls.mainPanel.appendChild(dashboardsPanel);
    dashboardsPanel.style.fontFamily = this.options.toolbar.fontFamily;
    if (this.options.toolbar.fontColor != "") dashboardsPanel.style.color = this.options.toolbar.fontColor;
    dashboardsPanel.className = "stiJsViewerToolBar";
    if (this.options.toolbar.displayMode == "Separated") dashboardsPanel.className += " stiJsViewerToolBarSeparated";
    dashboardsPanel.jsObject = this;
    dashboardsPanel.style.display = "none";
    dashboardsPanel.visible = false;

    var innerPanel = document.createElement("div");
    dashboardsPanel.appendChild(innerPanel);
    if (this.options.toolbar.displayMode == "Simple") innerPanel.style.paddingTop = "2px";

    // Inner content panel
    var panelTable = this.CreateHTMLTable();
    innerPanel.appendChild(panelTable);
    panelTable.className = "stiJsViewerToolBarTable";
    if (this.options.toolbar.displayMode == "Separated") panelTable.style.border = "0px";
    panelTable.style.margin = 0;
    panelTable.style.boxSizing = "border-box";

    // Left and right content tables
    var cell1 = panelTable.addCell();
    var cell2 = panelTable.addCell();
    var mainCell = (!this.options.appearance.rightToLeft) ? cell1 : cell2;
    var actionsCell = (!this.options.appearance.rightToLeft) ? cell2 : cell1;
    mainCell.style.width = "100%";
    var mainTable = this.CreateHTMLTable();
    var actionsTable = this.CreateHTMLTable();
    mainCell.appendChild(mainTable);
    actionsCell.appendChild(actionsTable);
    mainTable.setAttribute("align", this.options.appearance.rightToLeft ? "right" : (this.options.toolbar.alignment == "default" ? "left" : this.options.toolbar.alignment));
    actionsTable.style.marginRight = "2px";
    dashboardsPanel.actionsTable = actionsTable;

    // Refresh Dashboard menu button
    var buttonRefresh = this.SmallButton("ExportDashboard", null, "Refresh.png");
    buttonRefresh.jsObject = this;
    if (this.options.toolbar.displayMode == "Separated") {
        buttonRefresh.style.width = "28px";
        buttonRefresh.style.height = "28px";
        buttonRefresh.innerTable.style.width = "100%";
        buttonRefresh.imageCell.style.textAlign = "center";
    }
    buttonRefresh.action = function () {
        this.jsObject.postAction("GetPages");
    };
    actionsTable.addCell(buttonRefresh);

    // FullScreen button
    if (this.options.toolbar.showFullScreenButton) {
        var buttonFullScreen = this.SmallButton("FullScreenDashboard", null, "OpenFullScreen.png");
        buttonFullScreen.jsObject = this;
        if (this.options.toolbar.displayMode == "Separated") {
            buttonFullScreen.style.width = "28px";
            buttonFullScreen.style.height = "28px";
            buttonFullScreen.innerTable.style.width = "100%";
            buttonFullScreen.imageCell.style.textAlign = "center";
        }
        buttonFullScreen.action = function () {
            this.jsObject.postAction("FullScreen");
            this.jsObject.postAction("GetPages");
        };
        buttonFullScreen.setSelectedBase = buttonFullScreen.setSelected;
        buttonFullScreen.setSelected = function (state) {
            buttonFullScreen.setSelectedBase(state);
            this.image.src = this.jsObject.collections.images[(this.isSelected ? "Close" : "Open") + "FullScreen.png"];
            this.onmouseoutAction();
        };
        actionsTable.addCell(buttonFullScreen);
    }

    // Export Dashboard menu button
    var buttonExport = this.SmallButton("ExportDashboard", null, "Menu.png");
    buttonExport.jsObject = this;
    if (this.options.toolbar.displayMode == "Separated") {
        buttonExport.style.width = "28px";
        buttonExport.style.height = "28px";
        buttonExport.innerTable.style.width = "100%";
        buttonExport.imageCell.style.textAlign = "center";
    }
    buttonExport.action = function () {
        this.jsObject.controls.menus.saveDashboardMenu.changeVisibleState(true, this);
    };
    actionsTable.addCell(buttonExport);

    //
    // Panel methods

    dashboardsPanel.changeVisibleState = function (state) {
        this.visible = state;
        this.style.display = state ? "" : "none";
    }

    dashboardsPanel.update = function (dashboards) {
        if (!dashboards || dashboards.length == 0) return;
        this.clear();

        for (var index in dashboards) {
            var info = dashboards[index];
            var name = "button" + (mainTable.cellsCount() + 1);
            var caption = info.name;
            var button = this.jsObject.SmallButton(name, caption);
            button.panel = this;
            button.jsObject = this.jsObject;
            button.style.margin = "2px 1px 2px 2px";
            if (this.jsObject.options.toolbar.displayMode == "Separated") button.style.height = "28px";
            button.reportParams = index == 0 ? this.jsObject.reportParams : { };
            button.reportParams.type = info.type;
            button.reportParams.zoom = this.jsObject.options.toolbar.zoom;
            button.reportParams.pageNumber = info.type == "Dashboard" ? info.index : 0;

            button.select = function () {
                if (this.panel.selectedButton)
                    this.panel.selectedButton.setSelected(false);
                this.panel.selectedButton = this;
                this.setSelected(true);
            }

            button.action = function () {
                this.select();
                this.jsObject.reportParams = this.reportParams;
                this.jsObject.postAction("Refresh");
            };

            mainTable.addCell(button);
            if (index == 0) button.select();
        }

        this.changeVisibleState(dashboards.length > 1);
        this.jsObject.updateLayout();
    }

    dashboardsPanel.clear = function () {
        mainTable.clearRow();
    }
}
