﻿StiJsViewer.prototype.CheckBox = function (name, captionText, toolTip, styleColors, hasNullState) {
    var checkBox = this.CreateHTMLTable();
    checkBox.style.fontFamily = this.options.toolbar.fontFamily;
    if (this.options.toolbar.fontColor != "") checkBox.style.color = this.options.toolbar.fontColor;
    var jsObject = checkBox.jsObject = this;
    checkBox.isEnabled = true;
    checkBox.isChecked = false;
    checkBox.id = this.generateKey();
    checkBox.name = name;
    checkBox.captionText = captionText;
    if (toolTip) checkBox.setAttribute("title", toolTip);
    checkBox.className = "stiJsViewerCheckBox";
    checkBox.style.boxSizing = "content-box";
    checkBox.styleColors = styleColors;
    checkBox.hasNullState = hasNullState;

    if (name) {
        if (!this.controls.checkBoxes) this.controls.checkBoxes = {};
        this.controls.checkBoxes[name] = checkBox;
    }

    //Image
    checkBox.imageBlock = document.createElement("div");
    var size = this.options.isTouchDevice ? "16px" : "13px";
    checkBox.imageBlock.style.width = size;
    checkBox.imageBlock.style.height = size;
    checkBox.imageBlock.style.boxSizing = "content-box";
    checkBox.imageBlock.className = "stiJsViewerCheckBoxImageBlock";
    var imageBlockCell = checkBox.addCell(checkBox.imageBlock);
    imageBlockCell.style.lineHeight = "0";
    if (this.options.isTouchDevice) imageBlockCell.style.padding = "1px 3px 1px 2px";

    checkBox.image = document.createElement("img");
    checkBox.image.style.width = checkBox.image.style.height = "12px";
    StiJsViewer.setImageSource(checkBox.image, this.options, this.collections, "CheckBox" + (styleColors && styleColors.isDarkStyle ? "White.png" : ".png"));
    checkBox.image.style.visibility = "hidden";
    checkBox.image.style.verticalAlign = "baseline";
    var imgTable = this.CreateHTMLTable();
    imgTable.style.width = "100%";
    imgTable.style.height = "100%";
    checkBox.imageBlock.appendChild(imgTable);
    var imgCell = imgTable.addCell(checkBox.image);
    imgCell.style.textAlign = this.options.isTouchDevice ? "center" : "right";
    imgCell.style.verticalAlign = this.options.isTouchDevice ? "middle" : "top";
    imgCell.style.lineHeight = "0";

    if (hasNullState) {
        var nullBlock = checkBox.nullBlock = document.createElement("div");
        nullBlock.className = "stiJsViewerCheckBoxNullBlock";
        nullBlock.style.left = this.options.isTouchDevice ? "2px" : "2px";
        nullBlock.style.top = this.options.isTouchDevice ? "6px" : "6px";
        nullBlock.style.width = this.options.isTouchDevice ? "9px" : "9px";
        nullBlock.style.display = "none";
        imgCell.style.position = "relative";
        imgCell.appendChild(nullBlock);
    }

    //Caption
    if (captionText != null) {
        checkBox.captionCell = checkBox.addCell();
        if (!this.options.isTouchDevice) checkBox.captionCell.style.padding = "1px 0 0 4px";
        checkBox.captionCell.style.whiteSpace = "nowrap";
        checkBox.captionCell.innerText = captionText;
    }

    checkBox.onmouseover = function () {
        if (!jsObject.options.isTouchDevice) this.onmouseenter();
    }

    checkBox.onmouseout = function () {
        if (!jsObject.options.isTouchDevice) this.onmouseleave();
    }

    checkBox.onmouseenter = function () {
        if (!this.isEnabled) return;
        this.imageBlock.className = "stiJsViewerCheckBoxImageBlockOver";
    }

    checkBox.onmouseleave = function () {
        if (!this.isEnabled) return;
        this.imageBlock.className = "stiJsViewerCheckBoxImageBlock";
    }

    checkBox.onclick = function () {
        if (this.isTouchEndFlag || !this.isEnabled || jsObject.options.isTouchClick) {
            return;
        }
        if (this.hasNullState) {
            if (this.isNull) {
                this.setChecked(false);
                this.setNullState(false);
            }
            else if (this.isChecked) {
                this.setChecked(false);
                this.setNullState(true);
            }
            else {
                this.setChecked(true);
                this.setNullState(false);
            }
        }
        else {
            this.setChecked(!this.isChecked);
        }
        this.action();
    }

    checkBox.ontouchend = function () {
        if (!this.isEnabled || jsObject.options.fingerIsMoved) return;
        var this_ = this;
        this.isTouchEndFlag = true;
        clearTimeout(this.isTouchEndTimer);
        this.imageBlock.className = "stiJsViewerCheckBoxImageBlockOver";

        setTimeout(function () {
            this_.imageBlock.className = "stiJsViewerCheckBoxImageBlock";
            this_.setChecked(!this_.isChecked);
            this_.action();
        }, 150);

        this.isTouchEndTimer = setTimeout(function () {
            this_.isTouchEndFlag = false;
        }, 1000);
    }

    checkBox.ontouchstart = function () {
        jsObject.options.fingerIsMoved = false;
    }

    checkBox.setEnabled = function (state) {
        this.image.style.opacity = state ? "1" : "0.5";
        this.isEnabled = state;
        this.className = state ? "stiJsViewerCheckBox" : "stiJsViewerCheckBoxDisabled";
        this.imageBlock.className = state ? "stiJsViewerCheckBoxImageBlock" : "stiJsViewerCheckBoxImageBlockDisabled";
        if (this.nullBlock) this.nullBlock.style.opacity = state ? "1" : "0.5";
    }

    checkBox.setChecked = function (state, ignoreOnChecked) {
        this.image.style.visibility = (state) ? "visible" : "hidden";
        this.isChecked = state;
        this.setIndeterminate(false);
        if (this.hasNullState) this.setNullState(false);
        if (!ignoreOnChecked) this.onChecked();
    }

    checkBox.setNullState = function (state) {
        this.isNull = state;
        this.nullBlock.style.display = state ? "" : "none";

        if (captionText == "") {
            checkBox.captionCell.innerText = state ? jsObject.collections.loc.NotAssigned : "";
        }
    }

    checkBox.setIndeterminate = function (state) {
        StiJsViewer.setImageSource(checkBox.image, jsObject.options, jsObject.collections, (state ? "CheckBoxIndeterminate" : "CheckBox") + (this.styleColors && this.styleColors.isDarkStyle ? "White.png" : ".png"));
        checkBox.image.style.visibility = state || this.isChecked ? "visible" : "hidden";
        checkBox.image.style.width = checkBox.image.style.height = state ? "13px" : "12px";
        this.isIndeterminate = state;
    }

    checkBox.applyStyleColors = function (styleColors) {
        this.styleColors = styleColors;
        StiJsViewer.setImageSource(checkBox.image, jsObject.options, jsObject.collections, "CheckBox" + (styleColors && styleColors.isDarkStyle ? "White.png" : ".png"));

        if (styleColors) {
            checkBox.imageBlock.style.background = styleColors.backColor;
            checkBox.imageBlock.style.borderColor = styleColors.foreColor;
            checkBox.style.color = styleColors.foreColor;
        }
        else {
            checkBox.imageBlock.style.background = "";
            checkBox.style.color = "";
        }
    }

    checkBox.onChecked = function () { }
    checkBox.action = function () { }

    return checkBox;
}