/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.servlet;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.system.MIMEType;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StiWebResourceServletHelper {
    protected static final Logger LOG = Logger.getLogger(StiWebResourceServletHelper.class.getName());
    public static final String VERSION = "/" + StiAttribute.getSimpleVersion();
    private static final int VERSION_LENGTH = VERSION.length();
    public static String RESOURCE_PARAM = "f";
    public static String RESOURCE_SERVLET_MAPPING = "stimulsoft_web_resource";

    protected static void processing(StiHttpServletRequest request, StiHttpServletResponse response) {
        block14: {
            String path = null;
            try {
                block15: {
                    if (request.getParameter(RESOURCE_PARAM) != null) {
                        path = request.getParameter(RESOURCE_PARAM);
                    } else if (request.getRequestURL().indexOf(RESOURCE_SERVLET_MAPPING) > 0) {
                        path = request.getRequestURL().substring(request.getRequestURL().indexOf(RESOURCE_SERVLET_MAPPING) + RESOURCE_SERVLET_MAPPING.length() + VERSION_LENGTH);
                    }
                    if (!StiValidationUtil.isNotNullOrEmpty((String)path)) break block14;
                    if (path.endsWith(".css")) {
                        response.setContentType("text/css");
                    } else if (path.endsWith(".js")) {
                        response.setContentType("application/javascript");
                    } else if (path.endsWith(".png")) {
                        response.setContentType("image/png");
                    } else if (path.endsWith("swf")) {
                        response.setContentType(MIMEType.flash.type);
                    }
                    response.setHeader("Cache-Control", "public, max-age=31536000");
                    path = path.replaceAll("//", "/");
                    InputStream is = StiResourceUtil.getStream((String)path);
                    try {
                        response.setHeader("Content-Length", String.valueOf(is.available()));
                    }
                    catch (Exception e) {
                        if (path.endsWith("About.png")) break block15;
                        System.out.println("Error loading: " + path);
                    }
                }
                StiIOUtil.writeInputStream((OutputStream)response.getOutputStream(), (InputStream)StiResourceUtil.getStream((String)path));
            }
            catch (Exception e) {
                if (!StiValidationUtil.isNotNullOrEmpty(path) || path.endsWith("About.png")) break block14;
                LOG.log(Level.WARNING, "Resource " + path + " not found", e);
            }
        }
    }
}

