/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.proxyee;

import com.stimulsoft.report.StiOptions;
import com.stimulsoft.web.proxyee.StiAngularHandler;
import com.stimulsoft.web.proxyee.StiCookie;
import com.stimulsoft.web.proxyee.StiHttpSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public class StiHttpServletRequest {
    private Object request;
    private StiAngularHandler angularHandler;

    public Object getRequest() {
        return this.request;
    }

    public StiAngularHandler getAngularHandler() {
        return this.angularHandler;
    }

    public StiHttpServletRequest(Object request) {
        this.request = request;
    }

    public StiHttpServletRequest(Object request, StiAngularHandler angularHandler) {
        this.request = request;
        this.angularHandler = angularHandler;
    }

    public String getParameter(String name) {
        try {
            Method method = this.request.getClass().getMethod("getParameter", String.class);
            method.setAccessible(true);
            return (String)method.invoke(this.request, name);
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public Map getParameterMap() {
        try {
            Method method = this.request.getClass().getMethod("getParameterMap", new Class[0]);
            method.setAccessible(true);
            return (Map)method.invoke(this.request, new Object[0]);
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public StiHttpSession getSession() {
        try {
            Method method = this.request.getClass().getMethod("getSession", new Class[0]);
            method.setAccessible(true);
            return new StiHttpSession(method.invoke(this.request, new Object[0]));
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public StiCookie[] getCookies() {
        try {
            Method method = this.request.getClass().getMethod("getCookies", new Class[0]);
            method.setAccessible(true);
            Object[] rCookies = (Object[])method.invoke(this.request, new Object[0]);
            StiCookie[] cookies = new StiCookie[rCookies.length];
            for (int i = 0; i < cookies.length; ++i) {
                cookies[i] = new StiCookie(rCookies[i]);
            }
            return cookies;
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public BufferedReader getReader() throws IOException {
        try {
            Method method = this.request.getClass().getMethod("getReader", new Class[0]);
            method.setAccessible(true);
            return (BufferedReader)method.invoke(this.request, new Object[0]);
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public StringBuffer getRequestURL() {
        try {
            Method method = this.request.getClass().getMethod("getRequestURL", new Class[0]);
            method.setAccessible(true);
            return (StringBuffer)method.invoke(this.request, new Object[0]);
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

