/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.zip.StiGZipHelper;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.enums.StiHtmlChartType;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiComponentType;
import com.stimulsoft.web.enums.StiDesignerCommand;
import com.stimulsoft.web.enums.StiPrintAction;
import com.stimulsoft.web.enums.StiReportDisplayMode;
import com.stimulsoft.web.enums.StiReportType;
import com.stimulsoft.web.enums.StiWebViewMode;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StiRequestParamsHelper {
    public static StiRequestParams get(StiHttpServletRequest httpContext, StiHttpServletResponse response, StringBuffer jsonParams) throws IOException, JSONException {
        byte[] bytes;
        StiRequestParams requestParams = new StiRequestParams();
        requestParams.httpContext = httpContext;
        requestParams.response = response;
        for (Object k : httpContext.getParameterMap().keySet()) {
            String key = (String)k;
            if (!key.startsWith("stiweb_") && !key.startsWith("properties")) continue;
            requestParams.all.put(key, httpContext.getParameter(key).toString());
        }
        if (jsonParams != null && jsonParams.length() > 0) {
            String[] params;
            for (String string : params = jsonParams.toString().split("&")) {
                if (!string.startsWith("stiweb_") && !string.startsWith("properties")) continue;
                requestParams.all.put(string.substring(0, string.indexOf("=")), URLDecoder.decode(string.substring(string.indexOf("=") + 1), "UTF-8"));
            }
        }
        StiRequestParamsHelper.parseFormData(httpContext, requestParams.all);
        if (requestParams.contains("stiweb_component")) {
            requestParams.component = requestParams.getEnum("stiweb_component", StiComponentType.class, StiComponentType.Viewer);
        }
        if (requestParams.contains("stiweb_action")) {
            requestParams.action = requestParams.getEnum("stiweb_action", StiAction.class, StiAction.GetLocalization);
        }
        if (requestParams.contains("stiweb_theme")) {
            requestParams.theme = requestParams.getString("stiweb_theme");
        }
        if (requestParams.contains("stiweb_loc")) {
            String base64 = requestParams.getString("stiweb_loc");
            requestParams.localization = new String(StiBase64DecoderUtil.decode((String)base64), "UTF-8");
        }
        if (requestParams.contains("stiweb_data")) {
            if (requestParams.action == StiAction.Resource) {
                requestParams.resource = requestParams.getString("stiweb_data");
            } else {
                requestParams.data = StiBase64DecoderUtil.decode((String)requestParams.getString("stiweb_data"));
            }
        }
        if (requestParams.contains("stiweb_parameters")) {
            bytes = StiBase64DecoderUtil.decode((String)requestParams.getString("stiweb_parameters"));
            String string = new String(bytes, "UTF-8");
            JSONObject container = new JSONObject(string);
            StiRequestParamsHelper.parseParameters(container, requestParams.all, null);
            requestParams.hasParameters = true;
            requestParams.server.useCompression = false;
        }
        if (requestParams.contains("stiweb_packed_parameters")) {
            bytes = StiBase64DecoderUtil.decode((String)requestParams.getString("stiweb_parameters"));
            byte[] byArray = StiGZipHelper.unpack((byte[])bytes);
            String json = new String(byArray, "UTF-8");
            JSONObject container = new JSONObject(json);
            StiRequestParamsHelper.parseParameters(container, requestParams.all, null);
            requestParams.hasParameters = true;
            requestParams.server.useCompression = true;
        }
        if (requestParams.hasParameters && requestParams.component == StiComponentType.Viewer) {
            requestParams.id = requestParams.getString("viewerId");
            requestParams.formValues = requestParams.getHashtable("formValues");
            requestParams.exportFormat = requestParams.getEnum("exportFormat", StiExportFormat.class, StiExportFormat.Pdf);
            requestParams.exportSettings = requestParams.getHashtable("exportSettings");
            requestParams.version = requestParams.getString("version");
            requestParams.localization = requestParams.getString("localization");
            requestParams.cache.clientGuid = requestParams.getString("clientGuid");
            requestParams.cache.drillDownGuid = requestParams.getString("drillDownGuid");
            requestParams.cache.timeout = Integer.parseInt(requestParams.getString("cacheTimeout"));
            requestParams.cache.mode = requestParams.getString("cacheMode");
            requestParams.cache.priority = requestParams.getString("cacheItemPriority");
            requestParams.interaction.variables = requestParams.getHashtable("variables");
            requestParams.interaction.sorting = requestParams.getHashtable("sortingParameters");
            requestParams.interaction.collapsing = requestParams.getHashtable("collapsingParameters");
            requestParams.interaction.drillDown = requestParams.getArray("drillDownParameters");
            requestParams.interaction.editable = requestParams.getHashtable("editableParameters");
            requestParams.viewer.pageNumber = requestParams.getInt("pageNumber");
            requestParams.viewer.zoom = requestParams.getString("zoom") != null ? Double.parseDouble(requestParams.getString("zoom")) / 100.0 : 0.0;
            requestParams.viewer.showBookmarks = requestParams.getBoolean("showBookmarks");
            requestParams.viewer.bookmarksPrint = requestParams.getBoolean("bookmarksPrint");
            requestParams.viewer.openingFileName = requestParams.getString("openingFileName");
            requestParams.viewer.openingFilePassword = requestParams.getString("openingFilePassword");
            requestParams.viewer.viewMode = requestParams.getEnum("viewMode", StiWebViewMode.class, StiWebViewMode.OnePage);
            requestParams.viewer.chartRenderType = requestParams.getEnum("chartRenderType", StiHtmlChartType.class, StiHtmlChartType.AnimatedVector);
            requestParams.viewer.reportDisplayMode = requestParams.getEnum("reportDisplayMode", StiReportDisplayMode.class, StiReportDisplayMode.Div);
            requestParams.viewer.printAction = requestParams.getEnum("printAction", StiPrintAction.class, StiPrintAction.PrintPdf);
            requestParams.viewer.openLinksWindow = requestParams.getString("openLinksWindow");
            requestParams.viewer.reportDesignerMode = requestParams.getBoolean("reportDesignerMode");
            requestParams.viewer.dashboardWidth = requestParams.getInt("dashboardWidth");
            requestParams.viewer.dashboardHeight = requestParams.getInt("dashboardHeight");
            requestParams.viewer.reportType = requestParams.getEnum("reportType", StiReportType.class, null);
            requestParams.viewer.elementName = requestParams.getString("elementName");
            requestParams.server.useRelativeUrls = requestParams.getBoolean("useRelativeUrls");
            requestParams.server.passQueryParametersForResources = requestParams.getBoolean("passQueryParametersForResources");
            requestParams.reportResourceParams = requestParams.getHashtable("reportResourceParams");
        }
        if (requestParams.hasParameters && requestParams.component == StiComponentType.Designer) {
            requestParams.id = requestParams.getString("designerId");
            requestParams.formValues = requestParams.getHashtable("formValues");
            requestParams.version = requestParams.getString("version");
            requestParams.cache.clientGuid = requestParams.getString("clientGuid");
            requestParams.cache.timeout = 1;
            requestParams.cache.mode = requestParams.getString("cacheMode");
            requestParams.cache.priority = requestParams.getString("cacheItemPriority");
            requestParams.designer.command = requestParams.getEnum("command", StiDesignerCommand.class, StiDesignerCommand.Undefined);
            requestParams.designer.isSaveAs = requestParams.designer.command == StiDesignerCommand.SaveAsReport;
            requestParams.designer.undoMaxLevel = requestParams.getInt("undoMaxLevel");
            requestParams.server.useRelativeUrls = requestParams.getBoolean("useRelativeUrls");
            requestParams.server.passQueryParametersForResources = requestParams.getBoolean("passQueryParametersForResources");
            if (requestParams.contains("checkReportBeforePreview")) {
                requestParams.designer.checkReportBeforePreview = requestParams.getBoolean("checkReportBeforePreview");
            }
            if (requestParams.contains("localization")) {
                requestParams.localization = requestParams.getString("localization");
            }
            requestParams.designer.fileName = requestParams.contains("openReportFile") ? requestParams.getString("openReportFile") : requestParams.getString("reportFile");
            requestParams.designer.password = requestParams.contains("encryptedPassword") ? requestParams.getString("encryptedPassword") : requestParams.getString("password");
            if (requestParams.contains("saveType")) {
                requestParams.designer.saveType = requestParams.getString("saveType");
            }
            switch (requestParams.designer.command) {
                case GetReportForDesigner: {
                    requestParams.action = StiAction.GetReport;
                    break;
                }
                case OpenReport: {
                    requestParams.action = StiAction.OpenReport;
                    break;
                }
                case CreateReport: 
                case WizardResult: {
                    requestParams.action = StiAction.CreateReport;
                    break;
                }
                case SaveReport: 
                case SaveAsReport: {
                    requestParams.action = StiAction.SaveReport;
                    break;
                }
                case LoadReportToViewer: {
                    requestParams.action = StiAction.PreviewReport;
                    break;
                }
                case ExitDesigner: {
                    requestParams.action = StiAction.Exit;
                }
            }
        }
        return requestParams;
    }

    public static HashMap<String, Object> parseParameters(Object container, HashMap<String, Object> hash, List array) throws JSONException {
        if (hash == null && array == null) {
            return null;
        }
        int count = container instanceof JSONObject && ((JSONObject)container).names() != null ? ((JSONObject)container).names().length() : (container instanceof JSONArray ? ((JSONArray)container).length() : 0);
        for (int i = 0; i < count; ++i) {
            ArrayList childArray;
            Object token;
            Object object = container instanceof JSONObject ? ((JSONObject)container).get(((JSONObject)container).names().getString(i)) : (token = container instanceof JSONArray ? ((JSONArray)container).get(i) : null);
            String name = container instanceof JSONObject ? ((JSONObject)container).names().getString(i) : (container instanceof JSONArray ? String.valueOf(i) : null);
            HashMap<String, Object> childHash = token instanceof JSONObject ? new HashMap<String, Object>() : null;
            ArrayList arrayList = childArray = token instanceof JSONArray ? new ArrayList() : null;
            if (token instanceof JSONObject || token instanceof JSONArray) {
                StiRequestParamsHelper.parseParameters(token, childHash != null ? childHash : null, childArray != null ? childArray : null);
            }
            if (hash != null) {
                if (childHash != null) {
                    hash.put(name, childHash);
                    continue;
                }
                if (childArray != null) {
                    hash.put(name, childArray);
                    continue;
                }
                hash.put(name, token != JSONObject.NULL ? token : null);
                continue;
            }
            if (childHash != null) {
                array.add(childHash);
                continue;
            }
            if (childArray != null) {
                array.add(childArray);
                continue;
            }
            array.add(token);
        }
        return hash;
    }

    private static void parseFormData(StiHttpServletRequest httpContext, HashMap<String, Object> params) {
        block7: {
            try {
                ArrayList<String> lines = new ArrayList<String>();
                String line = null;
                BufferedReader reader = httpContext.getReader();
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
                if (lines.size() > 0) {
                    String delimiter = (String)lines.get(0);
                    for (int pos = 0; pos < lines.size(); ++pos) {
                        String nameLine;
                        if (!((String)lines.get(pos)).equals(delimiter) || (nameLine = (String)lines.get(++pos)).indexOf("name=") < 0) continue;
                        String name = nameLine.substring(nameLine.indexOf("name=") + 6);
                        name = name.substring(0, name.indexOf("\""));
                        String value = "";
                        ++pos;
                        while (pos < lines.size() && !((String)lines.get(pos)).equals(delimiter)) {
                            if (StiValidationUtil.isNotNullOrEmpty((String)((String)lines.get(pos)))) {
                                value = value + (String)lines.get(pos);
                            }
                            ++pos;
                        }
                        --pos;
                        params.put(name, value);
                    }
                }
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block7;
                e.printStackTrace();
            }
        }
    }
}

