/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.web.cache.StiCacheOptions;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiComponentType;
import com.stimulsoft.web.helper.StiReportHelper;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;

public class StiCacheHelper {
    public static final String SESSION_OPTIONS_ID = "sessionOptions";
    public static final String GUID_ReportSnapshot = "";
    public static final String GUID_ReportTemplate = "template";
    public static final String GUID_Clipboard = "clipboard";
    public static final String GUID_ComponentClone = "clone";
    public static final String GUID_ReportCheckers = "checkers";
    public static final String GUID_UndoArray = "undo";

    public static StiReport getReport(String guid, StiHttpServletRequest request) {
        Object cacheData = StiCacheOptions.cache.getObject(request, guid);
        if (cacheData instanceof StiReport) {
            return (StiReport)cacheData;
        }
        return null;
    }

    public static void saveReport(StiReport report, String guid, StiHttpServletRequest request) {
        StiCacheOptions.cache.storeObject(request, report, guid);
    }

    public StiReport getReportInternal(StiRequestParams requestParams, StiHttpServletRequest request) {
        return this.getReportInternal(requestParams, true, request);
    }

    public StiReport getReportInternal(StiRequestParams requestParams, boolean useDrillDownReportSnapshot, StiHttpServletRequest request) {
        StiReport report = requestParams.report;
        if (report == null && !"None".equals(requestParams.cache.mode) && !StiValidationUtil.isNullOrEmpty((String)requestParams.cache.clientGuid) && requestParams.action != StiAction.Undefined && requestParams.action != StiAction.Resource) {
            boolean isReportTemplateRequire;
            this.applyRequestParameters(requestParams);
            boolean bl = isReportTemplateRequire = requestParams.component == StiComponentType.Designer && requestParams.action != StiAction.PrintReport && requestParams.action != StiAction.ExportReport && requestParams.action != StiAction.EmailReport || useDrillDownReportSnapshot && (requestParams.action == StiAction.InitVars || requestParams.action == StiAction.Variables || requestParams.action == StiAction.Sorting || requestParams.action == StiAction.Collapsing || requestParams.action == StiAction.DrillDown || requestParams.action == StiAction.RefreshReport);
            if (isReportTemplateRequire) {
                String currentCacheGuid = this.getReportCacheGuid(requestParams) + "_" + GUID_ReportTemplate;
                report = StiCacheHelper.getReport(currentCacheGuid, request);
                if (report != null && requestParams.action != StiAction.InitVars) {
                    report.setIsRendered(false);
                }
            } else {
                String currentCacheGuid = useDrillDownReportSnapshot && !StiValidationUtil.isNullOrEmpty((String)requestParams.cache.drillDownGuid) ? this.getReportCacheGuid(requestParams) + "_" + requestParams.cache.drillDownGuid : this.getReportCacheGuid(requestParams);
                report = StiCacheHelper.getReport(currentCacheGuid, request);
                if (report == null) {
                    currentCacheGuid = this.getReportCacheGuid(requestParams) + "_" + GUID_ReportTemplate;
                    report = StiCacheHelper.getReport(currentCacheGuid, request);
                }
            }
        }
        return report;
    }

    public void saveReportInternal(StiRequestParams requestParams, StiReport report, StiHttpServletRequest request) {
        if (report != null && !"None".equals(requestParams.cache.mode) && !StiValidationUtil.isNullOrEmpty((String)requestParams.cache.clientGuid) && requestParams.action != StiAction.Undefined && requestParams.action != StiAction.Resource) {
            String currentCacheGuid;
            block8: {
                boolean isReportSnapshot;
                this.applyRequestParameters(requestParams);
                boolean bl = isReportSnapshot = requestParams.action == StiAction.Variables || requestParams.action == StiAction.Sorting || requestParams.action == StiAction.Collapsing || requestParams.action == StiAction.DrillDown || requestParams.action == StiAction.PreviewReport || requestParams.action == StiAction.RefreshReport;
                if (!isReportSnapshot && !report.isDocument && (requestParams.component == StiComponentType.Designer || report.getDictionary().getisRequestFromUserVariablesPresent() || StiReportHelper.isReportHasInteractions(report) || StiReportHelper.isReportHasDashboards(report) || report.getRefreshTime() > 0)) {
                    currentCacheGuid = this.getReportCacheGuid(requestParams) + "_" + GUID_ReportTemplate;
                    StiCacheHelper.saveReport(report, currentCacheGuid, request);
                    if (requestParams.component == StiComponentType.Designer) {
                        return;
                    }
                } else if (!(requestParams.viewer.reportDesignerMode || requestParams.action != StiAction.GetReport && requestParams.action != StiAction.OpenReport)) {
                    currentCacheGuid = this.getReportCacheGuid(requestParams);
                    StiCacheHelper.removeReport(currentCacheGuid, request);
                }
                if (!report.getIsRendered() && !report.isDocument) {
                    try {
                        report.Render(false);
                    }
                    catch (Exception e) {
                        if (StiLoggingUtil.getLogLevel() < 10) break block8;
                        e.printStackTrace();
                    }
                }
            }
            currentCacheGuid = !StiValidationUtil.isNullOrEmpty((String)requestParams.cache.drillDownGuid) ? this.getReportCacheGuid(requestParams) + "_" + requestParams.cache.drillDownGuid : this.getReportCacheGuid(requestParams);
            report.setSaveInteractionParametersToDocument(true);
            StiCacheHelper.saveReport(report, currentCacheGuid, request);
            report.setSaveInteractionParametersToDocument(false);
        }
    }

    void applyRequestParameters(StiRequestParams requestParams) {
    }

    public static void removeObject(String guid, StiHttpServletRequest request) {
        StiCacheOptions.cache.removeObject(request, guid);
    }

    public static void removeReport(String guid, StiHttpServletRequest request) {
        StiCacheHelper.removeObject(guid, request);
        if (guid.indexOf(GUID_ReportTemplate) < 0) {
            StiCacheHelper.removeObject(String.format("%s_%s", guid, GUID_ReportTemplate), request);
        }
    }

    private String getReportCacheGuid(StiRequestParams requestParams) {
        return this.getReportCacheGuid(requestParams, null);
    }

    private String getReportCacheGuid(StiRequestParams requestParams, String guid) {
        if (StiValidationUtil.isNullOrEmpty((String)guid)) {
            guid = requestParams.id + "_" + requestParams.cache.clientGuid;
        }
        if (requestParams.cache.useLocalizedCache) {
            guid = guid + "_" + StiBase64EncoderUtil.encode((String)requestParams.localization);
        }
        return guid;
    }

    public static Object getObject(String guid, StiHttpServletRequest request) {
        return StiCacheOptions.cache.getObject(request, guid);
    }

    public static void saveObject(Object obj, String guid, StiHttpServletRequest request) {
        StiCacheOptions.cache.storeObject(request, obj, guid);
    }

    public static Object getObjectInternal(StiRequestParams requestParams, String objectGuid, StiHttpServletRequest request) {
        String guid = StiValidationUtil.isNullOrEmpty((String)objectGuid) ? String.format("%s_%s", requestParams.id, requestParams.cache.clientGuid) : String.format("%s_%s_%s", requestParams.id, requestParams.cache.clientGuid, objectGuid);
        return StiCacheHelper.getObject(guid, request);
    }

    public static void saveObjectInternal(Object obj, StiRequestParams requestParams, String objectGuid, StiHttpServletRequest request) {
        String guid = StiValidationUtil.isNullOrEmpty((String)objectGuid) ? String.format("%s_%s", requestParams.id, requestParams.cache.clientGuid) : String.format("%s_%s_%s", requestParams.id, requestParams.cache.clientGuid, objectGuid);
        StiCacheHelper.saveObject(obj, guid, request);
    }

    public static void saveOptions(Object options, String designerId, StiHttpServletRequest request) {
        StiCacheOptions.cache.storeObject(request, options, SESSION_OPTIONS_ID + designerId);
    }

    public static Object getOptions(StiRequestParams params, StiHttpServletRequest request) {
        return StiCacheOptions.cache.getObject(request, SESSION_OPTIONS_ID + params.id);
    }

    public void removeReportInternal(StiRequestParams requestParams, StiHttpServletRequest request) {
        String guid = String.format("%s_%s", requestParams.id, requestParams.cache.clientGuid);
        StiCacheHelper.removeReport(guid, request);
    }
}

