/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.cache;

import com.stimulsoft.report.StiOptions;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;

public class StiCache {
    public void storeObject(StiHttpServletRequest request, Object object, String objectGuid) {
        if (object != null) {
            request.getSession().setAttribute(objectGuid, object);
        }
    }

    public void removeObject(StiHttpServletRequest request, String objectGuid) {
        request.getSession().removeAttribute(objectGuid);
    }

    public Object getObject(StiHttpServletRequest request, String objectGuid) {
        return request.getSession().getAttribute(objectGuid);
    }

    public void clearStoredObjects(StiHttpServletRequest request) {
        ArrayList<String> attrsToRemove = new ArrayList<String>();
        Enumeration<String> attrs = request.getSession().getAttributeNames();
        while (attrs != null && attrs.hasMoreElements()) {
            String attr = attrs.nextElement();
            if (attr.toLowerCase().indexOf("webviewer") < 0) continue;
            attrsToRemove.add(attr);
        }
        for (String attr : attrsToRemove) {
            try {
                request.getSession().removeAttribute(attr);
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) continue;
                e.printStackTrace();
            }
        }
    }
}

