/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.stiblocks.objects;

import com.stimulsoft.base.StiConvert;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.base.utils.StiReflectUtill;
import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.expressions.StiExpression;
import java.lang.reflect.Method;

public class StiSetPropertyOfObjectTo
extends IronBlock {
    @Override
    public Object evaluate(Context context) {
        Object obj = this.getValues().evaluate("OBJECT", context);
        if (obj != null) {
            String propertyName = this.getValues().evaluate("PROPERTY", context).toString();
            String[] propertyNames = propertyName.split("/.");
            Object value = this.getValues().evaluate("VALUE", context);
            this.setValue(obj, propertyNames, value);
        }
        return super.evaluate(context);
    }

    private void setValue(Object baseObj, String[] properties, Object value) {
        for (int index = 0; index < properties.length; ++index) {
            String propertyName = properties[index];
            if (index == properties.length - 1) {
                Method prop;
                block12: {
                    propertyName = this.checkPropertyName(baseObj, propertyName);
                    prop = null;
                    try {
                        prop = StiReflectUtill.getDeclaredMethod(baseObj.getClass(), (String)("set" + propertyName));
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel < 10) break block12;
                        e.printStackTrace();
                    }
                }
                if (null == prop) continue;
                if (value instanceof StiExpression) {
                    StiExpression exp = (StiExpression)value;
                    value = exp.getValue();
                }
                if (prop.getParameters()[0].getType().isAssignableFrom(StiExpression.class)) {
                    String textValue = (String)StiConvert.changeType((Object)value, String.class);
                    value = new StiExpression();
                    ((StiExpression)value).setValue(textValue);
                } else if (prop.getParameters()[0].getType().isAssignableFrom(StiColor.class) && value instanceof String) {
                    String valueText = (String)value;
                    value = StiColor.deserializeString((String)valueText);
                }
                try {
                    Object valueType = StiConvert.changeType((Object)value, prop.getParameterTypes()[0]);
                    prop.invoke(baseObj, valueType);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) continue;
                    e.printStackTrace();
                }
                continue;
            }
            try {
                Method method = StiReflectUtill.getDeclaredMethod(baseObj.getClass(), (String)("get" + propertyName));
                baseObj = method.invoke(baseObj, null);
                continue;
            }
            catch (Exception e) {
                StiLoggingUtil.printStackTrace((Exception)e);
            }
        }
    }

    private String checkPropertyName(Object obj, String propertyName) {
        return propertyName;
    }
}

