/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.stiblocks.objects;

import com.stimulsoft.base.utils.StiReflectUtill;
import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;
import com.stimulsoft.report.StiOptions;
import java.lang.reflect.Method;

public class StiGetPropertyOfObject
extends IronBlock {
    @Override
    public Object evaluate(Context context) {
        try {
            Object obj = this.getValues().evaluate("OBJECT", context);
            if (obj != null) {
                String propertyName = this.getValues().evaluate("PROPERTY", context).toString();
                String[] propertyNames = propertyName.split("/.");
                return this.getValue(obj, propertyNames);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.evaluate(context);
    }

    private Object getValue(Object baseObj, String[] properties) {
        Object valueObj = null;
        for (int index = 0; index < properties.length; ++index) {
            if (index == 0) {
                valueObj = baseObj;
            }
            String propertyName = properties[index];
            try {
                Method prop = StiReflectUtill.getDeclaredMethod(valueObj.getClass(), (String)("get" + propertyName));
                valueObj = prop.invoke(valueObj, null);
                continue;
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) continue;
                e.printStackTrace();
            }
        }
        return valueObj;
    }
}

