/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.blocks.text;

import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;
import java.util.Arrays;
import java.util.stream.Collectors;

public class TextCaseChange
extends IronBlock {
    private static final String WORD_SEPARATOR = " ";

    @Override
    public Object evaluate(Context context) {
        String toCase = this.getFields().get("CASE").toString();
        Object tempVar = this.getValues().evaluate("TEXT", context);
        String text = (tempVar != null ? tempVar : "").toString();
        switch (toCase) {
            case "UPPERCASE": {
                return text.toUpperCase();
            }
            case "LOWERCASE": {
                return text.toLowerCase();
            }
            case "TITLECASE": {
                return TextCaseChange.convertToTitleCaseSplitting(text);
            }
        }
        throw new UnsupportedOperationException("unknown case");
    }

    public static String convertToTitleCaseSplitting(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return Arrays.stream(text.split(WORD_SEPARATOR)).map(word -> word.isEmpty() ? word : Character.toTitleCase(word.charAt(0)) + word.substring(1).toLowerCase()).collect(Collectors.joining(WORD_SEPARATOR));
    }
}

