/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.blocks.text;

import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;
import com.stimulsoft.lib.utils.StiValidationUtil;

public class ColourBlend
extends IronBlock {
    @Override
    public Object evaluate(Context context) {
        Object tempVar = this.getValues().evaluate("COLOUR1", context);
        String colour1 = (tempVar != null ? tempVar : "").toString();
        Object tempVar2 = this.getValues().evaluate("COLOUR2", context);
        String colour2 = (tempVar2 != null ? tempVar2 : "").toString();
        double ratio = Math.min(Math.max((Double)this.getValues().evaluate("RATIO", context), 0.0), 1.0);
        if (StiValidationUtil.isNullOrEmpty((String)colour1) || colour1.length() != 7) {
            return null;
        }
        if (StiValidationUtil.isNullOrEmpty((String)colour2) || colour2.length() != 7) {
            return null;
        }
        int red = (int)((double)Integer.parseInt(colour1.substring(1, 3), 16) * (1.0 - ratio) + (double)Integer.parseInt(colour2.substring(1, 3), 16) * ratio);
        int green = (int)((double)Integer.parseInt(colour1.substring(3, 5), 16) * (1.0 - ratio) + (double)Integer.parseInt(colour2.substring(3, 5), 16) * ratio);
        int blue = (int)((double)Integer.parseInt(colour1.substring(5, 7), 16) * (1.0 - ratio) + (double)Integer.parseInt(colour2.substring(5, 7), 16) * ratio);
        return String.format("#%1$.2x%2$.2x%3$.2x", red, green, blue);
    }
}

