/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.demo.panels;

import com.stimulsoft.base.exception.StiExceptionProvider;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.panels.renderer.StiTreeRenderer;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.base.worker.StiSimpleWorker;
import com.stimulsoft.demo.Demo;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.StiStatusHandler;
import com.stimulsoft.report.dictionary.databases.StiDatabaseCollection;
import com.stimulsoft.report.dictionary.databases.StiJDBCDatabase;
import com.stimulsoft.report.dictionary.databases.StiXmlDatabase;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.saveLoad.StiDocument;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StiTreeReportsPanel
extends JScrollPane
implements TreeSelectionListener {
    private static final long serialVersionUID = -5951139390445988630L;
    private static StiDatabaseCollection demoDatabaseCollection = new StiDatabaseCollection();
    public static final int DEFAULT_WIDTH = 300;
    private final Demo demo;
    private final JTree tree;
    private Report currentReport;

    private static StiJDBCDatabase getOleDatabase(String demoDir) {
        String accessFile = demoDir + "NWIND.MDB";
        String jdbcUrl = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb, *.accdb)};DBQ=" + accessFile;
        String jdbcDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
        StiJDBCDatabase oleDatabase = new StiJDBCDatabase("NorthWind", jdbcUrl, jdbcDriver, "", "");
        return oleDatabase;
    }

    public StiTreeReportsPanel(Demo demo) {
        super(new JTree(), 20, 30);
        this.setSize(300, 100);
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(300, 3000));
        this.setBorder(BorderFactory.createEmptyBorder(5, 2, 0, 0));
        this.demo = demo;
        this.tree = (JTree)this.getViewport().getView();
        this.tree.getSelectionModel().setSelectionMode(1);
        ImageIcon dtreeFolderIcon = StiResourceUtil.loadIcon((String)"/DtreeFolder.png");
        this.tree.setCellRenderer((TreeCellRenderer)new StiTreeRenderer((Icon)dtreeFolderIcon, (Icon)StiResourceUtil.loadIcon((String)"/DtreeBase.png"), (Icon)dtreeFolderIcon));
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = StiTreeReportsPanel.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 2) {
                    StiTreeReportsPanel.this.loadDocument();
                }
            }
        });
        this.tree.setFocusable(false);
    }

    private void loadDocument() {
        if (this.currentReport != null) {
            this.demo.updateStatus("Rendering report");
            StiSimpleWorker renderWorker = new StiSimpleWorker(){

                protected void doInBackground() {
                    try {
                        StiReport report = StiSerializeManager.deserializeReport((File)new File("Reports/" + StiTreeReportsPanel.this.currentReport.getFile()));
                        report.setStatusHandler(new StiStatusHandler(){

                            public void updateStatus(String status) {
                                StiTreeReportsPanel.this.demo.updateStatus(status);
                            }
                        });
                        report.getDictionary().getDatabases().addAll((Collection)demoDatabaseCollection);
                        report.setCalculationMode(StiCalculationMode.Interpretation);
                        report.Render(false);
                        StiDocument document = new StiDocument(report);
                        StiTreeReportsPanel.this.demo.getStiViewerPanel().getStiViewModel().getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("DocumentFileLoaded", (Object)document));
                    }
                    catch (Exception e) {
                        StiExceptionProvider.show((Throwable)e, (Frame)StiTreeReportsPanel.this.demo);
                    }
                    finally {
                        StiTreeReportsPanel.this.demo.updateStatus(" ");
                    }
                }
            };
            renderWorker.execute();
        }
    }

    public void buildReportsTree(Document document) {
        List<Category> categories = this.parseCategories(document);
        DefaultMutableTreeNode treeItems = this.getTreeNode(categories);
        this.tree.setModel(new DefaultTreeModel(treeItems, false));
        this.tree.expandRow(1);
    }

    private DefaultMutableTreeNode getTreeNode(List<Category> categories) {
        DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode(StiLocalization.getValue((String)"Localization", (String)"RootReportsNode"));
        for (Category category : categories) {
            DefaultMutableTreeNode createdNode = new DefaultMutableTreeNode(category);
            parentNode.add(createdNode);
            this.fillTreeNodeFromBookmarks(category.getReports(), createdNode);
        }
        return parentNode;
    }

    private void fillTreeNodeFromBookmarks(List<Report> reports, DefaultMutableTreeNode parentNode) {
        for (Report report : reports) {
            DefaultMutableTreeNode createdNode = new DefaultMutableTreeNode(report);
            parentNode.add(createdNode);
        }
    }

    private List<Category> parseCategories(Document document) {
        ArrayList<Category> categories = new ArrayList<Category>();
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node categoryNode = nodeList.item(i);
            if (categoryNode.getNodeType() != 1 || !"Category".equals(categoryNode.getNodeName())) continue;
            Category category = new Category(categoryNode);
            NodeList reportNodes = categoryNode.getChildNodes();
            for (int j = 0; j < reportNodes.getLength(); ++j) {
                Node reportNode = reportNodes.item(j);
                if (reportNode.getNodeType() != 1 || !"Report".equals(reportNode.getNodeName())) continue;
                Report report = new Report(reportNode);
                NodeList subNodes = reportNode.getChildNodes();
                for (int k = 0; k < subNodes.getLength(); ++k) {
                    Node subNode = subNodes.item(k);
                    if (subNode.getNodeType() != 1) continue;
                    if ("desc".equals(subNode.getNodeName())) {
                        report.setDescription(subNode.getTextContent());
                        continue;
                    }
                    if ("video".equals(subNode.getNodeName())) {
                        report.getVideos().add(new Video(subNode));
                        continue;
                    }
                    if (!"sample".equals(subNode.getNodeName())) continue;
                    report.getSamples().add(new Sample(subNode));
                }
                category.getReports().add(report);
            }
            categories.add(category);
        }
        return categories;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (selNode == null) {
            return;
        }
        Object nodeInfo = selNode.getUserObject();
        this.currentReport = nodeInfo instanceof Report ? (Report)nodeInfo : null;
        this.demo.reportSelected(this.currentReport);
    }

    static {
        String demoDir = "Data/";
        StiXmlDatabase xmlDatabase = null;
        try {
            xmlDatabase = new StiXmlDatabase("Demo", demoDir + "Demo.xsd", demoDir + "Demo.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StiJDBCDatabase oleDatabase = StiTreeReportsPanel.getOleDatabase(demoDir);
        demoDatabaseCollection.add(xmlDatabase);
        demoDatabaseCollection.add((Object)oleDatabase);
    }

    public class Sample {
        public static final String NODE_NAME = "sample";
        private String name;
        private String vb;
        private String description;
        private String sln;

        public Sample(Node node) {
            this.name = node.getAttributes().getNamedItem("name").getNodeValue();
            this.description = node.getAttributes().getNamedItem("desc").getNodeValue();
            this.vb = node.getAttributes().getNamedItem("vb").getNodeValue();
            this.sln = node.getTextContent();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVb() {
            return this.vb;
        }

        public void setVb(String vb) {
            this.vb = vb;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getSln() {
            return this.sln;
        }

        public void setSln(String sln) {
            this.sln = sln;
        }
    }

    public class Video {
        public static final String NODE_NAME = "video";
        private String name;
        private String description;
        private String url;

        public Video(Node node) {
            this.name = node.getAttributes().getNamedItem("name").getNodeValue();
            this.description = node.getAttributes().getNamedItem("desc").getNodeValue();
            this.url = node.getTextContent();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public class Report {
        public static final String NODE_NAME = "Report";
        private String name;
        private String file;
        private String description;
        private List<Video> videos = new ArrayList<Video>();
        private List<Sample> samples = new ArrayList<Sample>();

        public Report(Node node) {
            this.name = node.getAttributes().getNamedItem("name").getNodeValue();
            this.file = node.getAttributes().getNamedItem("file").getNodeValue();
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<Video> getVideos() {
            return this.videos;
        }

        public void setVideos(List<Video> videos) {
            this.videos = videos;
        }

        public List<Sample> getSamples() {
            return this.samples;
        }

        public void setSamples(List<Sample> samples) {
            this.samples = samples;
        }
    }

    public class Category {
        public static final String NODE_NAME = "Category";
        private String name;
        private List<Report> reports = new ArrayList<Report>();

        public Category(Node node) {
            this.name = node.getAttributes().getNamedItem("name").getNodeValue();
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<Report> getReports() {
            return this.reports;
        }

        public void setReports(List<Report> reports) {
            this.reports = reports;
        }
    }
}

