/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.demo.panels;

import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.demo.Demo;
import com.stimulsoft.demo.panels.StiTreeReportsPanel;
import com.stimulsoft.viewer.utils.StiURLHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class StiReportsPanel
extends JPanel {
    private static final long serialVersionUID = 8222644998214803543L;
    private StiTreeReportsPanel treeReportPanel;
    private JLabel statusLabel;

    public StiReportsPanel(Demo demo) {
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(300, 5000));
        this.setBackground(Color.WHITE);
        JPanel logoPanel = new JPanel(new FlowLayout(1));
        logoPanel.add(new JLabel(StiResourceUtil.loadIcon((String)"/logo.png")));
        this.add(logoPanel);
        logoPanel.setMaximumSize(new Dimension(300, 70));
        logoPanel.setBackground(Color.WHITE);
        DottedSeparator seperator = new DottedSeparator(0);
        this.add(seperator);
        this.treeReportPanel = new StiTreeReportsPanel(demo);
        this.add(this.treeReportPanel);
        try {
            InputStream stream = StiResourceUtil.getStream((String)"/Reports_en.xml");
            this.treeReportPanel.buildReportsTree(StiXmlHelper.loadXML((InputStream)stream));
            stream.close();
        }
        catch (Exception e) {
            System.err.println("Unable to parse /Reports_en.xml");
            e.printStackTrace();
        }
        this.statusLabel = new JLabel(" ");
        this.add(this.statusLabel);
        this.statusLabel.setAlignmentX(0.5f);
        this.statusLabel.setForeground(new Color(128, 128, 128));
        this.statusLabel.setFont(new Font("Arail", 0, 11));
        seperator = new DottedSeparator(0);
        this.add(seperator);
        JLabel hyperlinkLabel = new JLabel(StiResourceUtil.loadIcon((String)"/Hyperlink.png"));
        this.add(hyperlinkLabel);
        hyperlinkLabel.setBorder(BorderFactory.createEmptyBorder(11, 0, 10, 0));
        hyperlinkLabel.setPreferredSize(new Dimension(300, 22));
        hyperlinkLabel.setMaximumSize(new Dimension(300, 22));
        hyperlinkLabel.setAlignmentX(0.5f);
        hyperlinkLabel.setCursor(Cursor.getPredefinedCursor(12));
        hyperlinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StiURLHelper.openURL((String)"www.stimulsoft.com");
            }
        });
    }

    public void updateStatus(String status) {
        this.statusLabel.setText(status);
    }

    private static class DottedSeparator
    extends JSeparator {
        private static final long serialVersionUID = 6075753579826589595L;
        private static final float[] DASH = new float[]{3.0f, 1.0f};
        private static final Color DASH_COLOR = new Color(207, 209, 212);
        private static final BasicStroke STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, DASH, 2.0f);

        public DottedSeparator(int horizontal) {
            super(horizontal);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(DASH_COLOR);
            g2d.setStroke(STROKE);
            g2d.drawLine(0, 0, this.getWidth(), 0);
        }
    }
}

