/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.demo.button;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiGraphicsHelper;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class StiDemoButton
extends JLabel {
    public static final int BUTTON_STYLE_0 = 0;
    public static final int BUTTON_STYLE_1 = 1;
    private static final long serialVersionUID = -3209501005168505815L;
    private static final Color TEXT_BRUSH = new Color(39, 38, 37);
    private static final Color SELECTED_TEXT_BRUSH = new Color(110, 110, 110);
    private static final Font HEADER_FONT = new Font("Arial", 0, 22);
    private static final Dimension BUTTON_DIMENSION = new Dimension(430, 68);
    private static final Font TEXT_FONT = new Font("Arial", 0, 13);
    private GeneralPath path = new GeneralPath(0);
    private GeneralPath path1 = new GeneralPath(0);
    private int buttonStyle = 0;
    private boolean isMouseOver = false;
    private boolean isPressed = false;
    private ImageIcon image;
    private String header = "";
    private String text = "";

    public StiDemoButton(String text, ImageIcon image, int buttonStyle) {
        this(text, image);
        this.buttonStyle = buttonStyle;
    }

    public StiDemoButton(String text, ImageIcon image) {
        this.image = image;
        if (text.contains("<br>")) {
            int startIndex = text.indexOf("<br>");
            this.header = text.substring(0, startIndex);
            this.text = text.substring(startIndex += 4, text.length());
        } else {
            this.text = text;
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.path.moveTo(8.0f, 0.0f);
        this.path.lineTo(59.0f, 0.0f);
        this.path.quadTo(67.0f, 0.0f, 67.0f, 8.0f);
        this.path.lineTo(67.0f, 59.0f);
        this.path.quadTo(67.0f, 67.0f, 59.0f, 67.0f);
        this.path.lineTo(8.0f, 67.0f);
        this.path.quadTo(0.0f, 67.0f, 0.0f, 59.0f);
        this.path.lineTo(0.0f, 8.0f);
        this.path.quadTo(0.0f, 0.0f, 8.0f, 0.0f);
        this.path.closePath();
        this.path1.moveTo(9.0f, 1.0f);
        this.path1.lineTo(58.0f, 1.0f);
        this.path1.quadTo(66.0f, 1.0f, 66.0f, 8.0f);
        this.path1.lineTo(66.0f, 58.0f);
        this.path1.quadTo(66.0f, 66.0f, 58.0f, 66.0f);
        this.path1.lineTo(9.0f, 66.0f);
        this.path1.quadTo(1.0f, 66.0f, 1.0f, 58.0f);
        this.path1.lineTo(1.0f, 9.0f);
        this.path1.quadTo(1.0f, 1.0f, 9.0f, 1.0f);
        this.path1.closePath();
        this.setMinimumSize(BUTTON_DIMENSION);
        this.setMaximumSize(BUTTON_DIMENSION);
        this.setPreferredSize(BUTTON_DIMENSION);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                StiDemoButton.this.isPressed = false;
                StiDemoButton.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                StiDemoButton.this.isPressed = true;
                StiDemoButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StiDemoButton.this.isMouseOver = false;
                StiDemoButton.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                StiDemoButton.this.isMouseOver = true;
                StiDemoButton.this.repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        StiGraphicsHelper.setRenderingHints((Graphics2D)g2d);
        this.drawStyle(g2d);
        if (this.image != null) {
            g2d.drawImage(this.image.getImage(), 18, 18, 32, 32, null);
        }
        g2d.setFont(HEADER_FONT);
        g2d.setPaint(this.isMouseOver ? SELECTED_TEXT_BRUSH : TEXT_BRUSH);
        g.drawString(this.header, 70, 16);
        StiGraphics stiGraphics = new StiGraphics((Graphics)g2d);
        ArrayList lines = new ArrayList();
        stiGraphics.drawAttributedString(this.text, TEXT_FONT, new StiRectangle(72L, 20L, (long)(StiDemoButton.BUTTON_DIMENSION.width - 70), (long)(StiDemoButton.BUTTON_DIMENSION.height - 20)), Boolean.valueOf(false), Boolean.valueOf(true), StiTextHorAlignment.Width, 1.0f, Boolean.valueOf(true), lines, Boolean.valueOf(false));
    }

    private void drawStyle(Graphics2D g) {
        Color paintColor1 = null;
        Color paintColor2 = null;
        Color pen1Color1 = null;
        Color pen1Color2 = null;
        Color pen2Color1 = null;
        Color pen2Color2 = null;
        if (this.isMouseOver) {
            if (this.isPressed) {
                if (this.buttonStyle == 0) {
                    paintColor1 = new Color(243, 126, 85, 255);
                    paintColor2 = new Color(203, 74, 29, 255);
                    pen1Color1 = new Color(213, 69, 22, 255);
                    pen1Color2 = new Color(212, 68, 22, 255);
                    pen2Color1 = new Color(242, 167, 142, 255);
                    pen2Color2 = new Color(212, 140, 116, 255);
                } else {
                    paintColor1 = new Color(255, 217, 63, 255);
                    paintColor2 = new Color(217, 174, 3, 255);
                    pen1Color1 = new Color(210, 169, 6, 255);
                    pen1Color2 = new Color(210, 171, 18, 255);
                    pen2Color1 = new Color(247, 224, 132, 255);
                    pen2Color2 = new Color(216, 193, 104, 255);
                }
            } else if (this.buttonStyle == 0) {
                paintColor1 = new Color(255, 166, 101, 255);
                paintColor2 = new Color(225, 126, 53, 255);
                pen1Color1 = new Color(227, 128, 55, 255);
                pen1Color2 = new Color(226, 127, 55, 255);
                pen2Color1 = new Color(249, 195, 155, 255);
                pen2Color2 = new Color(225, 173, 134, 255);
            } else {
                paintColor1 = new Color(255, 199, 101, 255);
                paintColor2 = new Color(225, 171, 77, 255);
                pen1Color1 = new Color(223, 156, 60, 255);
                pen1Color2 = new Color(222, 160, 70, 255);
                pen2Color1 = new Color(249, 213, 156, 255);
                pen2Color2 = new Color(225, 191, 135, 255);
            }
        } else if (this.buttonStyle == 0) {
            paintColor1 = new Color(255, 144, 63, 255);
            paintColor2 = new Color(216, 93, 3, 255);
            pen1Color1 = new Color(223, 107, 21, 255);
            pen1Color2 = new Color(219, 103, 17);
            pen2Color1 = new Color(255, 158, 87, 255);
            pen2Color2 = new Color(218, 152, 104, 255);
        } else {
            paintColor1 = new Color(255, 185, 63, 255);
            paintColor2 = new Color(216, 138, 3, 255);
            pen1Color1 = new Color(218, 140, 27, 255);
            pen1Color2 = new Color(214, 136, 24);
            pen2Color1 = new Color(247, 203, 131, 255);
            pen2Color2 = new Color(217, 175, 105, 255);
        }
        g.setPaint(new GradientPaint(0.0f, 0.0f, paintColor1, 67.0f, 67.0f, paintColor2));
        g.fill(this.path);
        g.setPaint(new GradientPaint(0.0f, 0.0f, pen1Color1, 67.0f, 67.0f, pen1Color2));
        g.draw(this.path);
        g.setPaint(new GradientPaint(1.0f, 1.0f, pen2Color1, 66.0f, 66.0f, pen2Color2));
        g.draw(this.path1);
    }

    public int getButtonStyle() {
        return this.buttonStyle;
    }

    public void setButtonStyle(int buttonStyle) {
        this.buttonStyle = buttonStyle;
    }
}

