/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.demo;

import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.report.StiExportManager;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.dataSources.StiDataTableSource;
import com.stimulsoft.report.dictionary.databases.StiJsonDatabase;
import com.stimulsoft.report.json.StiJsonToDataSetConverterV2;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Test2 {
    public static void main(String[] args) throws Exception {
        String dataDir = "c:/310/";
        StiReport report = StiSerializeManager.deserializeReport((File)new File(dataDir + "/json_.mrt"));
        Test2.createJson("customRoot1", new StiJsonDatabase("iJSON1", dataDir + "/Bilancio.json"), report);
        report.render();
        FileOutputStream fos = new FileOutputStream(dataDir + "/report.pdf");
        StiExportManager.exportPdf((StiReport)report, (OutputStream)fos);
        fos.close();
        Runtime.getRuntime().exec("explorer \"" + dataDir + "\\report.pdf\"");
    }

    public static void createJson(String name, StiJsonDatabase database, StiReport report) throws FileNotFoundException, JSONException, IOException {
        report.getDictionary().getDatabases().add((Object)database);
        DataSet dataSet = StiJsonToDataSetConverterV2.getDataSet((Object)database.getJSONObject(report));
        for (DataTable table : dataSet.getTables()) {
            String tableName = table.getName();
            StiDataTableSource source = new StiDataTableSource(String.format("%s.%s", database.getName(), table.getName()), tableName, tableName);
            source.setDictionary(report.getDictionary());
            source.setColumns(new StiDataColumnsCollection());
            for (StiDataColumn column : table.getColumns()) {
                source.getColumns().add(column);
            }
            report.getDictionary().getDataSources().add((Object)source);
        }
    }
}

