/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser.value;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.viewer.controls.visual.StiFlatButton;
import com.stimulsoft.viewer.form.TextEditorDialog;
import com.stimulsoft.viewer.requestfromuser.StiDialogInfoValue;
import com.stimulsoft.viewer.requestfromuser.StiNewRequestFromUserDialogCreatingEventArgs;
import com.stimulsoft.viewer.requestfromuser.StiRequestFromUserHelper;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestComboBox;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import com.stimulsoft.viewer.requestfromuser.value.IStiValueItemControl;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTextArea;

public class StiValueStringItemControl
extends StiRequestPanel
implements IStiValueItemControl {
    private static final long serialVersionUID = -3245853900353155288L;
    private JTextArea textBox;
    private StiRequestComboBox comboBox;
    private StiFlatButton textEditor;
    private JFrame parentFrame;

    public StiValueStringItemControl(StiVariable variable, JFrame parentFrame) {
        super(null);
        this.parentFrame = parentFrame;
        this.initializeComponent();
        boolean allowUserValues = variable.getDialogInfo().getAllowUserValues();
        String defaultValue = StiValidationUtil.isNullOrEmpty((String)variable.getValue()) ? "" : variable.getValue();
        List list = variable.getDialogInfoItems();
        if (list.size() > 0) {
            this.createComboBox();
            for (StiVariableItem item : list) {
                StiDialogInfoValue infoValue = new StiDialogInfoValue(item);
                this.comboBox.addItem(infoValue);
                if (!defaultValue.equals(item.getKeyObject())) continue;
                this.comboBox.setSelectedIndex(this.comboBox.getItemCount() - 1);
            }
            if (this.comboBox.getSelectedIndex() == -1) {
                this.comboBox.setSelectedIndex(0);
            }
            StiRequestFromUserHelper.checkDropDownWidth(this.comboBox, list);
            if (!allowUserValues) {
                this.comboBox.setEditable(false);
            }
        } else {
            this.createTextBox();
            this.textBox.setEditable(allowUserValues);
            this.textBox.setText(defaultValue);
        }
        if (this.comboBox != null) {
            StiNewRequestFromUserDialogCreatingEventArgs arg = new StiNewRequestFromUserDialogCreatingEventArgs(variable, this.comboBox.getWidth());
            this.comboBox.setWidth(arg.getWidth());
        } else if (this.textBox != null) {
            StiNewRequestFromUserDialogCreatingEventArgs stiNewRequestFromUserDialogCreatingEventArgs = new StiNewRequestFromUserDialogCreatingEventArgs(variable, this.textBox.getWidth());
        }
        if (this.textBox != null && this.textBox.isVisible()) {
            this.setWidth((int)Math.round(this.textEditor.getBounds().getX() + this.textEditor.getBounds().getWidth() + 2.0));
        } else if (this.comboBox != null && this.comboBox.isVisible()) {
            this.setWidth(this.comboBox.getRight() + 2);
        }
    }

    @Override
    public Object getValue() {
        if (this.comboBox != null) {
            return this.comboBox.getSelectedItem() instanceof StiDialogInfoValue ? ((StiDialogInfoValue)this.comboBox.getSelectedItem()).getKey() : this.comboBox.getSelectedItem().toString();
        }
        return this.textBox.getText();
    }

    private void createTextBox() {
        this.textBox = new JTextArea();
        this.textBox.setLocation(0, 0);
        this.textBox.setSize(155, 20);
        this.add(this.textBox);
        this.textEditor = new StiFlatButton(null, StiResourceUtil.loadIcon((String)"/images/CursorPen.png"), StiLocalization.getValue((String)"FormTitles", (String)"TextEditorForm"), null);
        this.textEditor.setLocation(160, 0);
        this.textEditor.setSize(20, 20);
        this.textEditor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add(this.textEditor);
        this.textEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TextEditorDialog(StiValueStringItemControl.this.parentFrame, StiValueStringItemControl.this.textBox).setVisible(true);
            }
        });
    }

    private void createComboBox() {
        this.comboBox = new StiRequestComboBox(true);
        this.comboBox.setMaximumRowCount(25);
        this.comboBox.setEditable(true);
        this.comboBox.setLocation(0, 0);
        this.comboBox.setSize(180, 21);
        this.add(this.comboBox);
    }

    private void initializeComponent() {
        this.setName("StiValueStringItemControl");
        this.setSize(180, 21);
    }
}

