/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.logic;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.exception.StiExceptionProvider;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.worker.StiSimpleWorker;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.dialogs.StiProgressInformationDialog;
import com.stimulsoft.report.dictionary.databases.StiDatabaseCollection;
import com.stimulsoft.report.dictionary.databases.StiJDBCDatabase;
import com.stimulsoft.report.dictionary.databases.StiXmlDatabase;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.saveLoad.StiDocument;
import com.stimulsoft.report.viewer.StiPageViewMode;
import com.stimulsoft.viewer.enums.StiViewState;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.events.StiViewerEventDispatcher;
import com.stimulsoft.viewer.utils.StiPageNumberHelper;
import com.stimulsoft.viewer.utils.StiPaintQueue;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.JFrame;

public class StiViewModel
implements StiViewEventable {
    public static final String CURRENT_PAGE_PROPERTY = "currentPage";
    public static final String CURRENT_DISLPAY_PAGE_PROPERTY = "currentDisplayPage";
    public static final String DOCUMENT_PROPERTY = "document";
    public static final String PAGE_VIEW_MODE_PROPERTY = "pageViewMode";
    public static final String VIEW_STATE_PROPERTY = "viewState";
    public static final String ZOOM_PROPERTY = "zoom";
    private Double zoom = 1.0;
    private StiDocument document;
    private StiViewerEventDispatcher eventDispatcher = new StiViewerEventDispatcher();
    private Integer currentPage = -1;
    private Integer currentDisplayPage = -1;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private StiPageViewMode pageViewMode = StiPageViewMode.SinglePage;
    private JFrame parentFrame;
    private Boolean thumbnailPannelVisible = true;
    private Boolean bookmarksPannelVisible = true;
    private StiViewState viewState = StiViewState.ZoomOnePage;
    private Dimension viewMultipleDimension;
    private Boolean fullScreen = false;
    private File loadedReportFile;
    private StiPaintQueue paintQueue = new StiPaintQueue();
    private static StiDatabaseCollection demoDatabaseCollection = new StiDatabaseCollection();

    private static StiJDBCDatabase getOleDatabase(String demoDir) {
        String accessFile = demoDir + "NWIND.MDB";
        String jdbcUrl = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + accessFile + ";DriverID=22;READONLY=true}";
        String jdbcDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
        StiJDBCDatabase oleDatabase = new StiJDBCDatabase("NorthWind", jdbcUrl, jdbcDriver, "", "");
        return oleDatabase;
    }

    public StiViewModel(JFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.paintQueue.start();
    }

    public void loadDocumentFile(final File documentFile, boolean showProgress) {
        if (documentFile.getAbsolutePath().toLowerCase().endsWith(".mdc")) {
            final StiProgressInformationDialog progress = new StiProgressInformationDialog(this.getParentFrame());
            if (showProgress) {
                progress.setIndeterminate(true);
                progress.setAllowClose(false);
                progress.start(StiLocalization.getValue((String)"Report", (String)"LoadingReport"));
            }
            StiSimpleWorker deserializationWorker = new StiSimpleWorker(){

                protected void doInBackground() throws StiException {
                    StiDocument result = StiSerializeManager.deserializeDocument((File)documentFile);
                    if (!progress.getIsBreaked()) {
                        StiViewModel.this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("DocumentFileLoaded", result, documentFile));
                    }
                }

                protected void finished() {
                    progress.close();
                }
            };
            deserializationWorker.execute();
        } else if (documentFile.getAbsolutePath().toLowerCase().endsWith(".mrt")) {
            Runnable rendering = new Runnable(){

                @Override
                public void run() {
                    try {
                        StiReport report = StiSerializeManager.deserializeReport((File)documentFile);
                        report.setCalculationMode(StiCalculationMode.Interpretation);
                        report.Render(true);
                        StiDocument document = new StiDocument(report);
                        StiViewModel.this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("DocumentFileLoaded", document));
                    }
                    catch (Exception e) {
                        StiExceptionProvider.show((Throwable)e, null);
                    }
                }
            };
            Thread renderingThread = new Thread(rendering);
            renderingThread.start();
        }
    }

    public StiReport getReport() {
        return this.document != null ? this.document.getReport() : null;
    }

    public StiDocument getDocument() {
        return this.document;
    }

    public Integer getPagesCount() {
        return this.document != null ? this.document.getReport().getRenderedPages().size() : 0;
    }

    public Integer getDisplayPagesCount() {
        return this.document != null ? StiPageNumberHelper.getDisplayPagesCount(this.document.getReport()) : 0;
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public void setDocument(StiDocument document) {
        StiDocument oldDocument = this.document;
        this.document = document;
        this.propertyChangeSupport.firePropertyChange(DOCUMENT_PROPERTY, oldDocument, document);
    }

    protected void setCurrentPage(Integer currentPage, Boolean changeDisplayNumber) {
        Integer oldCurrentPage = this.currentPage;
        this.currentPage = currentPage;
        if (changeDisplayNumber.booleanValue()) {
            StiPage page = this.document.getReport().getRenderedPages().get(currentPage.intValue());
            this.setCurrentDisplayPage(StiPageNumberHelper.getPageStartNumber(page), false);
        }
        this.propertyChangeSupport.firePropertyChange(CURRENT_PAGE_PROPERTY, oldCurrentPage, currentPage);
    }

    public Integer getCurrentDisplayPage() {
        return this.currentDisplayPage;
    }

    public void setCurrentDisplayPage(Integer currentDisplayPage, Boolean changeCurrentPage) {
        Integer oldCurrentDisplayPane = this.currentDisplayPage;
        this.currentDisplayPage = currentDisplayPage;
        if (changeCurrentPage.booleanValue()) {
            this.setCurrentPage(StiPageNumberHelper.getPageNumberFromDisplayNumber(currentDisplayPage, this.document.getReport()), false);
        }
        this.propertyChangeSupport.firePropertyChange(CURRENT_DISLPAY_PAGE_PROPERTY, oldCurrentDisplayPane, currentDisplayPage);
    }

    public Double getZoom() {
        return this.zoom;
    }

    public void setZoom(Double zoom) {
        Double oldZoom = this.zoom;
        this.zoom = zoom;
        this.propertyChangeSupport.firePropertyChange(ZOOM_PROPERTY, oldZoom, zoom);
    }

    public StiPageViewMode getPageViewMode() {
        return this.pageViewMode;
    }

    public void setPageViewMode(StiPageViewMode pageViewMode) {
        StiPageViewMode oldPageViewMode = this.pageViewMode;
        this.pageViewMode = pageViewMode;
        this.propertyChangeSupport.firePropertyChange(PAGE_VIEW_MODE_PROPERTY, oldPageViewMode, pageViewMode);
    }

    @Override
    public StiViewerEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public Boolean getThumbnailPannelVisible() {
        return this.thumbnailPannelVisible;
    }

    public void setThumbnailPannelVisible(Boolean thumbnailPannelVisible) {
        this.thumbnailPannelVisible = thumbnailPannelVisible;
    }

    public Boolean getBookmarksPannelVisible() {
        return this.bookmarksPannelVisible;
    }

    public void setBookmarksPannelVisible(Boolean bookmarksPannelVisible) {
        this.bookmarksPannelVisible = bookmarksPannelVisible;
    }

    public StiViewState getViewState() {
        return this.viewState;
    }

    public void setViewState(StiViewState viewState) {
        StiViewState oldViewState = this.viewState;
        this.viewState = viewState;
        this.propertyChangeSupport.firePropertyChange(VIEW_STATE_PROPERTY, (Object)oldViewState, (Object)viewState);
    }

    public Dimension getViewMultipleDimension() {
        return this.viewMultipleDimension;
    }

    public void setViewMultipleDimension(Dimension viewMultipleDimension) {
        this.viewMultipleDimension = viewMultipleDimension;
    }

    public Boolean getFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(Boolean fullScreen) {
        this.fullScreen = fullScreen;
    }

    public File getLoadedReportFile() {
        return this.loadedReportFile;
    }

    public void setLoadedReportFile(File loadedReportFile) {
        this.loadedReportFile = loadedReportFile;
    }

    public StiPaintQueue getPaintQueue() {
        return this.paintQueue;
    }

    static {
        String demoDir = "Data/";
        StiXmlDatabase xmlDatabase = new StiXmlDatabase("Demo", demoDir + "Demo.xsd", demoDir + "Demo.xml");
        StiJDBCDatabase oleDatabase = StiViewModel.getOleDatabase(demoDir);
        demoDatabaseCollection.add((Object)xmlDatabase);
        demoDatabaseCollection.add((Object)oleDatabase);
    }
}

