/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form.export;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiPowerPointExportSettings;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.form.export.StiBaseExportDialog;
import java.awt.HeadlessException;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class StiPpt2007ExportDialog
extends StiBaseExportDialog {
    private static final long serialVersionUID = 1002759048695744932L;
    protected JComboBox imageResolutionComboBox;
    protected JComboBox imageQualityComboBox;

    private StiPpt2007ExportDialog(JFrame parent, Boolean sendEmail, int curretPage) throws HeadlessException {
        super(parent, sendEmail, curretPage);
    }

    public static StiExportSettings showDialog(JFrame parent, Boolean sendEmail, int curretPage) {
        StiPpt2007ExportDialog dialog = new StiPpt2007ExportDialog(parent, sendEmail, curretPage);
        dialog.setVisible(true);
        return dialog.okResult ? dialog.getExportSettings() : null;
    }

    @Override
    protected void buildComponent() {
        super.buildComponent();
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageResolution")), "ImageResolution"), 0, 0, 1);
        this.imageResolutionComboBox = new JComboBox<String>(RTF_IMAGE_RESOLUTIONS);
        this.addC(this.imageResolutionComboBox, 1, 0, 1, 0.5);
        this.addC(new JLabel("dpi"), 2, 0, 1, 0.0);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageQuality")), "ImageQuality"), 0, 1, 1);
        this.imageQualityComboBox = new JComboBox<String>(IMAGE_QUALITY);
        this.addC(this.imageQualityComboBox, 1, 1, 1, 0.5);
        this.addC(new JLabel("%"), 2, 1, 1, 0.0);
        this.expandPanel.setWidth(370);
        this.expandPanel.setExpandedHeight(120);
        this.loadSettings();
    }

    @Override
    protected StiExportSettings getExportSettings() {
        StiPowerPointExportSettings settings = new StiPowerPointExportSettings(super.getExportSettings());
        settings.setImageQuality((float)(Integer.parseInt((String)this.imageQualityComboBox.getSelectedItem()) / 100));
        int imageResolution = 75;
        try {
            imageResolution = Integer.parseInt(((String)this.imageResolutionComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
        }
        catch (Exception e) {
            System.out.println("Unable to parse Image Resulution value: " + this.imageResolutionComboBox.getSelectedItem());
            e.printStackTrace();
        }
        settings.setImageResolution((float)imageResolution);
        return settings;
    }

    private void loadSettings() {
        this.selectStringCombo(this.imageResolutionComboBox, StiSettings.getStringValue((String)"Export", (String)"Ppt2007ImageResolution", (String)"100"));
        this.selectStringCombo(this.imageQualityComboBox, StiSettings.getStringValue((String)"Export", (String)"Ppt2007ImageQuality", (String)"75"));
        this.expandPanel.setExpanded(StiSettings.getBoolValue((String)"Export", (String)"Ppt2007SettingsPanelExpanded", (Boolean)false));
        this.openAfterExport.setSelected(StiSettings.getBoolValue((String)"Export", (String)"Ppt2007OpenAfterExport", (Boolean)true));
    }

    @Override
    protected void saveSettings() {
        StiSettings.setStringValue((String)"Export", (String)"Ppt2007ImageResolution", (String)((String)this.imageResolutionComboBox.getSelectedItem()));
        StiSettings.setStringValue((String)"Export", (String)"Ppt2007ImageQuality", (String)((String)this.imageQualityComboBox.getSelectedItem()));
        StiSettings.setBoolValue((String)"Export", (String)"Ppt2007SettingsPanelExpanded", (Boolean)this.expandPanel.getExpanded());
        StiSettings.setBoolValue((String)"Export", (String)"Ppt2007OpenAfterExport", (Boolean)this.openAfterExport.isSelected());
    }
}

