/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form.export;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.report.enums.StiRangeType;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiPageRangeExportSettings;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.viewer.controls.visual.StiFlatButton;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.form.export.StiExpandPanel;
import com.stimulsoft.viewer.utils.StiReportExportSettings;
import com.stimulsoft.viewer.utils.StiTooltipUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class StiBaseExportDialog
extends JDialog
implements StiReportExportSettings {
    private static final long serialVersionUID = -744024289885320828L;
    protected static final int PANEL_WIDTH = 370;
    protected static final int BOTTOM_PANEL_HEIGHT = 65;
    protected static final int RANGE_PANEL_HEIGHT = 145;
    protected static String[] ZOOM_VALUES = new String[]{"25%", "50%", "75%", "100%", "125%", "150%", "200%"};
    protected static String[] IMAGE_RESOLUTIONS = new String[]{"50", "75", "100", "150", "200", "300", "600"};
    protected static String[] RTF_IMAGE_RESOLUTIONS = new String[]{"10", "25", "50", "75", "100", "200", "300", "400", "500"};
    protected static String[] IMAGE_QUALITY = new String[]{"25", "50", "75", "100"};
    protected static ImageIcon INFO_IMG = StiResourceUtil.loadIcon((String)"/icons/Information.png");
    private StiFlatButton okButton;
    private StiFlatButton cancelButton;
    protected JRadioButton allPagesRadio;
    protected JRadioButton currentPageRadio;
    protected JRadioButton pagesRadio;
    protected JTextField pagesTextField;
    protected JCheckBox openAfterExport;
    protected StiExpandPanel expandPanel;
    protected JPanel centerPanel1;
    protected JPanel bottomButtonPanel;
    private boolean sendEmail;
    private int currentPage = 1;
    protected boolean okResult = false;
    protected GridBagConstraints c;

    protected StiBaseExportDialog(JFrame parent, Boolean sendEmail) throws HeadlessException {
        this(parent, sendEmail, 1);
    }

    public StiBaseExportDialog(JFrame parent, Boolean sendEmail, int currentPage) throws HeadlessException {
        super(parent, StiLocalization.getValue((String)"Export", (String)"title"), true);
        this.currentPage = currentPage;
        this.sendEmail = sendEmail;
        this.buildComponent();
        this.bindEvents();
        this.setDefaultCloseOperation(2);
        this.setSize(370, 420);
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        this.updateSize();
    }

    protected void buildComponent() {
        this.buildComponent(true);
    }

    protected void buildComponent(Boolean buildRange) {
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        if (buildRange.booleanValue()) {
            this.centerPanel1 = new JPanel(new FlowLayout(1));
            JPanel pageRangePanel = new JPanel();
            pageRangePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StiLocalization.getValue((String)"Report", (String)"RangePage")));
            pageRangePanel.setLayout(new BoxLayout(pageRangePanel, 1));
            Dimension pageRangeDimension = new Dimension(360, 145);
            pageRangePanel.setMinimumSize(pageRangeDimension);
            pageRangePanel.setPreferredSize(pageRangeDimension);
            this.allPagesRadio = new JRadioButton(StiLocalization.getValue((String)"Report", (String)"RangeAll"));
            this.allPagesRadio.setSelected(true);
            this.allPagesRadio.setMargin(new Insets(-1, 2, 0, 0));
            this.currentPageRadio = new JRadioButton(StiLocalization.getValue((String)"Report", (String)"RangeCurrentPage"));
            JPanel pagesPanel = new JPanel();
            pagesPanel.setLayout(new BoxLayout(pagesPanel, 0));
            pagesPanel.setAlignmentX(0.0f);
            this.pagesRadio = new JRadioButton(StiLocalization.getValue((String)"Report", (String)"RangePages"));
            this.pagesTextField = new JTextField();
            this.pagesTextField.setMaximumSize(new Dimension(150, 22));
            JLabel imgLabel = this.createInfo("RangePages");
            imgLabel.setHorizontalAlignment(2);
            imgLabel.setMaximumSize(new Dimension(188, 22));
            pagesPanel.add(this.pagesRadio);
            pagesPanel.add(imgLabel);
            pagesPanel.add(this.pagesTextField);
            this.pagesTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    StiBaseExportDialog.this.pagesRadio.setSelected(true);
                }
            });
            StiLabel rangeLabel = new StiLabel("<html>" + StiLocalization.getValue((String)"Report", (String)"RangeInfo") + "</html>");
            rangeLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 0));
            pageRangePanel.add(this.addInfo(this.allPagesRadio, "PageAll"));
            pageRangePanel.add(this.addInfo(this.currentPageRadio, "CurrentPage"));
            pageRangePanel.add(pagesPanel);
            pageRangePanel.add(rangeLabel);
            ButtonGroup group = new ButtonGroup();
            group.add(this.allPagesRadio);
            group.add(this.currentPageRadio);
            group.add(this.pagesRadio);
            this.centerPanel1.add(pageRangePanel);
            this.add(this.centerPanel1);
            this.expandPanel = new StiExpandPanel(StiLocalization.getValue((String)"Export", (String)"Settings"));
            this.centerPanel1.add(this.expandPanel);
            this.expandPanel.setLayout(new GridBagLayout());
        }
        JPanel bottomFloayLayout = new JPanel(new FlowLayout(1));
        JPanel bottomBoxLayout = new JPanel();
        bottomBoxLayout.setLayout(new BoxLayout(bottomBoxLayout, 1));
        Dimension dd = new Dimension(370, 65);
        bottomFloayLayout.setMaximumSize(dd);
        bottomBoxLayout.setPreferredSize(dd);
        JPanel openExportPanel = new JPanel(new FlowLayout(0));
        this.openAfterExport = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"OpenAfterExport"));
        openExportPanel.add(this.openAfterExport);
        openExportPanel.add(this.createInfo("OpenAfterExport"));
        this.openAfterExport.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        bottomBoxLayout.add(openExportPanel);
        bottomBoxLayout.add(new JSeparator());
        this.bottomButtonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new StiFlatButton(StiLocalization.getHingValue((String)"Buttons", (String)"Ok"));
        this.bottomButtonPanel.add(this.okButton);
        this.cancelButton = new StiFlatButton(StiLocalization.getHingValue((String)"Buttons", (String)"Cancel"));
        this.bottomButtonPanel.add(this.cancelButton);
        this.bottomButtonPanel.setBorder(BorderFactory.createEmptyBorder(buildRange != false ? 4 : 0, 5, 0, 5));
        bottomBoxLayout.add(this.bottomButtonPanel);
        bottomFloayLayout.add(bottomBoxLayout);
        this.add(bottomFloayLayout);
    }

    protected void addC(JComponent component, int gx, int gy, int width, double weightx, int insetsL) {
        this.c.gridx = gx;
        this.c.gridy = gy;
        this.c.weightx = weightx;
        this.c.gridwidth = width;
        this.c.insets = new Insets(3, insetsL, 3, 3);
        this.expandPanel.add((Component)component, this.c);
    }

    protected void addC(JComponent component, int gx, int gy, int width) {
        this.addC(component, gx, gy, width, 0.5);
    }

    protected void addC(JComponent component, int gx, int gy, int width, double weightx) {
        this.addC(component, gx, gy, width, weightx, 3);
    }

    protected JPanel addInfo(JComponent component, String hint) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(0.0f);
        panel.add(component);
        panel.add(this.createInfo(hint));
        return panel;
    }

    protected JLabel createInfo(String hint) {
        JLabel imgLabel = new JLabel(INFO_IMG);
        imgLabel.setToolTipText(StiTooltipUtil.restrictTooltip(StiLocalization.getValue((String)"HelpViewer", (String)hint)));
        imgLabel.setHorizontalAlignment(2);
        return imgLabel;
    }

    private void bindEvents() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StiBaseExportDialog.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiBaseExportDialog.this.okResult = true;
                StiBaseExportDialog.this.dispose();
            }
        });
        if (this.expandPanel != null) {
            this.expandPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    StiBaseExportDialog.this.updateSize();
                }
            });
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                StiBaseExportDialog.this.saveSettings();
            }
        });
        int c = 2;
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.bottomButtonPanel.getInputMap(c).put(ks, "hotPress");
        this.bottomButtonPanel.getActionMap().put("hotPress", new AbstractAction(){
            private static final long serialVersionUID = 8935120531469858422L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StiBaseExportDialog.this.dispose();
            }
        });
    }

    protected void updateSize() {
        if (this.centerPanel1 != null) {
            this.setSize(370, 210 + this.expandPanel.getHeight() + 45);
        } else {
            this.setSize(370, 98);
        }
    }

    protected StiExportSettings getExportSettings() {
        StiPageRangeExportSettings settings = new StiPageRangeExportSettings(null);
        if (this.centerPanel1 != null) {
            StiRangeType rangeType = this.allPagesRadio.isSelected() ? StiRangeType.All : (this.currentPageRadio.isSelected() ? StiRangeType.CurrentPage : StiRangeType.Pages);
            settings.setPageRange(new StiPagesRange(rangeType, this.pagesTextField.getText(), this.currentPage));
        }
        settings.setOpenAfterExport(this.openAfterExport.isSelected());
        settings.setSendEmail(this.sendEmail);
        this.saveSettings();
        return settings;
    }

    protected void saveSettings() {
    }

    protected boolean selectStringCombo(JComboBox comboBox, String value) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            if (!(comboBox.getItemAt(i) instanceof String) || !value.equals(comboBox.getItemAt(i))) continue;
            comboBox.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    protected JPanel createXPanel(Border border) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(border);
        return panel;
    }
}

