/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.viewer.controls.visual.StiFlatButton;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.controls.visual.StiTextField;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.logic.StiViewModel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class StiGoToPageDialog
extends JDialog {
    private static final long serialVersionUID = -744024289885320828L;
    private StiViewModel model;
    private StiViewEventable eventable;
    private StiTextField pageNumberTextField;
    private StiFlatButton okButton;
    private StiFlatButton cancelButton;

    public StiGoToPageDialog(StiViewModel model, StiViewEventable eventable, JFrame parent) throws HeadlessException {
        super(parent, StiLocalization.getValue((String)"FormViewer", (String)"GoToPage"), true);
        this.model = model;
        this.eventable = eventable;
        this.buildComponent();
        this.bindEvents();
        this.setDefaultCloseOperation(2);
        this.setSize(300, 120);
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private void buildComponent() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel centerPanel = new JPanel();
        StiLabel numberOfPageLabel = new StiLabel(StiLocalization.getValue((String)"FormViewer", (String)"LabelPageN"));
        this.pageNumberTextField = new StiTextField();
        this.pageNumberTextField.setPreferredSize(new Dimension(100, 22));
        StiLabel pagesCountLabel = new StiLabel(String.format(StiLocalization.getFormatValue((String)"FormViewer", (String)"PageofM"), this.model.getDisplayPagesCount()));
        this.pageNumberTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiGoToPageDialog.this.changePage();
            }
        });
        centerPanel.add(numberOfPageLabel);
        centerPanel.add(this.pageNumberTextField);
        centerPanel.add(pagesCountLabel);
        this.add(centerPanel);
        this.add(new JSeparator());
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        this.okButton = new StiFlatButton(StiLocalization.getHingValue((String)"Buttons", (String)"Ok"));
        bottomPanel.add(this.okButton);
        this.cancelButton = new StiFlatButton(StiLocalization.getHingValue((String)"Buttons", (String)"Cancel"));
        bottomPanel.add(this.cancelButton);
        this.add(bottomPanel);
    }

    private void bindEvents() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StiGoToPageDialog.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiGoToPageDialog.this.changePage();
            }
        });
        int c = 2;
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.cancelButton.getInputMap(c).put(ks, "hotPress");
        this.cancelButton.getActionMap().put("hotPress", new AbstractAction(){
            private static final long serialVersionUID = 8935120531469858422L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StiGoToPageDialog.this.dispose();
            }
        });
    }

    private void changePage() {
        try {
            Integer pageNumber = Integer.parseInt(this.pageNumberTextField.getText().trim());
            if (pageNumber > 0 && pageNumber <= this.model.getDisplayPagesCount()) {
                this.eventable.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("CurrentDisplayPageChanged", pageNumber));
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Unable to change page" + numberFormatException);
            numberFormatException.printStackTrace();
        }
        finally {
            this.dispose();
        }
    }
}

