/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.controls.dialogs;

import com.stimulsoft.base.exception.StiExceptionProvider;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.base.worker.StiSimpleWorker;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.IStiProgressInformation;
import com.stimulsoft.report.dialogs.StiProgressInformationDialog;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.options.ViewerOptions;
import com.stimulsoft.report.saveLoad.StiEncryptedDocumentSLService;
import com.stimulsoft.report.saveLoad.StiSLActions;
import com.stimulsoft.report.saveLoad.StiSLService;
import com.stimulsoft.viewer.controls.dialogs.StiFileSaveDialog;
import com.stimulsoft.viewer.controls.dialogs.StiSavePasswordDialog;
import com.stimulsoft.viewer.logic.StiViewController;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.utils.StiViewSettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class StiSaveDialog
implements StiViewSettings {
    private StiExportSettings exportSettings;
    private StiViewModel model;
    private StiSLService service;
    private IStiProgressInformation progress = new StiProgressInformationDialog(null);
    private File file;
    private StiViewController controller;

    public StiSaveDialog(StiViewModel model, StiExportSettings exportSettings, StiViewController controller) {
        this.exportSettings = exportSettings;
        this.model = model;
        this.controller = controller;
        this.progress.setIndeterminate(true);
    }

    public void save() {
        if (this.model.getReport() != null) {
            if (this.model.getReport().getRenderedPages() != null && this.model.getReport().getRenderedPages().getCacheMode()) {
                return;
            }
            String path = ViewerOptions.Windows.getReportSaveLoadPath();
            if (StiValidationUtil.isNullOrEmpty((String)path)) {
                path = StiSettings.getStringValue((String)"viewer", (String)"ReportSaveLoadPath", (String)"");
            }
            String fileName = this.model.getLoadedReportFile() != null ? this.model.getLoadedReportFile().getName().substring(0, this.model.getLoadedReportFile().getName().indexOf(".")) : this.model.getReport().getReportAlias();
            StiFileSaveDialog stiFileChooser = new StiFileSaveDialog(StiExportFormat.Document, this.model.getReport(), fileName, path, StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save));
            stiFileChooser.setDialogTitle(StiLocalization.getValue((String)"FormViewer", (String)"Save"));
            int chooserResult = stiFileChooser.showSaveDialog(null);
            if (chooserResult == 0) {
                char[] key = null;
                File saveFile = stiFileChooser.getFile();
                if (saveFile.getAbsolutePath().toLowerCase().endsWith(".mdx")) {
                    StiSavePasswordDialog savePasswordDialog = new StiSavePasswordDialog();
                    savePasswordDialog.setVisible(true);
                    if (savePasswordDialog.isOkResult()) {
                        key = savePasswordDialog.getPassword();
                    } else {
                        return;
                    }
                }
                this.file = stiFileChooser.getFile();
                if (StiValidationUtil.isNullOrEmpty((String)ViewerOptions.Windows.getReportSaveLoadPath())) {
                    StiSettings.setStringValue((String)"viewer", (String)"ReportSaveLoadPath", (String)this.file.getParent());
                }
                StiFileSaveDialog.StiExtensionFilter filter = (StiFileSaveDialog.StiExtensionFilter)stiFileChooser.getFileFilter();
                this.service = (StiSLService)StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save).get(filter.getIndex());
                if (this.service instanceof StiEncryptedDocumentSLService) {
                    ((StiEncryptedDocumentSLService)this.service).setKey(new String(key));
                }
                this.progress.start(StiLocalization.getValue((String)"Report", (String)"SavingReport"));
                StiSimpleWorker saveWorker = new StiSimpleWorker(){

                    protected void doInBackground() {
                        FileOutputStream fos = null;
                        try {
                            fos = new FileOutputStream(StiSaveDialog.this.file);
                            StiSaveDialog.this.service.save(StiSaveDialog.this.model.getReport(), (OutputStream)fos);
                        }
                        catch (Throwable e) {
                            StiExceptionProvider.show((Throwable)e, null);
                        }
                        finally {
                            StiSaveDialog.this.progress.close();
                            try {
                                if (fos != null) {
                                    fos.flush();
                                    fos.close();
                                }
                                if (StiSaveDialog.this.progress.getIsBreaked()) {
                                    StiSaveDialog.this.file.delete();
                                } else if (StiSaveDialog.this.controller != null) {
                                    StiSaveDialog.this.controller.exportFinished(StiSaveDialog.this.exportSettings, StiSaveDialog.this.file, new ArrayList<File>());
                                }
                            }
                            catch (Throwable e) {
                                StiExceptionProvider.show((Throwable)e, null);
                            }
                        }
                    }
                };
                saveWorker.execute();
            }
        }
    }
}

