/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.controls.dialogs;

import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.saveLoad.StiSLService;
import com.stimulsoft.viewer.utils.StiViewSettings;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class StiFileSaveDialog
extends JFileChooser
implements StiViewSettings {
    private static final long serialVersionUID = -2336166278751809560L;

    public StiFileSaveDialog(StiExportFormat format, StiReport report, String fileName, String path, List<StiSLService> slServices) {
        this.setAcceptAllFileFilterUsed(false);
        this.setCurrentDirectory(new File(path));
        this.setSelectedFile(new File(this.correctFileName(fileName)));
        if (format == StiExportFormat.Document) {
            if (slServices != null) {
                for (int i = 0; i < slServices.size(); ++i) {
                    StiSLService service = slServices.get(i);
                    String documentFilter = service.getFilter();
                    this.addChoosableFileFilter(new StiExtensionFilter(documentFilter.substring(0, documentFilter.indexOf("|")), documentFilter.substring(documentFilter.indexOf("|") + 3), i));
                    this.setFileFilter(this.getChoosableFileFilters()[0]);
                }
            }
        } else {
            this.addChoosableFileFilter(new StiExtensionFilter(format.getFileFilter().substring(0, format.getFileFilter().indexOf("|")), format.getExtension(), 0));
        }
    }

    public StiFileSaveDialog(StiExportFormat format, StiReport report, String fileName) {
        this(format, report, fileName, StiSettings.getStringValue((String)"viewer", (String)"ReportSaveLoadPath", (String)""), null);
    }

    private String correctFileName(String fileName) {
        String error = "/\\:*?\"<>|";
        char[] chars = fileName.toCharArray();
        for (int index = 0; index < chars.length; ++index) {
            int i = error.indexOf(chars[index]);
            if (i == -1) continue;
            chars[index] = 95;
        }
        return new String(chars);
    }

    public File getFile() {
        if (this.getSelectedFile() != null) {
            File result = this.getSelectedFile();
            String extension = ((StiExtensionFilter)this.getFileFilter()).getExtension();
            if (!result.getAbsolutePath().toLowerCase().endsWith(extension.toLowerCase())) {
                result = new File(result.getAbsolutePath() + "." + extension.toLowerCase());
            }
            return result;
        }
        return null;
    }

    protected void approve() {
        super.approveSelection();
        StiSettings.setStringValue((String)"viewer", (String)"ReportSaveLoadPath", (String)this.getFile().getParent());
    }

    @Override
    public void approveSelection() {
        if (this.getFile() != null && this.getFile().exists()) {
            if (0 == JOptionPane.showConfirmDialog(this, String.format("File %s already exist.\n Overwrite it?", this.getFile().getAbsolutePath()), "Overwrite confirm", 0)) {
                this.approve();
            }
        } else {
            this.approve();
        }
    }

    public class StiExtensionFilter
    extends FileFilter {
        private String[] extensions;
        private String description;
        private int index;

        public StiExtensionFilter(String description, String extension, int index) {
            this(description, new String[]{extension}, index);
        }

        public StiExtensionFilter(String description, String[] extensions, int index) {
            this.description = description;
            this.extensions = (String[])extensions.clone();
            this.index = index;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            int count = this.extensions.length;
            String path = file.getAbsolutePath();
            for (int i = 0; i < count; ++i) {
                String ext = this.extensions[i];
                if (!path.endsWith(ext) || path.charAt(path.length() - ext.length() - 1) != '.') continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description == null ? this.extensions[0] : this.description;
        }

        public String getExtension() {
            return this.extensions[0];
        }

        public int getIndex() {
            return this.index;
        }
    }
}

