/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiXmlTextWriter {
    Document doc;
    Stack<Element> stack = new Stack();

    public void writeStartDocument() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
    }

    public Element writeStartElement(String elName) {
        Element element = this.doc.createElement(elName);
        if (this.stack.isEmpty()) {
            this.doc.appendChild(element);
        } else {
            ((Element)this.stack.lastElement()).appendChild(element);
        }
        this.stack.push(element);
        return element;
    }

    public void writeAttributeString(String name, String value) {
        ((Element)this.stack.lastElement()).setAttribute(name, value);
    }

    public void setAttribute(String name, String value) {
        this.writeAttributeString(name, value);
    }

    public void writeEndElement() {
        this.stack.pop();
    }

    public void writeFullEndElement() {
        this.writeEndElement();
    }

    public void writeString(String value) {
        ((Element)this.stack.lastElement()).setTextContent(value);
    }

    public void writeElementString(String name, String value) {
        Element el = this.doc.createElement(name);
        ((Element)this.stack.lastElement()).appendChild(el);
        el.setTextContent(value);
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setDoc(Document doc) {
        this.doc = doc;
    }

    public void setTextContent(String value) {
        this.writeString(value);
    }

    public Element getElement() {
        return (Element)this.stack.lastElement();
    }

    public Stack<Element> getStack() {
        return this.stack;
    }
}

