/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.utils.XmlObject;
import com.stimulsoft.lib.io.StiCloseUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class StiXmlMarshalUtil {
    private StiXmlMarshalUtil() {
    }

    public static <T extends XmlObject> void marshal(T xmlObject, OutputStream os) throws StiException {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])xmlObject.getClassesToBeBound());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal(xmlObject, os);
        }
        catch (Exception e) {
            throw new StiException(e);
        }
        finally {
            StiCloseUtil.close((Closeable)os);
        }
    }

    public static <T extends XmlObject> T unmarshal(InputStream is, Class<T> clazz) throws StiException {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller u = jc.createUnmarshaller();
            XmlObject xmlObject = (XmlObject)u.unmarshal(is);
            return (T)xmlObject;
        }
        catch (Exception e) {
            throw new StiException(e);
        }
        finally {
            StiCloseUtil.close((Closeable)is);
        }
    }
}

