/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import com.stimulsoft.base.serializing.utils.XMLChar;
import com.stimulsoft.base.utils.StiResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class StiXmlHelper {
    public static Document loadXML(String filePath) throws ParserConfigurationException, SAXException, IOException {
        File file = new File(filePath);
        return StiXmlHelper.loadXML(file);
    }

    public static Document loadXML(File file) throws ParserConfigurationException, SAXException, IOException {
        InputStream is = null;
        is = file.exists() ? new FileInputStream(file) : StiResourceUtil.getStream(file.getAbsolutePath());
        return StiXmlHelper.loadXML(is);
    }

    public static Document loadXML(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(is);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static String serialize(Document doc) throws IOException, TransformerException {
        return StiXmlHelper.serialize(doc, false, null);
    }

    public static String serialize(Document doc, boolean omitXMLDeclaration, Element element) throws IOException, TransformerException {
        return StiXmlHelper.serialize(doc, omitXMLDeclaration, true, element);
    }

    public static String serialize(Document doc, boolean omitXMLDeclaration, boolean indent, Element element) throws IOException, TransformerException {
        return StiXmlHelper.serialize(doc, omitXMLDeclaration, indent, element, "UTF-8");
    }

    public static String serialize(Document doc, boolean omitXMLDeclaration, boolean indent, Element element, String encoding) throws IOException, TransformerException {
        StringWriter out = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", encoding);
        serializer.setOutputProperty("indent", indent ? "yes" : "no");
        serializer.setOutputProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
        if (element != null) {
            serializer.transform(new DOMSource(element), new StreamResult(out));
        } else {
            serializer.transform(new DOMSource(doc), new StreamResult(out));
        }
        return ((Object)out).toString();
    }

    public static String serialize(Document doc, Element el) throws IOException, TransformerException {
        StringWriter out = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.transform(new DOMSource(el), new StreamResult(out));
        return ((Object)out).toString();
    }

    public static String validName(String value) {
        if (!XMLChar.isNameStart(value.charAt(0))) {
            value = "_" + value;
        }
        for (int i = 1; i < value.length(); ++i) {
            if (XMLChar.isName(value.charAt(i))) continue;
            value = value.replace(value.charAt(i), '_');
        }
        return value;
    }

    public static Element writeElementString(Document doc, Element element, String elName, String value) {
        Element el = doc.createElement(elName);
        element.appendChild(el);
        el.setTextContent(value);
        return el;
    }
}

