/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StiReflectUtill {
    private StiReflectUtill() {
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name) {
        Iterable<Method> allMethods = StiReflectUtill.getMethodsUpTo(clazz, null);
        for (Method field : allMethods) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static Iterable<Method> getMethodsUpTo(Class<?> startClass, Class<?> exclusiveParent) {
        ArrayList<Method> currentClassFields = new ArrayList<Method>(Arrays.asList(startClass.getDeclaredMethods()));
        Class<?> parentClass = startClass.getSuperclass();
        if (!(parentClass == null || exclusiveParent != null && parentClass.equals(exclusiveParent))) {
            List parentClassFields = (List)StiReflectUtill.getMethodsUpTo(parentClass, exclusiveParent);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    public static Field getDeclaredField(Class<?> clazz, String name) {
        Iterable<Field> allFields = StiReflectUtill.getFieldsUpTo(clazz, null);
        for (Field field : allFields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static Iterable<Field> getFieldsUpTo(Class<?> startClass, Class<?> exclusiveParent) {
        ArrayList<Field> currentClassFields = new ArrayList<Field>(Arrays.asList(startClass.getDeclaredFields()));
        Class<?> parentClass = startClass.getSuperclass();
        if (!(parentClass == null || exclusiveParent != null && parentClass.equals(exclusiveParent))) {
            List parentClassFields = (List)StiReflectUtill.getFieldsUpTo(parentClass, exclusiveParent);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    public static boolean isPrimitivParameterizedType(Class<?> clazz) {
        try {
            Type[] types = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
            return !(types[0] instanceof Class);
        }
        catch (Exception e) {
            Type[] interfaces = clazz.getGenericInterfaces();
            return interfaces != null && interfaces.length > 0 && !(interfaces[0] instanceof Class);
        }
    }

    public static Class<?> getTypeList(Class<?> clazz) {
        Type[] types = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        Type type = types[0];
        try {
            return (Class)type;
        }
        catch (Exception e) {
            throw new RuntimeException("may be collection " + clazz + " is not extends StiValueCollection<Type> and get a class element cannot be");
        }
    }
}

