/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import java.util.HashMap;
import java.util.Map;

public class StiParsedParameters {
    private final HashMap<String, String> lowerKeyValue = new HashMap();
    private final HashMap<String, String> lowerKeyOriginalKey = new HashMap();

    public StiParsedParameters(String string, String regex) {
        this.parseParameters(string, regex.charAt(0));
    }

    private void parseParameters(String string, char delimiter) {
        boolean readingKey = false;
        boolean readingValue = false;
        Character quotes = null;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        for (int index = 0; index < string.length(); ++index) {
            char ch = string.charAt(index);
            if (!(readingKey || readingValue || Character.isWhitespace(ch) || ch == delimiter)) {
                readingKey = true;
                key = new StringBuilder();
                value = new StringBuilder();
                quotes = null;
            }
            if (readingKey) {
                if (ch != '=') {
                    key.append(ch);
                } else {
                    if ((ch = string.charAt(++index)) == '\'' || ch == '\"') {
                        quotes = Character.valueOf(ch);
                        ch = string.charAt(++index);
                    }
                    readingKey = false;
                    readingValue = true;
                }
            }
            if (!readingValue) continue;
            if (ch == delimiter && quotes == null || quotes != null && ch == quotes.charValue() || index == string.length() - 1) {
                if (!(ch == delimiter && quotes == null || quotes != null && ch == quotes.charValue())) {
                    value.append(ch);
                }
                readingValue = false;
                this.putKeyValue(key.toString(), value.toString().trim());
                continue;
            }
            value.append(ch);
        }
    }

    private void putKeyValue(String originalKey, String value) {
        String lowerKey = this.getLowerKey(originalKey);
        this.lowerKeyValue.put(lowerKey, value);
        this.lowerKeyOriginalKey.put(lowerKey, originalKey);
    }

    private String getLowerKey(String originalKey) {
        return originalKey.trim().toLowerCase();
    }

    public String getValue(String key) {
        String lowerKey = this.getLowerKey(key);
        return this.lowerKeyValue.get(lowerKey);
    }

    public String getOriginalKey(String lowerKey) {
        return this.lowerKeyOriginalKey.get(lowerKey);
    }

    public HashMap<String, String> getLowerKeyValue() {
        return this.lowerKeyValue;
    }

    public HashMap<String, String> getOriginalKeyValue(Map<String, String> keyValue) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> element : keyValue.entrySet()) {
            String originalKey = this.getOriginalKey(element.getKey());
            result.put(originalKey, element.getValue());
        }
        return result;
    }

    public HashMap<String, String> getOriginalKeyValue() {
        return this.getOriginalKeyValue(this.lowerKeyValue);
    }
}

