/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system;

import com.stimulsoft.base.system.StiConverterDateFormatToJava;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class StiTimeOnly
implements Cloneable,
Comparable<Object> {
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final List<String> TIME_FORMATS = new ArrayList<String>();
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private LocalTime time = LocalTime.now();

    public int getHour() {
        return this.time.getHour();
    }

    public int getMinute() {
        return this.time.getMinute();
    }

    public int getSecond() {
        return this.time.getSecond();
    }

    public int getMillisecond() {
        return this.time.getNano() / 1000;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public String toString() {
        return this.time.format(FORMATTER);
    }

    public static StiTimeOnly valueOf(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof StiTimeOnly) {
            return (StiTimeOnly)o;
        }
        if (o instanceof String) {
            return new StiTimeOnly((String)o);
        }
        if (o instanceof LocalTime) {
            return new StiTimeOnly((LocalTime)o);
        }
        if (o instanceof StiDateTime) {
            return new StiTimeOnly(((StiDateTime)o).zonedDateTime().toLocalTime());
        }
        if (o instanceof ZonedDateTime) {
            return new StiTimeOnly(((ZonedDateTime)o).toLocalTime());
        }
        if (o instanceof Calendar) {
            return new StiTimeOnly((Calendar)o);
        }
        if (o instanceof Date) {
            return new StiTimeOnly((Date)o);
        }
        throw new IllegalArgumentException("Illegal class " + o.getClass());
    }

    public StiTimeOnly() {
    }

    public StiTimeOnly(LocalTime value) {
        this.time = value;
    }

    public StiTimeOnly(String value) {
        RuntimeException ex = null;
        for (String format : TIME_FORMATS) {
            ex = null;
            try {
                this.time = LocalTime.parse(value, DateTimeFormatter.ofPattern(format));
            }
            catch (RuntimeException e) {
                ex = e;
            }
            if (ex != null) continue;
            return;
        }
        if (ex != null) {
            throw ex;
        }
    }

    public StiTimeOnly(Calendar calendar) {
        this.time = LocalTime.from(calendar.toInstant());
    }

    public StiTimeOnly(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.time = LocalTime.from(calendar.toInstant());
    }

    @Override
    public int compareTo(Object o) {
        return this.time.compareTo(((StiTimeOnly)o).time);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof StiTimeOnly && ((StiTimeOnly)obj).time.equals(this.time);
    }

    public String format(String format, Locale locale) {
        if (StiValidationUtil.isNotEmpty((String)format) || locale != null) {
            DateTimeFormatter df = StiConverterDateFormatToJava.getTimeFormat(format, locale);
            return this.format(df);
        }
        return this.toString();
    }

    public String format(DateTimeFormatter df) {
        String result = df.format(this.time);
        if (result != null) {
            result = result.replaceAll("\\\\", "");
        }
        return result;
    }

    public StiDateTime toDateTime() {
        return new StiDateTime(ZonedDateTime.now().with(this.time.atOffset(ZoneOffset.UTC)));
    }

    static {
        TIME_FORMATS.add(TIME_FORMAT);
        TIME_FORMATS.add("hh:mm:ss a");
        TIME_FORMATS.add("h:m:s a");
        TIME_FORMATS.add("HH:mm");
        TIME_FORMATS.add("H:m");
        TIME_FORMATS.add("H:m:s");
        TIME_FORMATS.add("hh:mm a");
        TIME_FORMATS.add("h:m a");
    }
}

