/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.settings;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.mail.StiMailProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class StiConfig {
    private static StiConfig config;
    private static StiConfig cfg;
    private StiMailProperties mailConf = new StiMailProperties();
    private Properties properties;

    public StiConfig() throws StiException {
        try {
            this.loadDefaultFromResource();
        }
        catch (Exception e) {
            throw new StiException(e);
        }
    }

    public StiConfig(Properties properties) throws StiException {
        try {
            this.setProperties(properties);
        }
        catch (Exception e) {
            throw new StiException(e);
        }
    }

    protected void loadDefaultFromResource() throws IOException {
        InputStream stream = StiConfig.class.getResourceAsStream("/com/stimulsoft/defconfigure.properties");
        if (stream != null) {
            this.properties = new Properties();
            this.properties.load(stream);
        }
    }

    protected void setProperties(Properties properties) {
        this.properties = properties;
    }

    public static synchronized void init(StiConfig config) throws StiException {
        try {
            StiConfig.config = config;
        }
        catch (Exception e) {
            throw new StiException(e);
        }
    }

    public static StiConfig getConfig() {
        return config == null ? cfg : config;
    }

    public StiMailProperties getMailConfig() {
        return this.mailConf;
    }

    public void setMailConfig(StiMailProperties mailConf) {
        this.mailConf = mailConf;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    static {
        try {
            cfg = new StiConfig();
        }
        catch (StiException e) {
            e.printStackTrace();
        }
    }
}

