/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;

public class StiDocumentItemAttribut {
    public static final StiDocumentItemAttribut DEFAULT = new StiDocumentItemAttribut();
    public String attributName;
    public String attributValue;

    public StiDocumentItemAttribut() {
    }

    public StiDocumentItemAttribut(String attributName, String attributValue) {
        this.attributName = attributName;
        this.attributValue = attributValue;
    }

    public StiDocumentItemAttribut(String attributName, Integer attributValue) {
        this(attributName, String.valueOf(attributValue));
    }

    public StiDocumentItemAttribut(String attributName, IStiSerializableToString value) {
        this(attributName, value.serialize());
    }

    public StiDocumentItemAttribut(String attributName, boolean value) {
        this.attributName = attributName;
        this.attributValue = value ? "true" : "False";
    }

    public StiDocumentItemAttribut(String attributName, Enum<?> value) {
        this(attributName, value.toString());
    }

    public StiDocumentItemAttribut(String attributName, Object attributValue) {
        String attributValueStr = StiSerializTypeConverter.getDataByClass(attributValue);
        this.attributName = attributName;
        this.attributValue = attributValueStr;
    }

    public String getString(String attributName, String defaulValue) {
        return this.attributValue != null ? this.attributValue : defaulValue;
    }

    public boolean getBoolean(String attributName) {
        return Boolean.parseBoolean(this.attributValue);
    }

    public <T extends Enum<?>> T getEnum(String attributName, T defaulValue) {
        return this.attributValue != null ? this.getEnum(defaulValue) : defaulValue;
    }

    public <T extends Enum<?>> T getEnum(T defaulValue) {
        return (T)Enum.valueOf(defaulValue.getClass(), this.attributValue);
    }

    public <T extends IStiSerializableToString> T getSerializeObject(String attributName, Class<T> clazz) {
        return this.attributValue != null ? (T)this.newInstance(clazz, this.attributValue) : null;
    }

    public <T extends IStiSerializableToString> T getSerializeObject(String attributName, Class<T> clazz, T defaultValue) {
        T serializeObject = this.getSerializeObject(attributName, clazz);
        return serializeObject != null ? serializeObject : defaultValue;
    }

    private <T extends IStiSerializableToString> T newInstance(Class<T> clazz, String value) {
        try {
            IStiSerializableToString newInstance = (IStiSerializableToString)clazz.newInstance();
            newInstance.deserialize(value);
            return (T)newInstance;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create class: " + clazz, e);
        }
    }

    public void addColection(String name, Object value) {
    }
}

