/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.serializing.StiClassProperties;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiDeserializerReport;
import com.stimulsoft.base.serializing.StiDocumentItemAttributes;
import com.stimulsoft.base.serializing.StiProperties;
import com.stimulsoft.base.serializing.StiProperty;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToAttributes;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToDocument;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.lib.utils.StiXmlUtil;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StiDeserializerDocument
extends StiDeserializerReport {
    private final HashMap<String, String> propertiesNameForMdc = new HashMap();

    public StiDeserializerDocument(StiDeserializerControler controler, Class<? extends IStiSerializable> clazz, Node rootNode) {
        super(controler, clazz, rootNode);
        this.propertiesNameForMdc.put("bh", "Brush");
        this.propertiesNameForMdc.put("tb", "TextBrush");
        this.propertiesNameForMdc.put("br", "Border");
        this.propertiesNameForMdc.put("d", "Dock");
        this.propertiesNameForMdc.put("fn", "Font");
        this.propertiesNameForMdc.put("text", "Text");
        this.propertiesNameForMdc.put("rc", "Rectangle");
        this.propertiesNameForMdc.put("to", "TextOptions");
        this.propertiesNameForMdc.put("va", "VertAlignment");
        this.propertiesNameForMdc.put("ha", "HorAlignment");
        this.propertiesNameForMdc.put("tf", "TextFormat");
    }

    public StiDeserializerDocument(StiDeserializerControler controler, IStiSerializable instance, Node rootNode) {
        super(controler, instance, rootNode);
        this.propertiesNameForMdc.put("bh", "Brush");
        this.propertiesNameForMdc.put("tb", "TextBrush");
        this.propertiesNameForMdc.put("br", "Border");
        this.propertiesNameForMdc.put("d", "Dock");
        this.propertiesNameForMdc.put("fn", "Font");
        this.propertiesNameForMdc.put("text", "Text");
        this.propertiesNameForMdc.put("rc", "Rectangle");
        this.propertiesNameForMdc.put("to", "TextOptions");
        this.propertiesNameForMdc.put("va", "VertAlignment");
        this.propertiesNameForMdc.put("ha", "HorAlignment");
        this.propertiesNameForMdc.put("tf", "TextFormat");
    }

    @Override
    protected IStiSerializable deserializeObject(Class<? extends IStiSerializable> javaClass, Node currentItem) {
        boolean forceSerializeToReport;
        Node forceNode = currentItem != null && currentItem.getParentNode() != null ? currentItem.getParentNode().getAttributes().getNamedItem("forceSerializeToReport") : null;
        boolean bl = forceSerializeToReport = forceNode != null && "true".equals(forceNode.getTextContent());
        if (StiSerializerUtil.isSerializableToDocument(javaClass) && !forceSerializeToReport) {
            IStiSerializableToAttributes newInstance = (IStiSerializableToAttributes)StiDeserializerDocument.newInstance(javaClass);
            this.deserializeChildren(newInstance, currentItem);
            return newInstance;
        }
        if (this.propertys != null && this.propertys.getClazz() != null && this.propertys.getClazz().getName().equals("com.stimulsoft.webdesigner.helper.StiGroup") && currentItem.getTextContent() != null && currentItem.getTextContent().startsWith("com.stimulsoft.report.components.textFormats")) {
            String textContent = currentItem.getTextContent();
            try {
                IStiSerializableToDocument newInstance = (IStiSerializableToDocument)Class.forName(textContent.split(",")[0]).newInstance();
                newInstance.deserialize(textContent);
                return newInstance;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return super.deserializeObject(javaClass, currentItem);
    }

    protected void deserializeChildren(IStiSerializableToAttributes instance, Node objectItem) {
        StiProperties propertys = StiClassProperties.getPropertys(instance);
        NamedNodeMap childNodes = objectItem.getAttributes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node propertyAttribut = childNodes.item(i);
            if (!StiXmlUtil.isAttributeNode((Node)propertyAttribut) || this.isServiceAttribute(propertyAttribut)) continue;
            this.procesingAttribut(instance, propertys, propertyAttribut);
        }
    }

    private void procesingAttribut(IStiSerializableToAttributes instance, StiProperties propertys, Node propertyAttribut) {
        String shortName = propertyAttribut.getNodeName();
        StiProperty property = propertys.getByShortName(shortName);
        Object propertyValue = null;
        if (property == null) {
            return;
        }
        Class<?> propertyClass = property.returnClass();
        propertyValue = property.isObject() ? this.deserializeObject(propertyClass, propertyAttribut) : this.deserializePrimitiv(property, propertyAttribut, instance);
        this.setPropertyInInstance(instance, property, propertyValue);
    }

    private boolean isServiceAttribute(Node node) {
        return StiDocumentItemAttributes.isServiceAttribute(node.getNodeName());
    }

    private void setPropertyInInstance(IStiSerializableToAttributes instance, StiProperty property, Object propertyValue) {
        try {
            property.getSETMetod().invoke((Object)instance, propertyValue);
        }
        catch (Exception e) {
            throw new RuntimeException("\nUnabele t set value: '" + propertyValue + "' class '" + (propertyValue != null ? propertyValue.getClass() : "not defined") + "'\n method'" + property.getSETMetod() + "'", e);
        }
    }

    private StiDocumentItemAttributes getItemAttributes(Node currentItem) {
        StiDocumentItemAttributes result = new StiDocumentItemAttributes();
        NamedNodeMap attributes = currentItem.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node item = attributes.item(i);
            result.addNotEmpty(item.getNodeName(), item.getTextContent());
        }
        result.finishAdd();
        return result;
    }

    @Override
    protected StiProperty getProperty(Node currentItem) {
        return this.propertys.getByShortNameOrName(currentItem.getNodeName());
    }
}

