/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;

public class LongRange
extends Range {
    public long From = 0L;
    public long To = 0L;

    @Override
    public String getRangeName() {
        return "LongRange";
    }

    @Override
    public StiSystemTypeEnum getRangeType() {
        return StiSystemTypeEnum.SystemInt64;
    }

    @Override
    public Object getFromObject() {
        return this.From;
    }

    @Override
    public void setFromObject(Object value) {
        if (value instanceof Long) {
            this.From = (Long)value;
        }
    }

    @Override
    public Object getToObject() {
        return this.To;
    }

    @Override
    public void setToObject(Object value) {
        if (value instanceof Long) {
            this.To = (Long)value;
        }
    }

    public final boolean Contains(long value) {
        return this.From <= value && this.To >= value;
    }

    public LongRange() {
    }

    public LongRange(long from, long to) {
        this.From = from;
        this.To = to;
    }

    @Override
    public String serialize() {
        String data = String.format(this.getSerializeName() + ",%s,%s", this.getFromObject(), this.getToObject());
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.From = StiSerializTypeConverter.stringToInteger(values[1]);
        this.To = StiSerializTypeConverter.stringToInteger(values[2]);
    }

    @Override
    protected String getSerializeName() {
        return "Long";
    }

    public static LongRange fromSerializeValue(String str) {
        LongRange result = new LongRange();
        result.deserialize(str);
        return result;
    }
}

