/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;

public class ByteRange
extends Range {
    public byte From = 0;
    public byte To = 0;

    public ByteRange() {
    }

    public ByteRange(byte from, byte to) {
        this.From = from;
        this.To = to;
    }

    @Override
    public String getRangeName() {
        return "ByteRange";
    }

    @Override
    public StiSystemTypeEnum getRangeType() {
        return StiSystemTypeEnum.SystemByte;
    }

    @Override
    public Object getFromObject() {
        return this.From;
    }

    @Override
    public void setFromObject(Object value) {
        if (value instanceof Byte) {
            this.From = (Byte)value;
        }
    }

    @Override
    public Object getToObject() {
        return this.To;
    }

    @Override
    public void setToObject(Object value) {
        if (value instanceof Byte) {
            this.To = (Byte)value;
        }
    }

    public final boolean Contains(byte value) {
        return this.From <= value && this.To >= value;
    }

    @Override
    public String serialize() {
        String data = String.format(this.getSerializeName() + ",%s,%s", this.getFromObject(), this.getToObject());
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.From = StiSerializTypeConverter.stringToByte(values[1]);
        this.To = StiSerializTypeConverter.stringToByte(values[2]);
    }

    @Override
    protected String getSerializeName() {
        return "Byte";
    }

    public static ByteRange fromSerializeValue(String str) {
        ByteRange result = new ByteRange();
        result.deserialize(str);
        return result;
    }
}

