/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.parser;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiActivator;
import com.stimulsoft.base.StiConvert;
import com.stimulsoft.base.StiLexer;
import com.stimulsoft.base.StiToken;
import com.stimulsoft.base.StiTokenType;
import com.stimulsoft.base.StiTypeFinder;
import com.stimulsoft.base.design.IStiReport;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiHatchStyle;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.helper.StiValueHelper;
import com.stimulsoft.base.parser.SecurityCode;
import com.stimulsoft.base.parser.StiCSharpScriptParserOptions;
import com.stimulsoft.base.parser.StiSecureClassValidator;
import com.stimulsoft.base.parser.classes.DivideByZeroException;
import com.stimulsoft.base.parser.classes.HashSet;
import com.stimulsoft.base.parser.classes.Queue;
import com.stimulsoft.base.parser.classes.SortedList;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiDateTimeOffset;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiReflectUtill;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StiCSharpScriptParser {
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPE_MAP = new HashMap(16);
    private Object thisObject;
    private Long executionStopwatch;
    private int timeoutMilliseconds;
    private int recursionDepth = 0;
    private HashMap<String, Function<Object[], Object>> functions = new HashMap();
    private Object result;
    public static boolean allowUsingDirective;
    public static boolean allowUsingSecurityMode;
    public static int maxArraySize;
    public static int maxLoopIterations;
    public static int maxRecursionDepth;
    private boolean isAllowUsingSecurityMode;
    private boolean isAllowUsingDirective;
    private int maxArraySizeToUse;
    private int maxLoopIterationsToUse;
    private int maxRecursionDepthToUse;
    private IExternalObjectsProvider externalObjects;
    private ArrayList<String> namespaces = new ArrayList();
    private StiToken currentToken;
    private int currentTokenIndex = 0;
    private ArrayList<StiToken> tokens;
    private ArrayList<TokenPosition> tokenPositions;
    private HashMap nameToType;
    private static Object lockTypeCache;
    private HashMap<String, Object> variables = new HashMap();

    public final Object getResult() {
        return this.result;
    }

    private void setResult(Object value) {
        this.result = value;
    }

    public static Object execute(String script) {
        return new StiCSharpScriptParser(script).execute();
    }

    public final Object execute() {
        return this.execute(0);
    }

    public final Object execute(int timeoutMilliseconds) {
        this.timeoutMilliseconds = timeoutMilliseconds;
        this.executionStopwatch = timeoutMilliseconds > 0 ? Long.valueOf(System.currentTimeMillis()) : null;
        this.recursionDepth = 0;
        try {
            this.moveNext();
            while (this.currentToken.type != StiTokenType.EOF) {
                this.checkTimeout();
                this.setResult(this.parseStatement());
            }
        }
        finally {
            this.executionStopwatch = null;
        }
        return this.getResult();
    }

    private void checkTimeout() {
        if (this.executionStopwatch != null && System.currentTimeMillis() - this.executionStopwatch > (long)this.timeoutMilliseconds) {
            throw new ScriptTimeoutException("Script execution exceeded the timeout limit.");
        }
    }

    private void enterRecursion() {
        ++this.recursionDepth;
        if (this.maxRecursionDepthToUse > 0 && this.recursionDepth > this.maxRecursionDepthToUse) {
            throw new ScriptSecurityException(String.format("Recursion depth %s exceeds the maximum allowed of %s. This limit protects against stack overflow attacks through deep recursion.", this.recursionDepth, this.maxRecursionDepthToUse), String.valueOf(this.recursionDepth), SecurityCode.RecursionDepthExceeded, this.getTokenPosition());
        }
    }

    private void exitRecursion() {
        --this.recursionDepth;
    }

    private ArrayList<String> parsePropertyChain() {
        ArrayList<String> propertyChain = new ArrayList<String>();
        while (this.currentToken.IsDot() && !this.nextToken2().IsLPar()) {
            this.moveNext();
            this.waitIdent();
            propertyChain.add(this.currentToken.getDataAsString());
            this.moveNext();
        }
        return propertyChain;
    }

    private ArrayList<String> parseAssignPropertyChain(String identifier) {
        TokenState state = this.saveState();
        ArrayList<String> path = this.parsePropertyChain();
        path.add(0, identifier);
        if (this.currentToken.type != StiTokenType.Assign) {
            this.restoreState(state);
        }
        return path;
    }

    public final void setThisObject(Object thisObject) {
        this.thisObject = thisObject;
    }

    private void readOptions(StiCSharpScriptParserOptions options) {
        this.isAllowUsingDirective = options != null && options.getAllowUsingDirective() != null ? options.getAllowUsingDirective() : allowUsingDirective;
        this.isAllowUsingSecurityMode = options != null && options.getAllowUsingSecurityMode() != null ? options.getAllowUsingSecurityMode() : allowUsingSecurityMode;
        this.maxArraySizeToUse = options != null && options.getMaxArraySize() != null ? options.getMaxArraySize() : maxArraySize;
        this.maxLoopIterationsToUse = options != null && options.getMaxLoopIterations() != null ? options.getMaxLoopIterations() : maxLoopIterations;
        this.maxRecursionDepthToUse = options != null && options.getMaxRecursionDepth() != null ? options.getMaxRecursionDepth() : maxRecursionDepth;
    }

    public StiCSharpScriptParser(String scriptText) {
        this(scriptText, null);
    }

    public StiCSharpScriptParser(String scriptText, StiCSharpScriptParserOptions options) {
        this.loadTokensWithPositions(scriptText);
        this.initializeStandardFunctions();
        this.addDefaultNamespaces();
        this.readOptions(options);
    }

    public StiCSharpScriptParser(String script, ArrayList<StiToken> cachedTokens, ArrayList<TokenPosition> cachedPositions) {
        this(script, cachedTokens, cachedPositions, null);
    }

    public StiCSharpScriptParser(String script, ArrayList<StiToken> cachedTokens, ArrayList<TokenPosition> cachedPositions, StiCSharpScriptParserOptions options) {
        if (cachedTokens != null && cachedPositions != null) {
            this.tokens = cachedTokens;
            this.tokenPositions = cachedPositions;
        } else {
            this.loadTokensWithPositions(script);
        }
        this.initializeStandardFunctions();
        this.addDefaultNamespaces();
        this.readOptions(options);
    }

    private Object parseExpression() {
        this.enterRecursion();
        try {
            if (this.isExplicitCastExpression()) {
                Object object = this.parseTypeExplicitCastExpression();
                return object;
            }
            Object condition = this.parseLogicalOrExpression();
            if (this.currentToken.type == StiTokenType.Question) {
                if (this.nextToken().type == StiTokenType.Dot) {
                    throw new ScriptException("Null-conditional operator is not supported.", this.getTokenPosition());
                }
                Object object = this.parseTernaryExpression(condition);
                return object;
            }
            Object object = condition;
            return object;
        }
        finally {
            this.exitRecursion();
        }
    }

    private Object parseTernaryExpression(Object condition) {
        this.moveNext();
        if (StiValueHelper.tryToBool(condition)) {
            Object trueExpression = this.parseExpression();
            this.waitColon("Expected ':' in ternary operator").moveNext();
            this.skipExpression();
            return trueExpression;
        }
        int parenLevel = 0;
        int braceLevel = 0;
        int bracketLevel = 0;
        while (true) {
            if (this.currentToken == null) {
                throw new ScriptException("Unexpected end of input while parsing ternary expression", this.getTokenPosition());
            }
            if (parenLevel == 0 && braceLevel == 0 && bracketLevel == 0 && (this.currentToken.type == StiTokenType.Colon || this.currentToken.type == StiTokenType.SemiColon)) break;
            switch (this.currentToken.type) {
                case LPar: {
                    ++parenLevel;
                    break;
                }
                case RPar: {
                    --parenLevel;
                    break;
                }
                case LBrace: {
                    ++braceLevel;
                    break;
                }
                case RBrace: {
                    --braceLevel;
                    break;
                }
                case LBracket: {
                    ++bracketLevel;
                    break;
                }
                case RBracket: {
                    --bracketLevel;
                }
            }
            this.moveNext();
        }
        this.moveNext();
        return this.parseExpression();
    }

    private Object setElementExpression(Object array, Object index) {
        Object value = this.parseExpression();
        if (array.getClass().isArray()) {
            StiCSharpScriptParser.setArrayElement((Object[])array, index, value);
        } else if (array instanceof List) {
            StiCSharpScriptParser.setIListElement((List)array, index, value);
        } else if (this.hasIntegerIndexer(array.getClass())) {
            this.setIntegerIndexerElement(array, index, value);
        } else if (this.hasStringIndexer(array.getClass())) {
            this.setStringIndexerElement(array, index, value);
        } else {
            Object[] objectArray = new Object[1];
            objectArray[0] = (array == null ? null : array.getClass().getSimpleName()) != null ? (array == null ? null : array.getClass().getSimpleName()) : "null";
            throw new ScriptException(String.format("Cannot index into non-array type: %1$s.", objectArray), this.getTokenPosition());
        }
        return value;
    }

    private Class parseTypeExpression(String ident) {
        return this.parseTypeExpression(ident, false);
    }

    private Class parseTypeExpression() {
        return this.parseTypeExpression(null, false);
    }

    private Class parseTypeExpression(String ident, boolean stopOnFirstType) {
        Class resultType = null;
        TokenState resultState = null;
        boolean isKeyword = StiLexer.isKeyword(ident = ident != null ? ident : this.currentToken.getDataAsString(), false);
        if (isKeyword) {
            return null;
        }
        Class type = this.GetType(ident);
        if (type != null) {
            if (this.nextToken().type == StiTokenType.Question) {
                this.moveNext();
            }
            resultType = type;
            resultState = this.saveState();
            if (stopOnFirstType) {
                return resultType;
            }
        }
        TokenState savedState = this.saveState();
        String path = ident;
        if (this.currentToken.isIdent()) {
            this.moveNext();
        }
        while (this.currentToken.IsDot() && this.nextToken().isIdent() && (resultType == null || !stopOnFirstType)) {
            this.moveNext();
            this.waitIdent();
            path = resultType != null ? path + String.format("$%1$s", this.currentToken.getDataAsString()) : path + String.format(".%1$s", this.currentToken.getDataAsString());
            type = this.GetType(path);
            if (type != null) {
                resultType = type;
                resultState = this.saveState();
            }
            this.moveNext();
        }
        if (resultType != null) {
            this.restoreState(resultState);
            return resultType;
        }
        this.restoreState(savedState);
        return null;
    }

    private Object parseLogicalOrExpression() {
        Object left = this.parseLogicalAndExpression();
        while (this.currentToken.type == StiTokenType.DoubleOr || this.currentToken.type == StiTokenType.Or || this.currentToken.type == StiTokenType.DoubleXor || this.currentToken.type == StiTokenType.Xor) {
            StiTokenType operatorType = this.currentToken.type;
            this.moveNext();
            Object right = this.parseLogicalAndExpression();
            if (operatorType == StiTokenType.DoubleOr || operatorType == StiTokenType.Or) {
                left = this.bitwiseOrOperation(left, right);
                continue;
            }
            if (operatorType != StiTokenType.DoubleXor && operatorType != StiTokenType.Xor) continue;
            left = this.bitwiseXorOperation(left, right);
        }
        return left;
    }

    private Object parseLogicalAndExpression() {
        Object left = this.parseEqualityExpression();
        while (this.currentToken.type == StiTokenType.DoubleAnd || this.currentToken.type == StiTokenType.And) {
            StiTokenType operatorType = this.currentToken.type;
            this.moveNext();
            Object right = this.parseEqualityExpression();
            if (operatorType != StiTokenType.DoubleAnd && operatorType != StiTokenType.And) continue;
            left = this.bitwiseAndOperation(left, right);
        }
        return left;
    }

    private void parseDoublePlusOrMinusExpression(String identifier, Object value) {
        if (this.currentToken.type == StiTokenType.DoublePlus) {
            this.parseDoublePlusExpression(identifier, value);
        } else if (this.currentToken.type == StiTokenType.DoubleMinus) {
            this.parseDoubleMinusExpression(identifier, value);
        }
    }

    private void parseDoubleMinusExpression(String typeName, Object value) {
        this.setVariable(typeName, this.subtractOperation(value, 1));
        this.moveNext();
    }

    private void parseDoublePlusExpression(String typeName, Object value) {
        this.setVariable(typeName, this.addOperation(value, 1));
        this.moveNext();
    }

    private Object parseEqualityExpression() {
        Object left = this.parseComparisonExpression();
        String data = this.currentToken.getDataAsString();
        while (this.currentToken.type == StiTokenType.Equal || this.currentToken.type == StiTokenType.NotEqual || this.currentToken.isKeyword("is") || this.currentToken.isKeyword("as")) {
            StiTokenType operatorType = this.currentToken.type;
            this.moveNext();
            if (operatorType == StiTokenType.Keyword && data.equals("is")) {
                left = this.parseIsOperatorExpression(left);
                continue;
            }
            if (operatorType == StiTokenType.Keyword && data.equals("as")) {
                left = this.parseAsOperatorExpression(left);
                continue;
            }
            Object right = this.parseComparisonExpression();
            if (operatorType == StiTokenType.Equal) {
                left = this.equalsOperation(left, right);
                continue;
            }
            if (operatorType != StiTokenType.NotEqual) continue;
            left = !this.equalsOperation(left, right);
        }
        return left;
    }

    private Object parseIsOperatorExpression(Object left) {
        this.waitAnyIdentOrKeyword("Expected type name after 'is'");
        Class type = this.parseTypeExpression();
        if (type == null) {
            throw new ScriptException(String.format("Type '%1$s' not found.", this.currentToken.getDataAsString()), this.getTokenPosition());
        }
        this.blockType(type);
        this.moveNext();
        return type.isInstance(left);
    }

    private Object parseAsOperatorExpression(Object left) {
        this.waitAnyIdentOrKeyword("Expected type name after 'as'");
        Class type = this.parseTypeExpression();
        if (type == null) {
            throw new ScriptException(String.format("Type '%1$s' not found.", this.currentToken.getDataAsString()), this.getTokenPosition());
        }
        this.blockType(type);
        this.moveNext();
        if (left != null && type.isInstance(left)) {
            return left;
        }
        return null;
    }

    private Object parseComparisonExpression() {
        Object left = this.parseAdditionExpression();
        while (this.currentToken.type == StiTokenType.Left || this.currentToken.type == StiTokenType.LeftEqual || this.currentToken.type == StiTokenType.Right || this.currentToken.type == StiTokenType.RightEqual) {
            StiTokenType operatorType = this.currentToken.type;
            this.moveNext();
            Object right = this.parseAdditionExpression();
            int comparison = this.compareOperation(left, right);
            switch (operatorType) {
                case Left: {
                    left = comparison < 0;
                    break;
                }
                case LeftEqual: {
                    left = comparison <= 0;
                    break;
                }
                case Right: {
                    left = comparison > 0;
                    break;
                }
                case RightEqual: {
                    left = comparison >= 0;
                }
            }
        }
        return left;
    }

    private Object parseAdditionExpression() {
        Object left = this.parseMultiplicationExpression();
        while (this.currentToken.type == StiTokenType.Plus || this.currentToken.type == StiTokenType.Minus) {
            StiTokenType operatorType = this.currentToken.type;
            this.moveNext();
            Object right = this.parseMultiplicationExpression();
            switch (operatorType) {
                case Plus: {
                    left = this.addOperation(left, right);
                    break;
                }
                case Minus: {
                    left = this.subtractOperation(left, right);
                }
            }
        }
        return left;
    }

    private Object parseMultiplicationExpression() {
        Object left = this.parseUnaryExpression();
        while (this.currentToken.type == StiTokenType.Mult || this.currentToken.type == StiTokenType.Div || this.currentToken.type == StiTokenType.Percent) {
            StiTokenType operatorType = this.currentToken.type;
            this.moveNext();
            Object right = this.parseUnaryExpression();
            switch (operatorType) {
                case Mult: {
                    left = this.multiplyOperation(left, right);
                    break;
                }
                case Div: {
                    left = this.divideOperation(left, right);
                    break;
                }
                case Percent: {
                    left = this.moduloOperation(left, right);
                }
            }
        }
        return left;
    }

    private Object parseUnaryExpression() {
        if (this.currentToken.type == StiTokenType.Minus || this.currentToken.type == StiTokenType.Not) {
            StiTokenType operatorType = this.currentToken.type;
            this.moveNext();
            Object operand = this.parseUnaryExpression();
            if (operatorType == StiTokenType.Minus) {
                return this.bitwiseUnaryOperation(operand);
            }
            if (operatorType == StiTokenType.Not) {
                return (Boolean)StiConvert.changeType(operand, Boolean.class) == false;
            }
        }
        return this.parsePrimaryExpression();
    }

    private Object parsePrimaryExpression() {
        this.convertKeywordTypeToStandardType();
        Object value = null;
        switch (this.currentToken.type) {
            case Value: {
                value = this.currentToken.data;
                this.moveNext();
                break;
            }
            case Ident: {
                String identifier = this.currentToken.getDataAsString();
                this.moveNext();
                if (this.currentToken.IsLPar()) {
                    value = this.parseFunctionCallExpression(identifier);
                    break;
                }
                if (this.currentToken.IsDot() || this.currentToken.IsLBracket()) {
                    value = this.parseNestedExpression(identifier);
                    break;
                }
                StiRefObject<Object> tempOutValue = new StiRefObject<Object>(value);
                if (!this.tryGetVariable(identifier, tempOutValue)) {
                    value = tempOutValue.argvalue;
                    throw new ScriptException(String.format("Variable '%1$s' not defined.", identifier), this.getTokenPosition());
                }
                value = tempOutValue.argvalue;
                this.parseDoublePlusOrMinusExpression(identifier, value);
                break;
            }
            case InterpolatedString: {
                String interpolatedContent = this.currentToken.getDataAsString();
                this.moveNext();
                return this.processInterpolatedString(interpolatedContent);
            }
            case LPar: {
                this.moveNext();
                value = this.parseExpression();
                this.waitRPar().moveNext();
                break;
            }
            case Keyword: {
                Class genericType;
                if (this.currentToken.getDataAsString().equals("this")) {
                    this.moveNext();
                    if (this.thisObject == null) {
                        throw new ScriptException("'this' object is not set.", this.getTokenPosition());
                    }
                    value = this.thisObject;
                    break;
                }
                if (this.currentToken.getDataAsString().equals("typeof")) {
                    value = this.parseTypeOfExpression();
                    break;
                }
                if (this.currentToken.getDataAsString().equals("null")) {
                    value = null;
                    this.moveNext();
                    break;
                }
                if (!this.currentToken.getDataAsString().equals("new")) break;
                this.moveNext();
                if (this.currentToken.IsLBrace()) {
                    value = this.parseAnonymousTypeExpression();
                    break;
                }
                Class type = this.parseTypeExpression();
                this.blockType(type);
                Class clazz = genericType = type != null ? type : null;
                if (type == Queue.class && this.nextToken().type == StiTokenType.Left || genericType == Queue.class) {
                    value = this.parseGenericQueueCreationExpression();
                    break;
                }
                if (type == Stack.class && this.nextToken().type == StiTokenType.Left || genericType == Stack.class) {
                    value = this.parseGenericStackCreationExpression();
                    break;
                }
                if (type == TreeMap.class && this.nextToken().type == StiTokenType.Left || genericType == TreeMap.class) {
                    value = this.parseGenericSortedListCreationExpression();
                    break;
                }
                if (genericType == HashMap.class) {
                    value = this.parseGenericDictionaryCreationExpression();
                    break;
                }
                if (genericType == ArrayList.class) {
                    value = this.parseGenericListCreationExpression();
                    break;
                }
                if (genericType == HashSet.class) {
                    value = this.parseGenericHashSetCreationExpression();
                    break;
                }
                if (type != null && this.nextToken().IsLBracket()) {
                    value = this.parseArrayCreationExpression();
                    break;
                }
                if (type != null) {
                    value = this.parseObjectCreationExpression(type);
                    break;
                }
                throw new ScriptException(String.format("Expected type name after 'new'.", new Object[0]), this.getTokenPosition());
            }
            default: {
                throw new ScriptException(String.format("Unexpected token: %1$s.", new Object[]{this.currentToken.type}), this.getTokenPosition());
            }
        }
        return this.parsePropertyOrMethodCall(value, null);
    }

    private void convertKeywordTypeToStandardType() {
        Class standardType;
        if (this.currentToken.isKeyword() && (standardType = this.getStandardType(this.currentToken.getDataAsString())) != null) {
            this.currentToken.type = StiTokenType.Ident;
            this.currentToken.data = standardType.getSimpleName();
        }
    }

    private Object processInterpolatedString(String content) {
        if (StiValidationUtil.isNullOrEmpty((String)content)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int position = 0;
        while (position < content.length()) {
            int nextOpenBrace = content.indexOf(123, position);
            if (nextOpenBrace < 0) {
                result.append(content.substring(position));
                break;
            }
            result.append(content.substring(position, nextOpenBrace));
            if (nextOpenBrace + 1 < content.length() && content.charAt(nextOpenBrace + 1) == '{') {
                result.append('{');
                position = nextOpenBrace + 2;
                continue;
            }
            int expressionStart = nextOpenBrace + 1;
            int expressionEnd = -1;
            int bracesCount = 1;
            for (int i = expressionStart; i < content.length(); ++i) {
                if (content.charAt(i) == '{') {
                    if (i + 1 < content.length() && content.charAt(i + 1) == '{') {
                        ++i;
                        continue;
                    }
                    ++bracesCount;
                    continue;
                }
                if (content.charAt(i) != '}') continue;
                if (i + 1 < content.length() && content.charAt(i + 1) == '}') {
                    ++i;
                    continue;
                }
                if (--bracesCount != 0) continue;
                expressionEnd = i;
                break;
            }
            if (expressionEnd < 0) {
                throw new ScriptException("Unclosed interpolation expression in string.", this.getTokenPosition());
            }
            String expression = content.substring(expressionStart, expressionEnd);
            expression = expression.replace("{{", "{").replace("}}", "}");
            TokenState savedState = this.saveState();
            ArrayList<StiToken> savedTokens = this.tokens;
            ArrayList<TokenPosition> savedPositions = this.tokenPositions;
            int savedIndex = this.currentTokenIndex;
            String format = null;
            StiRefObject<Object> tempOutFormat = new StiRefObject<Object>(format);
            expression = this.tryExtractFormatSpecifier(expression, tempOutFormat);
            format = (String)tempOutFormat.argvalue;
            Object expressionResult = null;
            try {
                this.loadTokensWithPositions(expression);
                this.currentTokenIndex = 0;
                this.moveNext();
                expressionResult = this.parseExpression();
            }
            catch (RuntimeException ex) {
                throw new ScriptException(String.format("Error evaluating expression '%1$s': %2$s", expression, ex.getMessage()), this.getTokenPosition());
            }
            finally {
                this.tokens = savedTokens;
                this.tokenPositions = savedPositions;
                this.currentTokenIndex = savedIndex;
                this.restoreState(savedState);
            }
            if (format != null && expressionResult != null) {
                result.append(StiStringUtil.format((String)("{0:" + format + "}"), (Object[])new Object[]{expressionResult}));
            } else {
                result.append((String)((expressionResult == null ? null : expressionResult.toString()) != null ? (expressionResult == null ? null : expressionResult.toString()) : ""));
            }
            position = expressionEnd + 1;
        }
        return result.toString().replace("}}", "}");
    }

    private String tryExtractFormatSpecifier(String expression, StiRefObject<String> formatSpecifier) {
        formatSpecifier.argvalue = null;
        if (StiValidationUtil.isNullOrEmpty((String)expression)) {
            return expression;
        }
        int parenLevel = 0;
        int braceLevel = 0;
        int bracketLevel = 0;
        boolean inString = false;
        int ternaryQuestionCount = 0;
        int ternaryColonCount = 0;
        block10: for (int i = expression.length() - 1; i >= 0; --i) {
            char c = expression.charAt(i);
            if (inString && i > 0 && expression.charAt(i - 1) == '\\') continue;
            if (c == '\"' && (i == 0 || expression.charAt(i - 1) != '\\')) {
                boolean bl = inString = !inString;
            }
            if (inString) continue;
            switch (c) {
                case ')': {
                    ++parenLevel;
                    continue block10;
                }
                case '(': {
                    --parenLevel;
                    continue block10;
                }
                case '}': {
                    ++braceLevel;
                    continue block10;
                }
                case '{': {
                    --braceLevel;
                    continue block10;
                }
                case ']': {
                    ++bracketLevel;
                    continue block10;
                }
                case '[': {
                    --bracketLevel;
                    continue block10;
                }
                case '?': {
                    ++ternaryQuestionCount;
                    continue block10;
                }
                case ':': {
                    if (parenLevel != 0 || braceLevel != 0 || bracketLevel != 0) continue block10;
                    if (ternaryQuestionCount > ternaryColonCount) {
                        ++ternaryColonCount;
                        continue block10;
                    }
                    formatSpecifier.argvalue = expression.substring(i + 1);
                    return expression.substring(0, i);
                }
            }
        }
        return expression;
    }

    private Object parseAnonymousTypeExpression() {
        HashMap<String, Object> anonymousObj;
        this.moveNext();
        HashMap<String, Object> dictionary = anonymousObj = new HashMap<String, Object>();
        if (this.currentToken.type != StiTokenType.RBrace) {
            do {
                this.waitAnyIdent("Expected property name in anonymous type initializer");
                String propertyName = this.currentToken.getDataAsString();
                this.moveNext();
                this.waitAssign("Expected '=' after property name in anonymous type initializer").moveNext();
                Object propertyValue = this.parseExpression();
                dictionary.put(propertyName, propertyValue);
                if (this.currentToken.type != StiTokenType.Comma) break;
                this.moveNext();
            } while (!this.currentToken.IsRBrace());
        }
        this.waitRBrace("Expected closing brace in anonymous type initializer").moveNext();
        return anonymousObj;
    }

    private Object parseFunctionCallExpression(String functionName, String typeName) {
        return this.parseFunctionCallExpression(functionName, typeName, null);
    }

    private Object parseFunctionCallExpression(String functionName) {
        return this.parseFunctionCallExpression(functionName, null, null);
    }

    private Object parseFunctionCallExpression(String functionName, String typeName, String memberName) {
        ArrayList<Object> arguments = this.parseMethodArguments();
        List<Class> argumentTypes = arguments.stream().map(a -> a != null ? a.getClass() : Object.class).collect(Collectors.toList());
        if (Objects.equals(functionName.toUpperCase(Locale.ROOT), "IIF")) {
            functionName = "IIF";
        }
        if (this.functions.containsKey(functionName)) {
            return this.functions.get(functionName).apply(arguments.toArray());
        }
        if (this.externalObjects != null && this.externalObjects.containsFunction(functionName, argumentTypes.toArray(new Class[0]))) {
            return this.externalObjects.invokeFunction(functionName, arguments.toArray(new Object[0]), argumentTypes.toArray(new Class[0]));
        }
        if (memberName != null) {
            Object varValue = null;
            StiRefObject<Object> tempOutVarValue = new StiRefObject<Object>(varValue);
            if (this.tryGetVariable(typeName, tempOutVarValue) && varValue != null) {
                varValue = tempOutVarValue.argvalue;
                return this.invokeMethod(varValue.getClass(), varValue, memberName, arguments);
            }
            varValue = tempOutVarValue.argvalue;
            Class type = this.GetType(typeName);
            if (type != null) {
                return this.invokeMethod(type, null, memberName, arguments);
            }
            throw new ScriptException(String.format("Static method '%1$s' not found on type '%2$s'.", memberName, typeName), this.getTokenPosition());
        }
        if (memberName == null && (typeName == null || Objects.equals(typeName, functionName)) && this.thisObject != null) {
            return this.invokeMethod(this.thisObject.getClass(), this.thisObject, functionName, arguments);
        }
        throw new ScriptException(String.format("Function '%1$s' not defined.", functionName), this.getTokenPosition());
    }

    private Object parseNestedExpression(String identifier) {
        Class<?> staticType;
        Object value = null;
        boolean parsed = false;
        Class<?> variableValue = null;
        StiRefObject<Object> tempOutVariableValue = new StiRefObject<Object>(variableValue);
        if (this.tryGetVariable(identifier, tempOutVariableValue)) {
            variableValue = (Class<?>)tempOutVariableValue.argvalue;
            value = variableValue;
            this.parseDoublePlusOrMinusExpression(identifier, value);
            parsed = true;
        } else {
            variableValue = (Class<?>)tempOutVariableValue.argvalue;
        }
        Class<?> type = null;
        if (!parsed) {
            type = this.parseTypeExpression(identifier, true);
            if (type == null) {
                throw new ScriptException(String.format("Variable or type '%1$s' not defined.", identifier), this.getTokenPosition());
            }
            this.blockType(type);
            if (this.currentToken.isIdent()) {
                this.moveNext();
            }
        }
        Class<?> clazz = staticType = value == null ? type : value.getClass();
        while (true) {
            if (this.currentToken.IsDot()) {
                Object result;
                StiRefObject<Object> tempOutResult;
                Class<?> typeToUse;
                this.moveNext();
                this.waitAnyIdentOrKeyword("Expected property or method name after '.'");
                String memberName = this.currentToken.getDataAsString();
                this.moveNext();
                if (this.currentToken.IsLPar()) {
                    value = this.parseMethodCall(value != null ? value : staticType, memberName);
                    staticType = value == null ? null : value.getClass();
                    continue;
                }
                Class<?> clazz2 = typeToUse = value == null ? staticType : value.getClass();
                if (this.externalObjects != null && this.externalObjects.isObjectSupportsNesting(value)) {
                    TokenState state = this.saveState();
                    ArrayList<String> chain = this.parsePropertyChain();
                    chain.add(0, memberName);
                    Object nestedResult = null;
                    StiRefObject<Object> tempOutNestedResult = new StiRefObject<Object>(nestedResult);
                    if (this.externalObjects.getNestedObject(value, String.join((CharSequence)".", chain), tempOutNestedResult)) {
                        nestedResult = tempOutNestedResult.argvalue;
                        value = nestedResult;
                        staticType = value == null ? null : value.getClass();
                        continue;
                    }
                    nestedResult = tempOutNestedResult.argvalue;
                    this.restoreState(state);
                }
                if (!this.getPropertyOrField(typeToUse, value, memberName, tempOutResult = new StiRefObject<Object>((result = null)))) {
                    result = tempOutResult.argvalue;
                    if (memberName.equals("Value") && typeToUse != null && !this.isNullableType(typeToUse)) continue;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = memberName;
                    objectArray[1] = (typeToUse == null ? null : typeToUse.getSimpleName()) != null ? (typeToUse == null ? null : typeToUse.getSimpleName()) : "null";
                    throw new ScriptException(String.format("Property or field '%1$s' not found on type '%2$s'.", objectArray), this.getTokenPosition());
                }
                result = tempOutResult.argvalue;
                Object object = value = result instanceof Class ? null : result;
                staticType = result instanceof Class ? (Class<?>)result : (value == null ? null : value.getClass());
                continue;
            }
            if (!this.currentToken.IsLBracket()) break;
            staticType = (value = this.parseArrayIndexingExpression(value)) == null ? null : value.getClass();
        }
        return value;
    }

    private void skipExpression() {
        StiToken token;
        int parenLevel = 0;
        int braceLevel = 0;
        int bracketLevel = 0;
        boolean inTernary = false;
        boolean passedTernaryQuestion = false;
        while (!((token = this.currentToken) == null || parenLevel == 0 && braceLevel == 0 && bracketLevel == 0 && (token.type == StiTokenType.SemiColon || token.type == StiTokenType.Comma && !inTernary || token.type == StiTokenType.Colon && inTernary && passedTernaryQuestion || token.type == StiTokenType.RBrace || token.type == StiTokenType.RBracket || token.type == StiTokenType.RPar || token.type == StiTokenType.EOF))) {
            switch (token.type) {
                case LPar: {
                    ++parenLevel;
                    break;
                }
                case RPar: {
                    --parenLevel;
                    break;
                }
                case LBrace: {
                    ++braceLevel;
                    break;
                }
                case RBrace: {
                    --braceLevel;
                    break;
                }
                case LBracket: {
                    ++bracketLevel;
                    break;
                }
                case RBracket: {
                    --bracketLevel;
                    break;
                }
                case Question: {
                    inTernary = true;
                    passedTernaryQuestion = true;
                    break;
                }
                case Colon: {
                    if (!inTernary || !passedTernaryQuestion || parenLevel != 0 || braceLevel != 0 || bracketLevel != 0) break;
                    passedTernaryQuestion = false;
                }
            }
            this.moveNext();
        }
    }

    private Object parseArrayIndexingExpression(Object array) {
        this.moveNext();
        Object index = this.parseExpression();
        this.waitRBracket("Expected closing bracket ']' in array indexing").moveNext();
        if (array == null) {
            throw new ScriptException("Cannot index into null reference.", this.getTokenPosition());
        }
        if (array instanceof Map) {
            if (!((Map)array).containsKey(index)) {
                throw new ScriptException(String.format("Key '%1$s' not found in dictionary.", index), this.getTokenPosition());
            }
            return ((Map)array).get(index);
        }
        if (index instanceof String && this.hasStringIndexer(array.getClass())) {
            return this.getStringIndexerValue(array, (String)index);
        }
        int indexValue = StiValueHelper.tryToInt(index);
        if (this.hasIntegerIndexer(array.getClass())) {
            return this.getIntegerIndexerValue(array, indexValue);
        }
        if (array.getClass().isArray()) {
            this.checkIndexRange("Array", indexValue, Array.getLength(array));
            return Array.get(array, indexValue);
        }
        if (array instanceof List) {
            this.checkIndexRange("ArrayList", indexValue, ((List)array).size());
            return ((List)array).get(indexValue);
        }
        if (array instanceof String) {
            this.checkIndexRange("String", indexValue, ((String)array).length());
            return Character.valueOf(((String)array).charAt(indexValue));
        }
        if (array instanceof IStiReport) {
            this.checkIndexRange("String", indexValue, ((String)array).length());
            return Character.valueOf(((String)array).charAt(indexValue));
        }
        if (array instanceof Iterable) {
            Iterable it = (Iterable)array;
            ArrayList queueArray = new ArrayList();
            for (Object o : it) {
                queueArray.add(o);
            }
            this.checkIndexRange("Queue", indexValue, queueArray.size());
            return queueArray.get(indexValue);
        }
        throw new ScriptException(String.format("Cannot index into type: %1$s. Type does not support indexing.", array.getClass().getSimpleName()), this.getTokenPosition());
    }

    private Object parseTypeOfExpression() {
        this.moveNext();
        this.waitLPar("Expected '(' after 'typeof'").moveNext();
        this.waitAnyIdentOrKeyword("Expected type name inside 'typeof'");
        Class type = this.parseTypeExpression();
        if (type == null) {
            throw new ScriptException(String.format("Type '%1$s' not found.", this.currentToken.getDataAsString()), this.getTokenPosition());
        }
        this.blockType(type);
        this.moveNext();
        this.waitRPar("Expected ')' after type name in 'typeof'").moveNext();
        return type;
    }

    private Object parseTypeExplicitCastExpression() {
        this.waitLPar().moveNext();
        String data = this.currentToken.getDataAsString();
        Class targetType = this.parseTypeExpression();
        if (targetType == null) {
            throw new ScriptException(String.format("Unknown type: %1$s.", data), this.getTokenPosition());
        }
        this.blockType(targetType);
        this.moveNext();
        this.waitRPar().moveNext();
        Object value = this.parseExpression();
        return StiConvert.changeType(value, targetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExplicitCastExpression() {
        TokenState state = this.saveState();
        try {
            if (this.currentToken.IsLPar()) {
                this.moveNext();
                Class type = this.parseTypeExpression();
                if (type != null) {
                    this.blockType(type);
                    this.moveNext();
                    if (this.currentToken.type == StiTokenType.RPar) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        finally {
            this.restoreState(state);
        }
        return false;
    }

    private Object parseGenericListCreationExpression() {
        if (!this.currentToken.isIdent("ArrayList")) {
            this.waitIdent("List", "Expected 'List' after 'new')").moveNext();
            this.waitLeft("Expected '<' after 'List'").moveNext();
            this.waitAnyIdentOrKeyword("Expected type name inside 'List<>'");
            String elementTypeName = this.currentToken.getDataAsString();
            Class elementType = this.GetType(elementTypeName);
            if (elementType == null) {
                throw new ScriptException(String.format("Unknown type: %1$s.", elementTypeName), this.getTokenPosition());
            }
            this.moveNext();
            this.waitRight("Expected '>' after type name in 'List<>'").moveNext();
            this.blockType(elementType);
        } else {
            this.moveNext();
        }
        boolean hasParentheses = false;
        if (this.currentToken.IsLPar()) {
            hasParentheses = true;
            this.moveNext();
            this.waitRPar("Expected ')' after '(' in 'List<>' constructor").moveNext();
        }
        Class<ArrayList> listType = ArrayList.class;
        Object list = null;
        try {
            list = listType.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.currentToken.type == StiTokenType.LBrace) {
            return this.parseGenericListInitializationExpression(listType, list);
        }
        if (!hasParentheses) {
            throw new ScriptException("Expected '()' or '{}' after generic type.", this.getTokenPosition());
        }
        return list;
    }

    private Object parseGenericListInitializationExpression(Class type, Object obj) {
        this.moveNext();
        Method addMethod = null;
        try {
            addMethod = type.getMethod("add", Object.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        if (addMethod != null) {
            if (this.currentToken.type != StiTokenType.RBrace) {
                do {
                    Object element = this.parseExpression();
                    Parameter[] paramTypes = addMethod.getParameters();
                    if (paramTypes.length == 1) {
                        try {
                            addMethod.invoke(obj, element);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.currentToken.type != StiTokenType.Comma) break;
                    this.moveNext();
                } while (this.currentToken.type != StiTokenType.RBrace);
            }
            this.waitRBrace("Expected closing brace in collection initializer.").moveNext();
        } else {
            this.skipBlockStatement();
        }
        return obj;
    }

    private Object parseGenericDictionaryCreationExpression() {
        this.waitIdent("Dictionary", "Expected 'Dictionary' after 'new')").moveNext();
        this.waitLeft("Expected '<' after 'Dictionary'").moveNext();
        this.waitAnyIdentOrKeyword("Expected key type inside 'Dictionary<>'");
        String keyTypeName = this.currentToken.getDataAsString();
        Class keyType = this.GetType(keyTypeName);
        if (keyType == null) {
            throw new ScriptException(String.format("Unknown key type: %1$s.", keyTypeName), this.getTokenPosition());
        }
        this.moveNext();
        this.waitComma("Expected ',' between key and value types in 'Dictionary<>'").moveNext();
        this.waitAnyIdentOrKeyword("Expected value type inside 'Dictionary<>'");
        String valueTypeName = this.currentToken.getDataAsString();
        Class valueType = this.GetType(valueTypeName);
        if (valueType == null) {
            throw new ScriptException(String.format("Unknown value type: %1$s.", valueTypeName), this.getTokenPosition());
        }
        this.moveNext();
        this.waitRight("Expected '>' after value type in 'Dictionary<>'").moveNext();
        this.waitLPar("Expected '(' after 'Dictionary<>'").moveNext();
        this.waitRPar("Expected ')' after '(' in 'Dictionary<>' constructor").moveNext();
        Class<HashMap> dictionaryType = HashMap.class;
        try {
            return dictionaryType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object parseGenericHashSetCreationExpression() {
        this.waitIdent("HashSet", "Expected 'HashSet' after 'new')").moveNext();
        this.waitLeft("Expected '<' after 'HashSet'").moveNext();
        this.waitAnyIdentOrKeyword("Expected type name inside 'HashSet<>'");
        String elementTypeName = this.currentToken.getDataAsString();
        Class elementType = this.GetType(elementTypeName);
        if (elementType == null) {
            throw new ScriptException(String.format("Unknown type: %1$s.", elementTypeName), this.getTokenPosition());
        }
        this.moveNext();
        this.waitRight("Expected '>' after type name in 'HashSet<>'").moveNext();
        this.waitLPar("Expected '(' after 'HashSet<>'").moveNext();
        this.waitRPar("Expected ')' after '(' in 'HashSet<>' constructor").moveNext();
        Class<HashSet> hashSetType = HashSet.class;
        try {
            return hashSetType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object parseGenericQueueCreationExpression() {
        this.waitIdent("Queue", "Expected 'Queue' after 'new')").moveNext();
        if (!this.currentToken.IsLPar()) {
            this.waitLeft("Expected '<' after 'Queue'").moveNext();
            this.waitAnyIdentOrKeyword("Expected type name inside 'Queue<>'");
            String elementTypeName = this.currentToken.getDataAsString();
            Class elementType = this.GetType(elementTypeName);
            if (elementType == null) {
                throw new ScriptException(String.format("Unknown type: %1$s.", elementTypeName), this.getTokenPosition());
            }
            this.moveNext();
            this.waitRight("Expected '>' after type name in 'Queue<>'").moveNext();
        }
        this.waitLPar("Expected '(' after 'Queue<>'").moveNext();
        this.waitRPar("Expected ')' after '(' in 'Queue<>' constructor").moveNext();
        Class<Queue> queueType = Queue.class;
        try {
            return queueType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object parseGenericStackCreationExpression() {
        this.waitIdent("Stack", "Expected 'Stack' after 'new')").moveNext();
        if (this.currentToken.type == StiTokenType.Left) {
            this.waitLeft("Expected '<' after 'Stack'").moveNext();
            this.waitAnyIdentOrKeyword("Expected type name inside 'Stack<>'");
            String elementTypeName = this.currentToken.getDataAsString();
            Class elementType = this.GetType(elementTypeName);
            if (elementType == null) {
                throw new ScriptException(String.format("Unknown type: %1$s.", elementTypeName), this.getTokenPosition());
            }
            this.moveNext();
            this.waitRight("Expected '>' after type name in 'Stack<>'").moveNext();
        }
        this.waitLPar("Expected '(' after 'Stack<>'").moveNext();
        this.waitRPar("Expected ')' after '(' in 'Stack<>' constructor").moveNext();
        Class<Stack> stackType = Stack.class;
        try {
            return stackType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object parseGenericSortedListCreationExpression() {
        this.waitIdent("SortedList", "Expected 'SortedList' after 'new')").moveNext();
        if (this.currentToken.type == StiTokenType.Left) {
            this.waitLeft("Expected '<' after 'SortedList'").moveNext();
            this.waitAnyIdentOrKeyword("Expected type name inside 'SortedList<>'");
            String keyTypeName = this.currentToken.getDataAsString();
            Class keyType = this.GetType(keyTypeName);
            if (keyType == null) {
                throw new ScriptException(String.format("Unknown key type: %1$s.", keyTypeName), this.getTokenPosition());
            }
            this.moveNext();
            this.waitComma("Expected ',' between key and value types in 'SortedList<>'").moveNext();
            this.waitAnyIdentOrKeyword("Expected value type inside 'SortedList<>'");
            String valueTypeName = this.currentToken.getDataAsString();
            Class valueType = this.GetType(valueTypeName);
            if (valueType == null) {
                throw new ScriptException(String.format("Unknown value type: %1$s.", valueTypeName), this.getTokenPosition());
            }
            this.moveNext();
            this.waitRight("Expected '>' after value type in 'SortedList<>'").moveNext();
        }
        this.waitLPar("Expected '(' after 'SortedList<>'").moveNext();
        this.waitRPar("Expected ')' after '(' in 'SortedList<>' constructor").moveNext();
        Class<TreeMap> sortedListType = TreeMap.class;
        try {
            return sortedListType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object parseArrayCreationExpression() {
        String typeName = this.currentToken.getDataAsString();
        this.moveNext();
        this.waitLBracket("Expected '[' after type name").moveNext();
        if (this.currentToken.IsRBracket()) {
            this.moveNext();
            if (this.currentToken.IsLBrace()) {
                return this.parseArrayInitialization(typeName);
            }
            throw new ScriptException("Expected initializer '{...}' after 'new type[]'.", this.getTokenPosition());
        }
        Object size = this.parseExpression();
        int arraySize = StiValueHelper.tryToInt(size);
        this.validateArraySize(arraySize, typeName);
        this.waitRBracket("Expected ']' after array size").moveNext();
        Class elementType = this.GetType(typeName);
        if (elementType == null) {
            throw new ScriptException(String.format("Unknown type: %s.", this.getTokenPosition()));
        }
        this.blockType(elementType);
        return this.createArray(typeName, StiValueHelper.tryToInt(size));
    }

    private void validateArraySize(int size, String typeName) {
        if (size < 0) {
            throw new ScriptException(String.format("Array size cannot be negative: %s.", this.getTokenPosition()));
        }
        if (this.maxArraySizeToUse > 0 && size > this.maxArraySizeToUse) {
            throw new ScriptSecurityException(String.format("Array size %s exceeds the maximum allowed size of %s. This limit protects against excessive memory allocation.", size, this.maxArraySizeToUse), typeName, SecurityCode.ArraySizeExceeded, this.getTokenPosition());
        }
    }

    private Object parseArrayInitialization(String typeName) {
        this.moveNext();
        ArrayList<Object> elements = new ArrayList<Object>();
        if (!this.currentToken.IsRBrace()) {
            do {
                elements.add(this.parseExpression());
                if (this.currentToken.type != StiTokenType.Comma) break;
                this.moveNext();
            } while (!this.currentToken.IsRBrace());
        }
        this.waitRBrace("Expected closing brace in array initializer.").moveNext();
        this.validateArraySize(elements.size(), typeName);
        Class elementType = this.GetType(typeName);
        if (elementType == null) {
            throw new ScriptException(String.format("Unknown type: %1$s.", typeName), this.getTokenPosition());
        }
        Object[] array = new Object[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            Object convertedValue;
            Object value = elements.get(i);
            array[i] = convertedValue = this.convertToType(value, typeName);
        }
        return array;
    }

    private Object parseObjectCreationExpression(Class type) {
        this.blockType(type);
        if (this.isAllowUsingSecurityMode) {
            StiSecureClassValidator.validateConstructor(type.getName());
        }
        this.moveNext();
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (this.currentToken.IsLPar()) {
            this.moveNext();
            if (this.currentToken.type != StiTokenType.RPar) {
                arguments.add(this.parseExpression());
                while (this.currentToken.type == StiTokenType.Comma) {
                    this.moveNext();
                    arguments.add(this.parseExpression());
                }
            }
            this.waitRPar("Expected closing parenthesis in object constructor.").moveNext();
        }
        Object obj = StiActivator.createObject(type, !arguments.isEmpty() ? arguments.toArray(new Object[0]) : null);
        if (this.currentToken.IsLBrace()) {
            this.parseObjectInitialization(obj);
        }
        return obj;
    }

    private void parseObjectInitialization(Object obj) {
        this.moveNext();
        Class<?> type = obj.getClass();
        if (this.currentToken.type != StiTokenType.RBrace) {
            do {
                this.waitAnyIdent("Expected property name in anonymous type initializer");
                String propertyName = this.currentToken.getDataAsString();
                this.moveNext();
                this.waitAssign("Expected '=' after property name in anonymous type initializer").moveNext();
                Object propertyValue = this.parseExpression();
                this.setPropertyOrField(type, obj, propertyName, propertyValue);
                if (this.currentToken.type != StiTokenType.Comma) break;
                this.moveNext();
            } while (!this.currentToken.IsRBrace());
        }
        this.waitRBrace("Expected closing brace in object type initializer").moveNext();
    }

    public final void setExternalObjectsProvider(IExternalObjectsProvider provider) {
        this.externalObjects = provider;
    }

    public final void registerFunction(String name, Function<Object[], Object> function) {
        this.functions.put(name, function);
    }

    private void initializeStandardFunctions() {
        this.functions.put("Convert.ToInt", args -> Integer.parseInt(args[0].toString()));
        this.functions.put("Convert.ToDouble", args -> Double.parseDouble(args[0].toString()));
        this.functions.put("Convert.ToBoolean", args -> Boolean.parseBoolean(args[0].toString()));
        this.functions.put("Convert.ToFloat", args -> Float.valueOf(Float.parseFloat(args[0].toString())));
        this.functions.put("Convert.ToDecimal", args -> new BigDecimal(args[0].toString()));
        this.functions.put("Convert.ToLong", args -> Long.parseLong(args[0].toString()));
        this.functions.put("Math.Ceiling", args -> Math.ceil(StiValueHelper.tryToDouble(args[0])));
        this.functions.put("IIF", args -> StiValueHelper.tryToBool(args[0]) ? args[1] : args[2]);
    }

    private static void setArrayElement(Object[] arrayObj, Object index, Object value) {
        Object valueObject;
        int indexValue = (Integer)index;
        arrayObj[indexValue] = valueObject = StiConvert.changeType(value, arrayObj.getClass().getComponentType());
    }

    private static void setIListElement(List listObj, Object index, Object value) {
        int indexValue = (Integer)index;
        listObj.set(indexValue, value);
    }

    private Object setIntegerIndexerElement(Object array, Object index, Object value) {
        Class<?> elementType = array.getClass().getComponentType();
        value = elementType != null ? StiConvert.changeType(value, elementType) : value;
        this.setIntegerIndexerValue(array, StiValueHelper.tryToInt(index), value);
        return value;
    }

    private Object setStringIndexerElement(Object array, Object index, Object value) {
        Class<?> elementType = array.getClass().getComponentType();
        value = elementType != null ? StiConvert.changeType(value, elementType) : value;
        this.setStringIndexerValue(array, index == null ? null : index.toString(), value);
        return value;
    }

    private boolean hasStringIndexer(Class type) {
        return Arrays.asList(type.getMethods()).stream().filter(m -> m.getName().equals("get") && m.getParameterCount() == 1 && m.getParameterTypes()[0] == String.class).findAny().isPresent();
    }

    private boolean hasIntegerIndexer(Class type) {
        return Arrays.asList(type.getMethods()).stream().filter(m -> m.getName().equals("get") && m.getParameterCount() == 1 && (m.getParameterTypes()[0] == Integer.TYPE || m.getParameterTypes()[0] == Integer.class)).findAny().isPresent();
    }

    private Object getStringIndexerValue(Object obj, String index) {
        Class<?> type = obj.getClass();
        Method method = Arrays.asList(type.getMethods()).stream().filter(m -> m.getName().equals("get") && m.getParameterCount() == 1 && m.getParameterTypes()[0] == String.class).findAny().get();
        try {
            return method.invoke(obj, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getIntegerIndexerValue(Object obj, int index) {
        Class<?> type = obj.getClass();
        Method method = Arrays.asList(type.getMethods()).stream().filter(m -> m.getName().equals("get") && m.getParameterCount() == 1 && (m.getParameterTypes()[0] == Integer.TYPE || m.getParameterTypes()[0] == Integer.class)).findAny().get();
        if (obj instanceof Stack) {
            index = ((Stack)obj).size() - index - 1;
        }
        try {
            return method.invoke(obj, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setStringIndexerValue(Object obj, String index, Object value) {
        Class<?> type = obj.getClass();
        Method method = Arrays.asList(type.getMethods()).stream().filter(m -> m.getName().equals("set") && m.getParameterCount() == 2 && m.getParameterTypes()[0] == String.class).findAny().get();
        try {
            method.invoke(obj, index, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setIntegerIndexerValue(Object obj, int index, Object value) {
        Class<?> type = obj.getClass();
        Method method = Arrays.asList(type.getMethods()).stream().filter(m -> m.getName().equals("set") && m.getParameterCount() == 2 && (m.getParameterTypes()[0] == Integer.TYPE || m.getParameterTypes()[0] == Integer.class)).findAny().get();
        try {
            method.invoke(obj, index, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkIndexerProperty(Class type, Object indexerProperty) {
        this.checkIndexerProperty(type, indexerProperty, "integer");
    }

    private void checkIndexerProperty(Class type, Object indexerProperty, String indexerType) {
        if (indexerProperty == null) {
            throw new ScriptException(String.format("Type %1$s doesn't support %2$s indexers.", type.getSimpleName(), indexerType), this.getTokenPosition());
        }
    }

    private void checkIndexRange(String type, int index, int length) {
        if (index < 0 || index >= length) {
            throw new ScriptException(String.format("%1$s index %2$s out of bounds for %3$s of length %4$s.", type, index, type, length), this.getTokenPosition());
        }
    }

    public final void registerNamespace(String name) {
        this.namespaces.add(name);
    }

    private void addDefaultNamespaces() {
        this.namespaces.add("");
        this.namespaces.add("System");
        this.namespaces.add("System.Collections");
        this.namespaces.add("System.Collections.Generic");
        this.namespaces.add("System.Drawing");
        this.namespaces.add("System.Drawing.Drawing2D");
        this.namespaces.add("System.Globalization");
        this.namespaces.add("Stimulsoft.Base.Drawing");
        this.namespaces.add("Stimulsoft.Report");
        this.namespaces.add("Stimulsoft.Report.Components");
        this.namespaces.add("java.lang");
        this.namespaces.add("com.stimulsoft.base.drawing");
        this.namespaces.add("com.stimulsoft.report.components.simplecomponents");
        this.namespaces.add("com.stimulsoft.report.components");
        this.namespaces.add("com.stimulsoft.report");
        this.namespaces.add("com.stimulsoft.base.parser.classes");
    }

    private Object parseAssignOperation(StiTokenType tokenType, Object currentValue) {
        Object value = tokenType == StiTokenType.DoublePlus || tokenType == StiTokenType.DoubleMinus ? currentValue : this.parseExpression();
        switch (tokenType) {
            case Assign: {
                break;
            }
            case PlusAssign: {
                value = this.addOperation(currentValue, value);
                break;
            }
            case MinusAssign: {
                value = this.subtractOperation(currentValue, value);
                break;
            }
            case MultAssign: {
                value = this.multiplyOperation(currentValue, value);
                break;
            }
            case DivAssign: {
                value = this.divideOperation(currentValue, value);
                break;
            }
            case ModAssign: {
                value = this.moduloOperation(currentValue, value);
                break;
            }
            case AndAssign: {
                value = this.bitwiseAndOperation(currentValue, value);
                break;
            }
            case OrAssign: {
                value = this.bitwiseOrOperation(currentValue, value);
                break;
            }
            case XorAssign: {
                value = this.bitwiseXorOperation(currentValue, value);
                break;
            }
            case DoublePlus: {
                value = this.addOperation(currentValue, 1);
                break;
            }
            case DoubleMinus: {
                value = this.subtractOperation(currentValue, 1);
            }
        }
        return value;
    }

    private boolean isOperation(StiTokenType type) {
        switch (type) {
            case Left: 
            case LeftEqual: 
            case Right: 
            case RightEqual: 
            case Plus: 
            case Minus: 
            case Mult: 
            case Div: 
            case Percent: 
            case Question: 
            case And: 
            case Or: 
            case Xor: 
            case Equal: 
            case NotEqual: 
            case DoubleOr: 
            case DoubleAnd: 
            case DoubleQuestion: {
                return true;
            }
        }
        return false;
    }

    private boolean isAssignOperation(StiTokenType tokenType) {
        return tokenType == StiTokenType.Assign || tokenType == StiTokenType.PlusAssign || tokenType == StiTokenType.MinusAssign || tokenType == StiTokenType.MultAssign || tokenType == StiTokenType.DivAssign || tokenType == StiTokenType.ModAssign || tokenType == StiTokenType.AndAssign || tokenType == StiTokenType.OrAssign || tokenType == StiTokenType.XorAssign || tokenType == StiTokenType.DoublePlus || tokenType == StiTokenType.DoubleMinus;
    }

    private int compareOperation(Object left, Object right) {
        if (!(left != DBNull.Value && left != null || right != DBNull.Value && right != null)) {
            return 0;
        }
        if (left == DBNull.Value || left == null) {
            return -1;
        }
        if (right == DBNull.Value || right == null) {
            return 1;
        }
        if (left instanceof BigDecimal) {
            BigDecimal leftValue = StiValueHelper.tryToDecimal(left);
            BigDecimal rightValue = StiValueHelper.tryToDecimal(right);
            return leftValue.compareTo(rightValue);
        }
        if (this.isFloatingType(left)) {
            Double leftValue = StiValueHelper.tryToDouble(left);
            Double rightValue = StiValueHelper.tryToDouble(right);
            return leftValue.compareTo(rightValue);
        }
        if (this.isIntegerType(left)) {
            Long leftValue = StiValueHelper.tryToLong(left);
            Long rightValue = StiValueHelper.tryToLong(right);
            return leftValue.compareTo(rightValue);
        }
        return ((Comparable)left).compareTo(right);
    }

    private Object bitwiseUnaryOperation(Object operand) {
        if (operand instanceof Long) {
            return -((Long)operand).longValue();
        }
        if (operand instanceof Integer) {
            return -((Integer)operand).intValue();
        }
        if (operand instanceof Short) {
            return (int)(-((Short)operand).shortValue());
        }
        if (operand instanceof Byte) {
            return (int)(-((Byte)operand).byteValue());
        }
        if (operand instanceof BigDecimal) {
            return ((BigDecimal)operand).multiply(new BigDecimal(-1));
        }
        if (operand instanceof Float) {
            return Float.valueOf(-((Float)operand).floatValue());
        }
        return -Double.parseDouble(String.valueOf(operand));
    }

    private Object bitwiseAndOperation(Object left, Object right) {
        if (left instanceof Long) {
            return StiValueHelper.tryToLong(left) & StiValueHelper.tryToLong(right);
        }
        if (left instanceof Integer) {
            return StiValueHelper.tryToInt(left) & StiValueHelper.tryToInt(right);
        }
        if (left instanceof Short) {
            return StiValueHelper.tryToShort(left) & StiValueHelper.tryToShort(right);
        }
        if (left instanceof Byte) {
            return StiValueHelper.tryToInt(left) & StiValueHelper.tryToInt(right);
        }
        if (left instanceof Boolean) {
            return (Boolean)left != false && (Boolean)right != false;
        }
        if (left instanceof Enum) {
            return (Integer)left & (Integer)right;
        }
        throw new ScriptException("Bitwise AND is not supported for the given types.", this.getTokenPosition());
    }

    private Object bitwiseOrOperation(Object left, Object right) {
        if (left instanceof Long) {
            return StiValueHelper.tryToLong(left) | StiValueHelper.tryToLong(right);
        }
        if (left instanceof Integer) {
            return StiValueHelper.tryToInt(left) | StiValueHelper.tryToInt(right);
        }
        if (left instanceof Short) {
            return StiValueHelper.tryToShort(left) | StiValueHelper.tryToShort(right);
        }
        if (left instanceof Byte) {
            return StiValueHelper.tryToInt(left) | StiValueHelper.tryToInt(right);
        }
        if (left instanceof Boolean) {
            return (Boolean)left != false || (Boolean)right != false;
        }
        if (left instanceof IStiEnum) {
            return ((IStiEnum)left).getValue() | ((IStiEnum)right).getValue();
        }
        if (left instanceof Enum) {
            return ((Enum)left).ordinal() | ((Enum)right).ordinal();
        }
        throw new ScriptException("Bitwise OR is not supported for the given types.", this.getTokenPosition());
    }

    private Object bitwiseXorOperation(Object left, Object right) {
        if (left instanceof Long) {
            return StiValueHelper.tryToLong(left) ^ StiValueHelper.tryToLong(right);
        }
        if (left instanceof Integer) {
            return StiValueHelper.tryToInt(left) ^ StiValueHelper.tryToInt(right);
        }
        if (left instanceof Short) {
            return StiValueHelper.tryToShort(left) ^ StiValueHelper.tryToShort(right);
        }
        if (left instanceof Byte) {
            return StiValueHelper.tryToInt(left) ^ StiValueHelper.tryToInt(right);
        }
        if (left instanceof Boolean) {
            return (Boolean)left ^ (Boolean)right;
        }
        if (left instanceof Enum) {
            return (Integer)left ^ (Integer)right;
        }
        throw new ScriptException("Bitwise XOR is not supported for the given types.", this.getTokenPosition());
    }

    private Object addOperation(Object left, Object right) {
        if (left instanceof String || left instanceof Character) {
            return StiValueHelper.tryToString(left) + StiValueHelper.tryToString(right);
        }
        if (left instanceof Long) {
            return StiValueHelper.tryToLong(left) + StiValueHelper.tryToLong(right);
        }
        if (left instanceof Integer) {
            return StiValueHelper.tryToInt(left) + StiValueHelper.tryToInt(right);
        }
        if (left instanceof Short) {
            return StiValueHelper.tryToShort(left) + StiValueHelper.tryToShort(right);
        }
        if (left instanceof Byte) {
            return StiValueHelper.tryToInt(left) + StiValueHelper.tryToInt(right);
        }
        if (left instanceof Float) {
            return Float.valueOf(StiValueHelper.tryToFloat(left) + StiValueHelper.tryToFloat(right));
        }
        if (left instanceof Double) {
            return StiValueHelper.tryToDouble(left) + StiValueHelper.tryToDouble(right);
        }
        if (left instanceof BigDecimal) {
            return StiValueHelper.tryToDecimal(left).add(StiValueHelper.tryToDecimal(right));
        }
        if (left instanceof Enum) {
            return (Integer)left + (Integer)right;
        }
        return StiValueHelper.tryToDecimal(left).add(StiValueHelper.tryToDecimal(right));
    }

    private Object subtractOperation(Object left, Object right) {
        if (left instanceof String) {
            throw new ScriptException("Subtraction is not supported for string types.", this.getTokenPosition());
        }
        if (left instanceof Long) {
            return StiValueHelper.tryToLong(left) - StiValueHelper.tryToLong(right);
        }
        if (left instanceof Integer) {
            return StiValueHelper.tryToInt(left) - StiValueHelper.tryToInt(right);
        }
        if (left instanceof Short) {
            return StiValueHelper.tryToShort(left) - StiValueHelper.tryToShort(right);
        }
        if (left instanceof Byte) {
            return StiValueHelper.tryToInt(left) - StiValueHelper.tryToInt(right);
        }
        if (left instanceof Float) {
            return Float.valueOf(StiValueHelper.tryToFloat(left) - StiValueHelper.tryToFloat(right));
        }
        if (left instanceof Double) {
            return StiValueHelper.tryToDouble(left) - StiValueHelper.tryToDouble(right);
        }
        if (left instanceof Enum) {
            return (Integer)left - (Integer)right;
        }
        return StiValueHelper.tryToDecimal(left).subtract(StiValueHelper.tryToDecimal(right));
    }

    private Object multiplyOperation(Object left, Object right) {
        if (left.getClass() != right.getClass()) {
            right = StiConvert.changeType(right, left.getClass());
        }
        if (left instanceof Long) {
            return StiValueHelper.tryToLong(left) * StiValueHelper.tryToLong(right);
        }
        if (left instanceof Integer) {
            return StiValueHelper.tryToInt(left) * StiValueHelper.tryToInt(right);
        }
        if (left instanceof Short) {
            return StiValueHelper.tryToShort(left) * StiValueHelper.tryToShort(right);
        }
        if (left instanceof Byte) {
            return StiValueHelper.tryToInt(left) * StiValueHelper.tryToInt(right);
        }
        if (left instanceof Float) {
            return Float.valueOf(StiValueHelper.tryToFloat(left) * StiValueHelper.tryToFloat(right));
        }
        if (left instanceof Double) {
            return StiValueHelper.tryToDouble(left) * StiValueHelper.tryToDouble(right);
        }
        return StiValueHelper.tryToDecimal(left).multiply(StiValueHelper.tryToDecimal(right));
    }

    private Object divideOperation(Object left, Object right) {
        if (BigDecimal.ZERO.compareTo(StiValueHelper.tryToDecimal(right)) == 0) {
            throw new DivideByZeroException("Division by zero.");
        }
        if (left instanceof Long) {
            return StiValueHelper.tryToLong(left) / StiValueHelper.tryToLong(right);
        }
        if (left instanceof Integer) {
            return StiValueHelper.tryToInt(left) / StiValueHelper.tryToInt(right);
        }
        if (left instanceof Short) {
            return StiValueHelper.tryToShort(left) / StiValueHelper.tryToShort(right);
        }
        if (left instanceof Byte) {
            return StiValueHelper.tryToInt(left) / StiValueHelper.tryToInt(right);
        }
        if (left instanceof Float) {
            return Float.valueOf(StiValueHelper.tryToFloat(left) / -StiValueHelper.tryToFloat(right));
        }
        if (left instanceof Double) {
            return StiValueHelper.tryToDouble(left) / StiValueHelper.tryToDouble(right);
        }
        return StiValueHelper.tryToDecimal(left).divide(StiValueHelper.tryToDecimal(right));
    }

    private Object moduloOperation(Object left, Object right) {
        if (left instanceof Long) {
            return StiValueHelper.tryToLong(left) % StiValueHelper.tryToLong(right);
        }
        if (left instanceof Integer) {
            return StiValueHelper.tryToInt(left) % StiValueHelper.tryToInt(right);
        }
        if (left instanceof Short) {
            return StiValueHelper.tryToShort(left) % -StiValueHelper.tryToShort(right);
        }
        if (left instanceof Byte) {
            return StiValueHelper.tryToInt(left) % StiValueHelper.tryToInt(right);
        }
        if (left instanceof Float) {
            return Float.valueOf(StiValueHelper.tryToFloat(left) % StiValueHelper.tryToFloat(right));
        }
        if (left instanceof Double) {
            return StiValueHelper.tryToDouble(left) % StiValueHelper.tryToDouble(right);
        }
        return StiValueHelper.tryToDecimal(left).remainder(StiValueHelper.tryToDecimal(right));
    }

    private boolean equalsOperation(Object left, Object right) {
        if (this.isIntegerType(left) || this.isIntegerType(right)) {
            return this.compareOperation(left, right) == 0;
        }
        if (this.isFloatingType(left) || this.isFloatingType(right)) {
            return this.compareOperation(left, right) == 0;
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            return this.compareOperation(left, right) == 0;
        }
        return Objects.equals(left, right);
    }

    private Object parsePropertyOrMethodCall(Object value, Class type) {
        while (true) {
            if (this.currentToken.IsDot()) {
                Object result;
                StiRefObject<Object> tempOutResult;
                this.moveNext();
                this.waitAnyIdentOrKeyword("Expected property or method name after '.'");
                String memberName = this.currentToken.getDataAsString();
                this.moveNext();
                if (this.currentToken.IsLPar()) {
                    value = this.parseMethodCall(value, memberName);
                    continue;
                }
                if (this.currentToken.type == StiTokenType.Assign) {
                    this.moveNext();
                    Object assignmentValue = this.parseExpression();
                    if (value == null) {
                        throw new ScriptException("Cannot assign to property of null object.", this.getTokenPosition());
                    }
                    this.setPropertyOrField(value.getClass(), value, memberName, assignmentValue);
                    value = assignmentValue;
                    this.moveNextIfSemiColon();
                    return value;
                }
                Class<?> clazz = type = type != null ? type : value.getClass();
                if (this.externalObjects != null && this.externalObjects.isObjectSupportsNesting(value)) {
                    TokenState state = this.saveState();
                    ArrayList<String> chain = this.parsePropertyChain();
                    chain.add(0, memberName);
                    Object nestedResult = null;
                    StiRefObject<Object> tempOutNestedResult = new StiRefObject<Object>(nestedResult);
                    if (this.externalObjects.getNestedObject(value, String.join((CharSequence)".", chain), tempOutNestedResult)) {
                        nestedResult = tempOutNestedResult.argvalue;
                        value = nestedResult;
                        continue;
                    }
                    nestedResult = tempOutNestedResult.argvalue;
                    this.restoreState(state);
                }
                if (this.getPropertyOrField(type, value, memberName, tempOutResult = new StiRefObject<Object>((result = null)))) {
                    value = result = (Object)tempOutResult.argvalue;
                    type = result == null ? null : result.getClass();
                    continue;
                }
                result = tempOutResult.argvalue;
                Object variable = null;
                StiRefObject<Object> tempOutVariable = new StiRefObject<Object>(variable);
                if (this.tryGetVariable(memberName, tempOutVariable)) {
                    value = variable = (Object)tempOutVariable.argvalue;
                    type = variable == null ? null : variable.getClass();
                    this.parseDoublePlusOrMinusExpression(memberName, value);
                    continue;
                }
                variable = tempOutVariable.argvalue;
                throw new ScriptException(String.format("Property or field '%1$s' not found on type '%2$s'.", memberName, type.getSimpleName()), this.getTokenPosition());
            }
            if (!this.currentToken.IsLBracket()) break;
            type = (value = this.parseArrayIndexingExpression(value)) == null ? null : value.getClass();
        }
        return value;
    }

    private Object parseMethodCall(Object instance, String methodName) {
        String fullName;
        ArrayList<Object> arguments = this.parseMethodArguments();
        if (instance instanceof String && this.functions.containsKey(fullName = String.format("%1$s.%2$s", instance, methodName))) {
            return this.functions.get(fullName).apply(arguments.toArray(new Object[arguments.size()]));
        }
        if (instance != null && this.isAllowUsingSecurityMode) {
            Object instanceType = instance.getClass();
            this.blockMethodInvoke((Class<?>)instanceType, methodName);
            this.blockGetSetField((Class<?>)instanceType, methodName);
        }
        if (instance == String.class) {
            switch (methodName) {
                case "Format": {
                    return StiStringUtil.format((String)((String)arguments.get(0)), (Object[])arguments.subList(1, arguments.size()).toArray());
                }
            }
        }
        if (instance instanceof Map) {
            switch (methodName) {
                case "Add": {
                    return ((Map)instance).put(arguments.get(0), arguments.get(1));
                }
            }
        }
        if (instance == Long.class) {
            switch (methodName) {
                case "Parse": {
                    return Long.parseLong(arguments.get(0).toString());
                }
                case "MaxValue": {
                    return Long.MAX_VALUE;
                }
                case "MinValue": {
                    return Long.MIN_VALUE;
                }
            }
        }
        if (!(instance instanceof Class) && instance != null && methodName.equals("GetType") && arguments.size() == 0) {
            return instance.getClass();
        }
        if (instance instanceof Class) {
            Class typeInstance = (Class)instance;
            String fullName2 = String.format("%1$s.%2$s", typeInstance.getSimpleName(), methodName);
            if (this.functions.containsKey(fullName2)) {
                return this.functions.get(fullName2).apply(arguments.toArray(new Object[arguments.size()]));
            }
            if (typeInstance != null && this.isAllowUsingSecurityMode) {
                this.blockActivatorCreateInstance(typeInstance, methodName);
            }
            return this.invokeMethod(typeInstance, null, methodName, arguments);
        }
        return this.invokeMethod(instance == null ? null : instance.getClass(), instance, methodName, arguments);
    }

    private void blockMethodInvoke(Class<?> type, String methodName) {
        if (type.isAssignableFrom(Method.class) && "invoke".equals(methodName)) {
            throw new ScriptSecurityException("Method 'Method.invoke()' is blocked for security reasons.", type.getName(), SecurityCode.BlockedMember, this.getTokenPosition());
        }
    }

    private void blockGetSetField(Class<?> type, String methodName) {
        if (type.isAssignableFrom(Field.class) && ("get".equals(methodName) || "set".equals(methodName))) {
            throw new ScriptSecurityException(String.format("Method 'Field.%s()' is blocked for security reasons.", methodName), type.getName(), SecurityCode.BlockedMember, this.getTokenPosition());
        }
    }

    private void blockActivatorCreateInstance(Class<?> type, String methodName) {
        if ("newInstance".equals(methodName)) {
            throw new ScriptSecurityException(String.format("Method 'Constructor.%s()' is blocked for security reasons.", methodName), type.getName(), SecurityCode.BlockedMember, this.getTokenPosition());
        }
    }

    private void blockType(Class<?> type) {
        if (type != null && this.isAllowUsingSecurityMode) {
            StiSecureClassValidator.validateClass(type.getName());
        }
    }

    private ArrayList<Object> parseMethodArguments() {
        ArrayList<Object> arguments = new ArrayList<Object>();
        this.moveNext();
        if (this.currentToken.type != StiTokenType.RPar) {
            arguments.add(this.parseExpression());
            while (this.currentToken.type == StiTokenType.Comma) {
                this.moveNext();
                arguments.add(this.parseExpression());
            }
        }
        this.waitRPar("Expected closing parenthesis in method call.").moveNext();
        return arguments;
    }

    private boolean tryCustomMethod(Class type, Object instance, String methodName, ArrayList<Object> arguments, StiRefObject<Object> result) {
        if (String.class == type) {
            switch (methodName) {
                case "IsNullOrEmpty": {
                    result.argvalue = StiValidationUtil.isNullOrEmpty((String)((String)arguments.get(0)));
                    return true;
                }
                case "ToLower": {
                    result.argvalue = ((String)instance).toLowerCase();
                    return true;
                }
                case "ToUpper": {
                    result.argvalue = ((String)instance).toUpperCase();
                    return true;
                }
            }
        } else if (Character.class == type) {
            switch (methodName) {
                case "ToUpper": {
                    result.argvalue = Character.valueOf(Character.toUpperCase(((Character)arguments.get(0)).charValue()));
                    return true;
                }
                case "ToLower": {
                    result.argvalue = Character.valueOf(Character.toLowerCase(((Character)arguments.get(0)).charValue()));
                    return true;
                }
            }
        } else if (Math.class == type) {
            switch (methodName) {
                case "Round": {
                    result.argvalue = arguments.size() == 1 ? (Number)Math.round((Double)StiConvert.changeType(arguments.get(0), Double.TYPE)) : (Number)StiMath.round((double)((Double)StiConvert.changeType(arguments.get(0), Double.TYPE)), (int)((Integer)StiConvert.changeType(arguments.get(1), Integer.class)));
                    return true;
                }
            }
        } else if (BigDecimal.class == type) {
            switch (methodName) {
                case "Parse": {
                    result.argvalue = new BigDecimal(arguments.get(0).toString());
                    return true;
                }
            }
        } else if (Boolean.class == type) {
            switch (methodName) {
                case "Parse": {
                    result.argvalue = Boolean.parseBoolean(arguments.get(0).toString());
                    return true;
                }
            }
        } else if (Double.class == type) {
            switch (methodName) {
                case "Parse": {
                    result.argvalue = Double.parseDouble(arguments.get(0).toString());
                    return true;
                }
            }
        }
        return false;
    }

    private Object invokeMethod(Class type, Object instance, String methodName, ArrayList<Object> arguments) {
        Object[] invokeArgs;
        StiRefObject<Object> result;
        if (this.isAllowUsingSecurityMode) {
            StiSecureClassValidator.validateMethod(type.getName(), methodName);
        }
        if (this.tryCustomMethod(type, instance, methodName, arguments, result = new StiRefObject<Object>(null))) {
            return result.argvalue;
        }
        String dMethodName = methodName.substring(0, 1).toLowerCase() + methodName.substring(1);
        List allMethods = Arrays.asList(type.getMethods()).stream().filter(m -> m.getName().equals(methodName) || m.getName().equals(dMethodName)).collect(Collectors.toList());
        if (allMethods.size() == 0) {
            throw new ScriptException(String.format("Method '%1$s' not found on type '%2$s'.", methodName, type.getSimpleName()), this.getTokenPosition());
        }
        List methods = allMethods.stream().filter(m -> {
            Object[] parameters = m.getParameters();
            if (parameters.length == 0 && !arguments.isEmpty()) {
                return false;
            }
            if (StiCSharpScriptParser.hasParamsArray(parameters)) {
                int requiredParamCount = parameters.length - 1;
                return arguments.size() >= requiredParamCount;
            }
            return parameters.length == arguments.size();
        }).collect(Collectors.toList());
        if (methods.size() == 0) {
            throw new ScriptException(String.format("Method '%1$s' expects different count of arguments.", methodName), this.getTokenPosition());
        }
        Executable method = null;
        if (methods.size() > 1) {
            method = methods.stream().filter(m -> {
                Object[] parameters = m.getParameters();
                if (StiCSharpScriptParser.hasParamsArray(parameters)) {
                    int nonParamsCount = parameters.length - 1;
                    for (int i = 0; i < nonParamsCount && i < arguments.size(); ++i) {
                        Object arg = arguments.get(i);
                        if (arg == null || arg.getClass().isAssignableFrom(parameters[i].getClass())) continue;
                        return false;
                    }
                    if (arguments.size() > nonParamsCount) {
                        Class<?> elementType = parameters[nonParamsCount].getClass();
                        for (int i = nonParamsCount; i < arguments.size(); ++i) {
                            Object arg = arguments.get(i);
                            if (arg == null || arg.getClass().isAssignableFrom(elementType)) continue;
                            return false;
                        }
                    }
                    return true;
                }
                if (parameters.length < arguments.size()) {
                    return false;
                }
                for (int i = 0; i < arguments.size(); ++i) {
                    Object arg = arguments.get(i);
                    if (arg == null) continue;
                    if (((Parameter)parameters[i]).getType().isPrimitive() || arg.getClass().isPrimitive()) {
                        Class<?> cl2;
                        Class<?> cl1 = ((Parameter)parameters[i]).getType().isPrimitive() ? WRAPPER_TYPE_MAP.get(((Parameter)parameters[i]).getType()) : ((Parameter)parameters[i]).getType();
                        Class<?> clazz = cl2 = arg.getClass().isPrimitive() ? WRAPPER_TYPE_MAP.get(arg.getClass()) : arg.getClass();
                        if (cl1 == cl2) continue;
                    }
                    if (arg.getClass().isAssignableFrom(((Parameter)parameters[i]).getType())) continue;
                    return false;
                }
                return true;
            }).findFirst().orElse(null);
        }
        if (method == null) {
            method = (Method)methods.get(0);
        }
        if (method == null) {
            throw new ScriptException(String.format("Method '%1$s' not found on type '%2$s'.", methodName, type.getSimpleName()), this.getTokenPosition());
        }
        Object[] methodParams = method.getParameters();
        if (StiCSharpScriptParser.hasParamsArray(methodParams)) {
            Object[] paramsArray;
            int nonParamsCount = methodParams.length - 1;
            invokeArgs = new Object[methodParams.length];
            for (int i = 0; i < nonParamsCount && i < arguments.size(); ++i) {
                invokeArgs[i] = StiConvert.changeType(arguments.get(i), ((Parameter)methodParams[i]).getType());
            }
            Class<?> elementType = ((Parameter)methodParams[nonParamsCount]).getType();
            if (arguments.size() <= nonParamsCount) {
                paramsArray = new Object[]{};
            } else {
                int paramsCount = arguments.size() - nonParamsCount;
                paramsArray = new Object[paramsCount];
                for (int i = 0; i < paramsCount; ++i) {
                    paramsArray[i] = StiConvert.changeType(arguments.get(nonParamsCount + i), elementType);
                }
            }
            invokeArgs[nonParamsCount] = paramsArray;
        } else {
            invokeArgs = new Object[methodParams.length];
            for (int i = 0; i < arguments.size(); ++i) {
                invokeArgs[i] = StiConvert.changeType(arguments.get(i), ((Parameter)methodParams[i]).getType());
            }
            if (type == String.class && dMethodName.equals("substring") && invokeArgs.length == 2) {
                invokeArgs[1] = (Integer)invokeArgs[0] + (Integer)invokeArgs[1];
            }
        }
        try {
            return ((Method)method).invoke(instance, invokeArgs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static boolean hasParamsArray(Object[] parameters) {
        return false;
    }

    private boolean setNestedPropertyOrField(Class type, Object instance, ArrayList<String> path, Object value) {
        return this.setNestedPropertyOrField(type, instance, path, value, 0);
    }

    private boolean setNestedPropertyOrField(Class type, Object instance, ArrayList<String> path, Object value, int index) {
        if (index == path.size() - 1) {
            return this.setPropertyOrField(type, instance, path.get(index), value);
        }
        Object nextInstance = null;
        Class<?> nextType = type;
        StiRefObject<Object> tempOutNextInstance = new StiRefObject<Object>(nextInstance);
        if (!this.getPropertyOrField(type, instance, path.get(index), tempOutNextInstance)) {
            nextInstance = tempOutNextInstance.argvalue;
            Object[] objectArray = new Object[2];
            objectArray[0] = path.get(index);
            objectArray[1] = (type == null ? null : type.getSimpleName()) != null ? (type == null ? null : type.getSimpleName()) : "null";
            throw new ScriptException(String.format("Property '%1$s' not found on type '%2$s'.", objectArray), this.getTokenPosition());
        }
        nextInstance = tempOutNextInstance.argvalue;
        if (nextInstance != null) {
            nextType = nextInstance.getClass();
        }
        return this.setNestedPropertyOrField(nextType, nextInstance, path, value, index + 1);
    }

    private boolean setPropertyOrField(Class type, Object instance, String name, Object value) {
        StiSecureClassValidator.validateField(type.getName(), name);
        try {
            String dName = name.substring(0, 1).toLowerCase() + name.substring(1);
            String setName = "set" + name;
            String setName2 = "Set" + name;
            Method method = Arrays.asList(type.getMethods()).stream().filter(f -> !(!Objects.equals(setName, f.getName()) && !Objects.equals(setName2, f.getName()) || f.getParameterCount() != 1 || value != null && !StiActivator.classEquals(f.getParameters()[0].getType(), value.getClass()))).findFirst().orElse(null);
            if (method != null) {
                method.invoke(instance, StiConvert.changeType(value, method.getParameters()[0].getType()));
                return true;
            }
            Field field = Arrays.asList(type.getFields()).stream().filter(f -> !(!Objects.equals(name, f.getName()) && !Objects.equals(dName, f.getName()) || value != null && !StiActivator.classEquals(f.getType(), value.getClass()))).findFirst().orElse(null);
            if (field != null) {
                field.set(instance, StiConvert.changeType(value, field.getType()));
                return true;
            }
            if (instance instanceof Map) {
                ((Map)instance).put(name, value);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new ScriptException(String.format("Property or field '%1$s' not found in %2$s.", name, type), this.getTokenPosition());
    }

    private Method findJavaMethod(Class type, String name, String dName) throws NoSuchMethodException, SecurityException {
        if (Collection.class.isAssignableFrom(type) && ("Count".equals(name) || "count".equals(dName))) {
            return type.getMethod("size", new Class[0]);
        }
        return null;
    }

    private String getDName(Class type, String name) {
        String dName;
        String string = dName = !name.equals("Count") ? name.substring(0, 1).toLowerCase() + name.substring(1) : "size";
        if (Number.class.isAssignableFrom(type)) {
            switch (name) {
                case "MaxValue": {
                    dName = "MAX_VALUE";
                    break;
                }
                case "MinValue": {
                    dName = "MIN_VALUE";
                }
            }
        }
        return dName;
    }

    private boolean getPropertyOrField(Class type, Object instance, String name, StiRefObject<Object> result) {
        boolean isStatic = instance == null;
        String dName = this.getDName(type, name);
        if (!type.isArray() && this.isAllowUsingSecurityMode) {
            StiSecureClassValidator.validateField(type.getName(), name);
        }
        try {
            Class class_;
            Method method = Arrays.asList(type.getMethods()).stream().filter(m -> m.getName().equals(dName) || m.getName().equals(name)).findFirst().orElse(null);
            Method method2 = method = method == null ? this.findJavaMethod(type, name, dName) : method;
            if (method != null) {
                result.argvalue = method.invoke(instance, new Object[0]);
                return true;
            }
            String getName = "get" + name;
            method = Arrays.asList(type.getMethods()).stream().filter(m -> m.getName().equals(getName)).findFirst().orElse(null);
            if (method != null) {
                result.argvalue = method.invoke(instance, new Object[0]);
                return true;
            }
            Field field = Arrays.asList(type.getFields()).stream().filter(f -> f.getName().equals(name) || f.getName().equals(dName)).findFirst().orElse(null);
            if (field != null) {
                result.argvalue = field.get(instance);
                return true;
            }
            if (instance == null && type != null && (class_ = (Class)Arrays.asList(type.getClasses()).stream().filter(c -> c.getSimpleName().equals(name)).findFirst().orElse(null)) != null) {
                result.argvalue = class_;
                return true;
            }
            if (type.isArray() && dName.equals("length")) {
                result.argvalue = Array.getLength(instance);
                return true;
            }
            if (instance instanceof Map && ((Map)instance).containsKey(name)) {
                result.argvalue = ((Map)instance).get(name);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        result.argvalue = null;
        return false;
    }

    private void setChainedPropertyOrField(ArrayList<Object> chain, Object value) {
        Integer index;
        StiRefObject<Object> tempOutCurrent;
        Object current = null;
        Class<?> currentType = null;
        Object first = chain.get(0);
        if (first instanceof String) {
            tempOutCurrent = new StiRefObject<Object>(current);
            if (!this.tryGetVariable((String)first, tempOutCurrent)) {
                current = tempOutCurrent.argvalue;
                throw new ScriptException(String.format("Variable '%1$s' not defined.", first), this.getTokenPosition());
            }
        } else {
            throw new ScriptException("Invalid chain start.", this.getTokenPosition());
        }
        current = tempOutCurrent.argvalue;
        currentType = current == null ? null : current.getClass();
        for (int i = 1; i < chain.size() - 1; ++i) {
            Object part = chain.get(i);
            Object next = null;
            StiRefObject<Object> tempOutNext = new StiRefObject<Object>(next);
            if (part instanceof String && this.getPropertyOrField(currentType, current, (String)part, tempOutNext)) {
                next = tempOutNext.argvalue;
                current = next;
                currentType = current == null ? null : current.getClass();
                continue;
            }
            next = tempOutNext.argvalue;
            if (current instanceof Map) {
                Map dict = (Map)current;
                if (!((Map)current).containsKey(part)) {
                    throw new ScriptException(String.format("Key '%1$s' not found in dictionary.", part), this.getTokenPosition());
                }
                current = dict.get(part);
                currentType = current == null ? null : current.getClass();
                continue;
            }
            if (current instanceof List && part instanceof Integer) {
                List list = (List)current;
                if ((Integer)part < 0 || (Integer)part >= ((List)current).size()) {
                    throw new ScriptException(String.format("Index %1$s out of range.", (Integer)part), this.getTokenPosition());
                }
                current = list.get((Integer)part);
                currentType = current == null ? null : current.getClass();
                continue;
            }
            if (part instanceof String && this.hasStringIndexer(currentType)) {
                currentType = (current = this.getStringIndexerValue(current, (String)part)) == null ? null : current.getClass();
                continue;
            }
            if (this.hasIntegerIndexer(currentType)) {
                currentType = (current = this.getIntegerIndexerValue(current, StiValueHelper.tryToInt(part))) == null ? null : current.getClass();
                continue;
            }
            if (part instanceof String) {
                Object[] objectArray = new Object[2];
                objectArray[0] = part;
                objectArray[1] = (currentType == null ? null : currentType.getSimpleName()) != null ? (currentType == null ? null : currentType.getSimpleName()) : "null";
                throw new ScriptException(String.format("Property or field '%1$s' not found on type '%2$s'.", objectArray), this.getTokenPosition());
            }
            Object[] objectArray = new Object[1];
            objectArray[0] = (currentType == null ? null : currentType.getSimpleName()) != null ? (currentType == null ? null : currentType.getSimpleName()) : "null";
            throw new ScriptException(String.format("Cannot index into type: %1$s.", objectArray), this.getTokenPosition());
        }
        Object last = chain.get(chain.size() - 1);
        if (last instanceof String) {
            if (!this.setPropertyOrField(currentType, current, (String)last, value)) {
                Object[] objectArray = new Object[2];
                objectArray[0] = last;
                objectArray[1] = (currentType == null ? null : currentType.getSimpleName()) != null ? (currentType == null ? null : currentType.getSimpleName()) : "null";
                throw new ScriptException(String.format("Property or field '%1$s' not found on type '%2$s'.", objectArray), this.getTokenPosition());
            }
        } else if (current instanceof Map) {
            ((Map)current).put(last, value);
        } else if (current.getClass().isArray() && last instanceof Number) {
            index = StiValueHelper.tryToInt(last);
            if (index < 0 || index >= Array.getLength(current)) {
                throw new ScriptException(String.format("Index %1$s out of range.", index), this.getTokenPosition());
            }
            Array.set(current, index, value);
        } else if (current instanceof List && last instanceof Number) {
            index = StiValueHelper.tryToInt(last);
            if (index < 0 || index >= ((List)current).size()) {
                throw new ScriptException(String.format("Index %1$s out of range.", index), this.getTokenPosition());
            }
            ((List)current).add(index, value);
        } else if (last instanceof String && this.hasStringIndexer(currentType)) {
            this.setStringIndexerElement(current, last, value);
        } else if (this.hasIntegerIndexer(currentType)) {
            this.setIntegerIndexerElement(current, StiValueHelper.tryToInt(last), value);
        } else {
            Object[] objectArray = new Object[1];
            objectArray[0] = (currentType == null ? null : currentType.getSimpleName()) != null ? (currentType == null ? null : currentType.getSimpleName()) : "null";
            throw new ScriptException(String.format("Cannot index into type: %1$s.", objectArray), this.getTokenPosition());
        }
    }

    private Object parseStatement() {
        this.checkTimeout();
        switch (this.currentToken.type) {
            case Ident: 
            case Keyword: {
                return this.parseKeywordOrIdentStatement();
            }
            case SemiColon: {
                this.moveNext();
                return null;
            }
            case LBrace: {
                return this.parseBlockStatement();
            }
        }
        Object result = this.parseExpression();
        this.moveNextIfSemiColon();
        return result;
    }

    private Object parseKeywordOrIdentStatement() {
        TokenState state = this.saveState();
        Class type = this.parseTypeExpression();
        this.blockType(type);
        StiRefObject<Object> tempOutResultDeclaration = new StiRefObject<Object>(null);
        if (this.parseFunctionOrVariableDeclarationStatement(type, tempOutResultDeclaration)) {
            return tempOutResultDeclaration.argvalue;
        }
        StiRefObject<Object> tempOutResultStatic = new StiRefObject<Object>(null);
        if (this.parseStaticObjectStatement(type, tempOutResultStatic)) {
            return tempOutResultStatic.argvalue;
        }
        this.restoreState(state);
        if (this.currentToken.isIdent() && this.isOperation(this.nextToken().type)) {
            return this.parseExpression();
        }
        if (this.currentToken.isIdent()) {
            return this.parseIdentStatement();
        }
        return this.parseKeywordStatement();
    }

    private Object parseKeywordStatement() {
        String keyword;
        switch (keyword = this.currentToken.getDataAsString()) {
            case "this": {
                return this.parseThisStatement();
            }
            case "if": {
                return this.parseIfStatement();
            }
            case "while": {
                return this.parseWhileStatement();
            }
            case "for": {
                return this.parseForStatement();
            }
            case "foreach": {
                return this.parseForeachStatement();
            }
            case "do": {
                return this.parseDoWhileStatement();
            }
            case "return": {
                return this.parseReturnStatement();
            }
            case "var": {
                return this.parseVariableDeclarationStatement();
            }
            case "break": {
                return this.processBreakStatement();
            }
            case "continue": {
                return this.parseContinueStatement();
            }
            case "using": {
                return this.parseUsingStatement();
            }
            case "try": {
                return this.parseTryCatchFinallyStatement();
            }
            case "new": {
                return this.parseExpression();
            }
        }
        throw new ScriptException(String.format("Unexpected keyword: %1$s.", keyword), this.getTokenPosition());
    }

    private Object parseTryCatchFinallyStatement() {
        this.moveNext();
        this.waitLBrace("Expected '{' after 'try'");
        TokenState tryBlockStart = this.saveState();
        this.skipBlockStatement();
        ArrayList<CatchClauseInfo> catchClauses = new ArrayList<CatchClauseInfo>();
        while (this.currentToken.isKeyword("catch")) {
            this.moveNext();
            Class catchType = null;
            String variableName = null;
            if (this.currentToken.IsLPar()) {
                this.moveNext();
                if (this.currentToken.IsRPar()) {
                    this.moveNext();
                    catchType = null;
                } else {
                    StringBuilder typeBuilder = new StringBuilder();
                    this.waitAnyIdentOrKeyword("Expected exception type in catch clause");
                    typeBuilder.append(this.currentToken.getDataAsString());
                    this.moveNext();
                    while (this.currentToken.IsDot()) {
                        this.moveNext();
                        this.waitAnyIdentOrKeyword("Expected identifier after '.' in exception type");
                        typeBuilder.append('.').append(this.currentToken.getDataAsString());
                        this.moveNext();
                    }
                    if (this.currentToken.isIdent() && this.nextToken().IsRPar()) {
                        variableName = this.currentToken.getDataAsString();
                        this.moveNext();
                    }
                    this.waitRPar("Expected ')' after catch clause specification").moveNext();
                    catchType = this.GetType(typeBuilder.toString());
                    if (catchType == null && !Objects.equals(typeBuilder.toString(), "")) {
                        throw new ScriptException(String.format("Type '%1$s' not found in catch clause.", typeBuilder), this.getTokenPosition());
                    }
                }
            } else {
                catchType = null;
            }
            this.waitLBrace("Expected '{' to start catch block");
            TokenState catchBlockStart = this.saveState();
            this.skipBlockStatement();
            CatchClauseInfo tempVar = new CatchClauseInfo();
            tempVar.catchType = catchType;
            tempVar.variableName = variableName;
            tempVar.blockStart = catchBlockStart;
            catchClauses.add(tempVar);
        }
        TokenState finallyBlockStart = null;
        if (this.currentToken.isKeyword("finally")) {
            this.moveNext();
            this.waitLBrace("Expected '{' after 'finally'");
            finallyBlockStart = this.saveState();
            this.skipBlockStatement();
        }
        TokenState afterTryCatchFinallyPosition = this.saveState();
        this.restoreState(tryBlockStart);
        Object tryResult = null;
        boolean exceptionOccurred = false;
        RuntimeException caughtException = null;
        try {
            tryResult = this.parseBlockStatement();
        }
        catch (BreakStatementScriptException e) {
            throw e;
        }
        catch (ContinueStatementScriptException e2) {
            throw e2;
        }
        catch (RuntimeException ex) {
            exceptionOccurred = true;
            caughtException = ex;
        }
        boolean handled = false;
        Object catchResult = null;
        if (exceptionOccurred) {
            for (CatchClauseInfo catchClause : catchClauses) {
                boolean executeThisCatch = false;
                if (catchClause.catchType == null) {
                    executeThisCatch = true;
                } else if (caughtException != null && catchClause.catchType.isAssignableFrom(caughtException.getClass())) {
                    executeThisCatch = true;
                }
                if (!executeThisCatch) continue;
                if (!StiValidationUtil.isNullOrEmpty((String)catchClause.variableName)) {
                    this.setVariable(catchClause.variableName, caughtException);
                }
                this.restoreState(catchClause.blockStart);
                catchResult = this.parseBlockStatement();
                handled = true;
                break;
            }
        }
        Object finallyResult = null;
        if (finallyBlockStart != null) {
            this.restoreState(finallyBlockStart);
            finallyResult = this.parseBlockStatement();
        }
        this.restoreState(afterTryCatchFinallyPosition);
        if (exceptionOccurred && !handled) {
            throw caughtException;
        }
        if (handled) {
            return catchResult;
        }
        if (finallyResult != null) {
            return finallyResult;
        }
        return tryResult;
    }

    private boolean parseFunctionOrVariableDeclarationStatement(Class type, StiRefObject<Object> result) {
        if (type != null) {
            StiToken t1 = this.nextToken();
            if (t1.IsLBracket() && this.nextToken2().IsRBracket() && this.nextToken3().isIdent()) {
                result.argvalue = this.parseVariableDeclarationStatement(type);
                return true;
            }
            if (t1.isIdent()) {
                result.argvalue = this.nextToken2().IsLPar() ? this.parseFunctionDeclarationStatement(type) : this.parseVariableDeclarationStatement(type);
                return true;
            }
        }
        result.argvalue = null;
        return false;
    }

    private boolean parseStaticObjectStatement(Class type, StiRefObject<Object> result) {
        if (type != null && this.nextToken().IsDot()) {
            this.moveNext();
            if (this.currentToken.IsDot()) {
                this.moveNext();
                if (this.isAssignOperation(this.nextToken().type)) {
                    String name = this.currentToken.getDataAsString();
                    this.moveNext();
                    StiTokenType tokenType = this.currentToken.type;
                    this.moveNext();
                    Object propValue = null;
                    StiRefObject<Object> tempOutPropValue = new StiRefObject<Object>(propValue);
                    if (this.getPropertyOrField(type, null, name, tempOutPropValue)) {
                        propValue = tempOutPropValue.argvalue;
                        propValue = this.parseAssignOperation(tokenType, propValue);
                        this.setPropertyOrField(type, null, name, propValue);
                        result.argvalue = propValue;
                        return true;
                    }
                    propValue = tempOutPropValue.argvalue;
                } else if (this.nextToken().IsDot() && this.nextToken2().isIdent()) {
                    String name = this.currentToken.getDataAsString();
                    this.moveNext();
                    Object value = null;
                    StiRefObject<Object> tempOutPropValue2 = new StiRefObject<Object>(null);
                    if (this.getPropertyOrField(type, null, name, tempOutPropValue2)) {
                        value = tempOutPropValue2.argvalue;
                    }
                    result.argvalue = this.parsePropertyOrMethodCall(value, null);
                    return true;
                }
            }
        }
        result.argvalue = null;
        return false;
    }

    private Object parseIdentStatement() {
        StiRefObject<Object> value;
        String identifier = this.currentToken.getDataAsString();
        this.moveNext();
        if (this.currentToken.IsLBracket() || this.currentToken.IsDot()) {
            TokenState state = this.saveState();
            ArrayList<Object> chain = new ArrayList<Object>(Arrays.asList(identifier));
            while (this.currentToken.IsLBracket() || this.currentToken.IsDot()) {
                if (this.currentToken.IsLBracket()) {
                    this.moveNext();
                    Object index = this.parseExpression();
                    chain.add((String)index);
                    this.waitRBracket().moveNext();
                    continue;
                }
                if (!this.currentToken.IsDot()) continue;
                this.moveNext();
                this.waitAnyIdentOrKeyword("Expected property or method name after '.'");
                String memberName = this.currentToken.getDataAsString();
                chain.add(memberName);
                this.moveNext();
            }
            StiTokenType tokenType = this.currentToken.type;
            if (this.isAssignOperation(tokenType)) {
                this.moveNext();
                Object value2 = this.parseAssignOperation(tokenType, null);
                this.setChainedPropertyOrField(chain, value2);
                this.moveNextIfSemiColon();
                return value2;
            }
            this.restoreState(state);
        }
        ArrayList<String> path = this.parseAssignPropertyChain(identifier);
        StiTokenType tokenType2 = this.currentToken.type;
        if (this.isAssignOperation(tokenType2)) {
            boolean isType;
            Class type = this.GetType(identifier);
            boolean bl = isType = type != null;
            if (isType && path.size() > 1) {
                this.moveNext();
                Object value3 = this.parseAssignOperation(tokenType2, null);
                this.setNestedPropertyOrField(type, null, path, value3);
                this.moveNextIfSemiColon();
                return value3;
            }
            Object currentValue = null;
            StiRefObject<Object> tempOutCurrentValue = new StiRefObject<Object>(currentValue);
            if (!this.tryGetVariable(identifier, tempOutCurrentValue)) {
                currentValue = tempOutCurrentValue.argvalue;
                throw new ScriptException(String.format("Variable '%1$s' not defined.", identifier), this.getTokenPosition());
            }
            currentValue = tempOutCurrentValue.argvalue;
            this.moveNext();
            currentValue = this.parseAssignOperation(tokenType2, currentValue);
            if (path.size() > 1) {
                this.setVariable(identifier, path, currentValue);
            } else {
                this.setVariable(identifier, currentValue);
            }
            this.moveNextIfSemiColon();
            return currentValue;
        }
        if (this.currentToken.IsLPar()) {
            return this.parseFunctionCallExpression(identifier);
        }
        if (this.currentToken.IsLBracket()) {
            Object array = null;
            StiRefObject<Object> tempOutArray = new StiRefObject<Object>(array);
            if (!this.tryGetVariable(identifier, tempOutArray)) {
                array = tempOutArray.argvalue;
                throw new ScriptException(String.format("Variable '%1$s' not defined.", identifier), this.getTokenPosition());
            }
            array = tempOutArray.argvalue;
            this.moveNext();
            Object index = this.parseExpression();
            this.waitRBracket().moveNext();
            this.waitAssign().moveNext();
            Object value4 = this.setElementExpression(array, index);
            this.moveNextIfSemiColon();
            return value4;
        }
        if (this.currentToken.IsDot()) {
            value = this.parseNestedExpression(identifier);
            this.moveNextIfSemiColon();
            if (this.currentToken.type == StiTokenType.Question) {
                value = this.parseTernaryExpression(value);
            }
            return value;
        }
        if (this.currentToken.type == StiTokenType.SemiColon || this.currentToken.type == StiTokenType.EOF) {
            value = new StiRefObject<Object>(null);
            if (!this.tryGetVariable(identifier, value)) {
                throw new ScriptException(String.format("Variable '%s' not defined.", this.getTokenPosition()));
            }
            this.moveNextIfSemiColon();
            return value.argvalue;
        }
        throw new ScriptException(String.format("An unexpected identifier %1$s was encountered.", new Object[]{this.currentToken.type}), this.getTokenPosition());
    }

    private Object parseUsingStatement() {
        if (!this.isAllowUsingDirective) {
            throw new ScriptException("'using' directive is not allowed in this script.", this.getTokenPosition());
        }
        this.moveNext();
        this.waitAnyIdentOrKeyword("Expected namespace after 'using'");
        StringBuilder namespaceBuilder = new StringBuilder(this.currentToken.getDataAsString());
        this.moveNext();
        while (this.currentToken.IsDot()) {
            namespaceBuilder.append('.');
            this.moveNext();
            this.waitAnyIdentOrKeyword("Expected identifier after '.' in namespace");
            namespaceBuilder.append(this.currentToken.getDataAsString());
            this.moveNext();
        }
        this.namespaces.add(namespaceBuilder.toString());
        this.waitSemiColon("Expected ';' after namespace").moveNext();
        return null;
    }

    private Object processBreakStatement() {
        this.moveNext();
        this.moveNextIfSemiColon();
        throw new BreakStatementScriptException();
    }

    private Object parseContinueStatement() {
        this.moveNext();
        this.moveNextIfSemiColon();
        throw new ContinueStatementScriptException();
    }

    private void skipBlockStatement() {
        this.moveNext();
        int braceCount = 1;
        while (braceCount > 0 && this.currentToken.type != StiTokenType.EOF) {
            if (this.currentToken.type == StiTokenType.LBrace) {
                ++braceCount;
            } else if (this.currentToken.type == StiTokenType.RBrace) {
                --braceCount;
            }
            this.moveNext();
        }
        if (braceCount > 0) {
            throw new ScriptException(String.format("Unmatched opening brace '{{'.", new Object[0]), this.getTokenPosition());
        }
    }

    private Object parseVariableDeclarationStatement() {
        return this.parseVariableDeclarationStatement(null);
    }

    private Object parseVariableDeclarationStatement(Class type) {
        type = type != null ? type : this.GetType(this.currentToken.getDataAsString());
        String typeName = null;
        if (this.currentToken.isKeyword() || type != null) {
            typeName = type != null ? type.getName() : this.currentToken.getDataAsString();
            this.moveNext();
        } else if (this.currentToken.isKeyword("var")) {
            typeName = "var";
            this.moveNext();
        } else {
            throw new ScriptException(String.format("Expected type or 'var', but found '%1$s'.", this.currentToken.data), this.getTokenPosition());
        }
        boolean isArrayDeclarator = false;
        if (this.currentToken.IsLBracket() && this.nextToken().IsRBracket()) {
            this.moveNext();
            this.moveNext();
            isArrayDeclarator = true;
        }
        this.waitAnyIdentOrKeyword("Expected identifier after type or 'var'");
        String variableName = this.currentToken.getDataAsString();
        this.moveNext();
        Object value = null;
        if (this.currentToken.type == StiTokenType.Assign) {
            this.moveNext();
            value = this.parseExpression();
        }
        if (!Objects.equals(typeName, "var") && !isArrayDeclarator) {
            Class expectedType = this.GetType(typeName);
            if (expectedType == null) {
                throw new ScriptException(String.format("Unknown type: %1$s.", typeName), this.getTokenPosition());
            }
            Class variableType = this.GetType(typeName);
            value = this.convertToType(value, typeName);
        }
        this.setVariable(variableName, value);
        this.moveNextIfSemiColon();
        return value;
    }

    private Object parseBlockStatement() {
        this.moveNext();
        Object result = null;
        while (this.currentToken.type != StiTokenType.RBrace && this.currentToken.type != StiTokenType.EOF) {
            result = this.parseStatement();
        }
        this.waitRBrace().moveNext();
        return result;
    }

    private Object parseThisStatement() {
        StiToken token = this.getTokenAfterFullIdent();
        if (this.isAssignOperation(token.type)) {
            this.waitKeyword("this").moveNext();
            if (this.currentToken.IsDot()) {
                this.waitDot().moveNext();
                return this.parseIdentStatement();
            }
            this.moveNext();
            Object index = this.parseExpression();
            this.waitRBracket().moveNext();
            this.waitAssign().moveNext();
            this.setElementExpression(this.thisObject, index);
            return this.thisObject;
        }
        return this.parseExpression();
    }

    private Object parseIfStatement() {
        this.moveNext();
        this.waitLPar("Expected '(' after 'if'").moveNext();
        Object condition = this.parseExpression();
        this.waitRPar("Expected ')' after 'if' condition").moveNext();
        Object result = null;
        if (Boolean.parseBoolean(condition.toString())) {
            result = this.parseStatement();
            while (this.currentToken.isKeyword("else")) {
                this.moveNext();
                if (this.currentToken.isKeyword("if")) {
                    this.moveNext();
                    this.waitLPar().moveNext();
                    this.skipExpression();
                    this.waitRPar().moveNext();
                    this.skipStatement();
                    continue;
                }
                this.skipStatement();
                break;
            }
        } else {
            this.skipStatement();
            if (this.currentToken.isKeyword("else")) {
                this.moveNext();
                result = this.currentToken.isKeyword("if") ? this.parseIfStatement() : this.parseStatement();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseWhileStatement() {
        this.moveNext();
        this.waitLPar("Expected '(' after 'while'");
        int conditionPosition = this.savePosition();
        this.moveNext();
        Object condition = this.parseExpression();
        this.waitRPar("Expected ')' after while condition");
        int bodyPosition = this.savePosition();
        this.moveNext();
        Object result = null;
        int iterationCount = 0;
        while (((Boolean)condition).booleanValue()) {
            this.checkTimeout();
            this.validateLoopIterations(++iterationCount, "while");
            try {
                result = this.parseStatement();
            }
            catch (BreakStatementScriptException e) {
                break;
            }
            catch (ContinueStatementScriptException e2) {}
            continue;
            finally {
                this.restorePosition(conditionPosition);
                this.moveNext();
                condition = this.parseExpression();
                this.moveNextIfRPar();
                this.restorePosition(bodyPosition);
                this.moveNext();
            }
        }
        this.skipStatement();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseDoWhileStatement() {
        int statementIndex = this.savePosition();
        this.moveNext();
        this.skipStatement();
        this.waitKeyword("while").moveNext();
        this.waitLPar("Expected '(' after 'while'");
        int conditionIndex = this.savePosition();
        this.moveNext();
        Object condition = this.parseExpression();
        this.waitRPar("Expected ')' after condition in 'do-while'").moveNext();
        Object result = null;
        int iterationCount = 0;
        while (((Boolean)condition).booleanValue()) {
            this.validateLoopIterations(++iterationCount, "do-while");
            try {
                this.restorePosition(statementIndex);
                this.moveNext();
                result = this.parseStatement();
            }
            catch (BreakStatementScriptException e) {
                break;
            }
            catch (ContinueStatementScriptException e2) {}
            continue;
            finally {
                this.restorePosition(conditionIndex);
                this.moveNext();
                condition = this.parseExpression();
            }
        }
        this.moveNext();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseForStatement() {
        this.waitKeyword("for");
        this.moveNext();
        this.waitLPar("Expected '(' after 'for'").moveNext();
        this.parseStatement();
        TokenState conditionState = this.saveState();
        Object condition = this.parseExpression();
        this.waitSemiColon("Expected ';' after for condition");
        int incrementPosition = this.savePosition();
        this.moveNext();
        StiToken incrementToken = this.currentToken;
        this.skipExpression();
        this.waitRPar("Expected ')' after for increment.");
        int bodyPosition = this.savePosition();
        this.moveNext();
        Object result = null;
        int iterationCount = 0;
        while (((Boolean)condition).booleanValue()) {
            this.checkTimeout();
            this.validateLoopIterations(++iterationCount, "for");
            try {
                this.restorePosition(bodyPosition);
                this.moveNext();
                result = this.parseStatement();
            }
            catch (BreakStatementScriptException e) {
                break;
            }
            catch (ContinueStatementScriptException e2) {}
            continue;
            finally {
                this.restorePosition(incrementPosition);
                this.moveNext();
                this.parseStatement();
                this.restoreState(conditionState);
                condition = this.parseExpression();
            }
        }
        this.restorePosition(bodyPosition);
        this.moveNext();
        this.skipStatement();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseForeachStatement() {
        Iterable<Object> enumerable;
        this.waitKeyword("foreach").moveNext();
        this.waitLPar(String.format("Expected '(' after 'foreach'", new Object[0])).moveNext();
        if (this.currentToken.isKeyword("var")) {
            this.waitAnyIdentOrKeyword("Expected variable name identifier for iteration variable in 'foreach'").moveNext();
        } else {
            this.waitIdentOrKeywordType(String.format("Expected type for iteration variable in 'foreach'", new Object[0])).moveNext();
        }
        String iterationVariable = this.currentToken.getDataAsString();
        this.moveNext();
        this.waitKeyword("in", "Expected 'in' in 'foreach'.").moveNext();
        Object collection = this.parseExpression();
        if (!(collection instanceof Iterable || collection instanceof Map || collection.getClass().isArray())) {
            throw new ScriptException(String.format("The collection in 'foreach' must implement IEnumerable.", new Object[0]), this.getTokenPosition());
        }
        this.waitRPar("Expected ')' after collection in 'foreach'").moveNext();
        TokenState state = this.saveState();
        Object result = null;
        int iterationCount = 0;
        List<Object> list = enumerable = collection instanceof Iterable ? (List<Object>)collection : null;
        if (collection instanceof Map) {
            enumerable = ((Map)collection).keySet().stream().map(k -> new AbstractMap.SimpleEntry(k, ((Map)collection).get(k))).collect(Collectors.toList());
        }
        if (collection.getClass().isArray()) {
            enumerable = Arrays.asList((Object[])collection);
        }
        for (Object t : enumerable) {
            this.checkTimeout();
            this.validateLoopIterations(++iterationCount, "foreach");
            this.setVariable(iterationVariable, t);
            try {
                result = this.parseStatement();
            }
            catch (BreakStatementScriptException e) {
                break;
            }
            catch (ContinueStatementScriptException e2) {}
            continue;
            finally {
                this.restoreState(state);
            }
        }
        this.skipStatement();
        return result;
    }

    private Object parseReturnStatement() {
        this.moveNext();
        Object result = this.parseExpression();
        this.moveNextIfSemiColon();
        return result;
    }

    private void validateLoopIterations(int iterationCount, String loopType) {
        if (this.maxLoopIterationsToUse > 0 && iterationCount > this.maxLoopIterationsToUse) {
            throw new ScriptSecurityException(String.format("Loop iteration count %s exceeds the maximum allowed of %s. Loop type: %s. This limit protects against infinite loops and excessive execution time.", iterationCount, this.maxLoopIterationsToUse, loopType), loopType, SecurityCode.LoopIterationsExceeded, this.getTokenPosition());
        }
    }

    private Object parseFunctionDeclarationStatement(Class returnType) {
        this.moveNext();
        this.waitAnyIdentOrKeyword(String.format("Expected function name, but found '%1$s'", this.currentToken.data));
        String functionName = this.currentToken.getDataAsString();
        this.moveNext();
        this.waitLPar(String.format("Expected '(' after function name '%1$s', but found '%2$s'", functionName, this.currentToken.data));
        ArrayList<AbstractMap.SimpleEntry<String, String>> parameters = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        this.moveNext();
        if (!this.currentToken.IsRPar()) {
            while (true) {
                this.waitAnyIdentOrKeyword(String.format("Expected parameter type, but found '%1$s'", this.currentToken.data));
                String paramType = this.currentToken.getDataAsString();
                this.moveNext();
                this.waitAnyIdentOrKeyword(String.format("Expected parameter name, but found '%1$s'", this.currentToken.data));
                String paramName = this.currentToken.getDataAsString();
                parameters.add(new AbstractMap.SimpleEntry<String, String>(paramName, paramType));
                this.moveNext();
                if (this.currentToken.type != StiTokenType.Comma) break;
                this.moveNext();
            }
            if (!this.currentToken.IsRPar()) {
                throw new ScriptException(String.format("Expected ',' or ')', but found '%1$s'.", this.currentToken.data), this.getTokenPosition());
            }
        }
        this.moveNext();
        this.waitLBrace(String.format("Expected '{' to start function body, but found '%1$s'", this.currentToken.data));
        int functionBodyPosition = this.savePosition();
        this.skipBlockStatement();
        this.functions.put(functionName, args -> {
            HashMap<String, Object> oldVariables = new HashMap<String, Object>(this.variables);
            TokenState previousState = this.saveState();
            this.restorePosition(functionBodyPosition);
            try {
                for (int i = 0; i < parameters.size() && i < ((Object[])args).length; ++i) {
                    String paramName = (String)((AbstractMap.SimpleEntry)parameters.get(i)).getKey();
                    String paramType = (String)((AbstractMap.SimpleEntry)parameters.get(i)).getValue();
                    this.setVariable(paramName, this.convertToType(args[i], paramType));
                }
                Object result = this.parseBlockStatement();
                Object object = this.convertToReturnType(result, returnType.getName());
                return object;
            }
            finally {
                this.restoreState(previousState);
                this.variables = oldVariables;
            }
        });
        return null;
    }

    private void skipStatement() {
        switch (this.currentToken.type) {
            case LBrace: {
                this.skipBlockStatement();
                break;
            }
            case Keyword: {
                String keyword;
                switch (keyword = this.currentToken.getDataAsString()) {
                    case "if": {
                        this.moveNext();
                        this.moveNext();
                        this.skipExpression();
                        this.moveNext();
                        this.skipStatement();
                        if (!this.currentToken.isKeyword("else")) break;
                        this.moveNext();
                        this.skipStatement();
                        break;
                    }
                    case "while": 
                    case "for": {
                        this.moveNext();
                        this.moveNext();
                        if (Objects.equals(keyword, "for")) {
                            this.skipStatement();
                            this.skipExpression();
                            this.moveNext();
                            this.skipExpression();
                        } else {
                            this.skipExpression();
                        }
                        this.moveNext();
                        this.skipStatement();
                        break;
                    }
                    case "return": {
                        this.moveNext();
                        this.skipExpression();
                        this.moveNextIfSemiColon();
                        break;
                    }
                    case "var": {
                        this.moveNext();
                        this.moveNext();
                        if (this.currentToken.IsAssign()) {
                            this.moveNext();
                            this.skipExpression();
                        }
                        this.moveNextIfSemiColon();
                        break;
                    }
                    case "function": {
                        this.moveNext();
                        this.moveNext();
                        this.moveNext();
                        while (!this.currentToken.IsRPar()) {
                            this.moveNext();
                        }
                        this.moveNext();
                        this.skipBlockStatement();
                    }
                }
                break;
            }
            case SemiColon: {
                this.moveNext();
                break;
            }
            default: {
                this.skipExpression();
                this.moveNextIfSemiColon();
            }
        }
    }

    private void loadTokensWithPositions(String text) {
        StiLexer lexer = new StiLexer(text);
        int line = 1;
        int column = 1;
        this.tokens = new ArrayList();
        this.tokenPositions = new ArrayList();
        block0: while (true) {
            StiToken token = lexer.getToken();
            if (token.type == StiTokenType.EOF) break;
            this.tokens.add(token);
            this.tokenPositions.add(new TokenPosition(line, column));
            char[] cArray = token.getDataAsString() != null ? token.getDataAsString().toCharArray() : "".toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                char c = cArray[n2];
                if (c == '\n') {
                    ++line;
                    column = 1;
                } else {
                    ++column;
                }
                ++n2;
            }
            break;
        }
    }

    private StiToken getTokenAfterFullIdent() {
        TokenState state = this.saveState();
        this.moveNext();
        while (this.currentToken.IsDot() || this.currentToken.IsLBracket()) {
            if (this.currentToken.IsDot()) {
                this.moveNext();
                this.waitIdent();
                this.moveNext();
                continue;
            }
            if (!this.currentToken.IsLBracket()) continue;
            this.moveNext();
            this.skipExpression();
            this.waitRBracket().moveNext();
        }
        StiToken token = this.currentToken;
        this.restoreState(state);
        return token;
    }

    private TokenPosition getTokenPosition() {
        if (this.currentTokenIndex > 0 && this.currentTokenIndex <= this.tokenPositions.size()) {
            return this.tokenPositions.get(this.currentTokenIndex - 1);
        }
        return null;
    }

    private TokenState saveState() {
        TokenState tempVar = new TokenState();
        tempVar.setIndex(this.currentTokenIndex);
        tempVar.setToken(this.currentToken);
        return tempVar;
    }

    private void restoreState(TokenState state) {
        this.currentTokenIndex = state.getIndex();
        this.currentToken = state.getToken();
    }

    private StiToken nextToken() {
        if (this.currentTokenIndex < this.tokens.size()) {
            return this.tokens.get(this.currentTokenIndex);
        }
        return StiToken.EOF;
    }

    private StiToken nextToken3() {
        if (this.currentTokenIndex + 2 < this.tokens.size()) {
            return this.tokens.get(this.currentTokenIndex + 2);
        }
        return StiToken.EOF;
    }

    private StiToken nextToken2() {
        if (this.currentTokenIndex + 1 < this.tokens.size()) {
            return this.tokens.get(this.currentTokenIndex + 1);
        }
        return StiToken.EOF;
    }

    private void moveNext() {
        this.currentToken = this.currentTokenIndex < this.tokens.size() ? this.tokens.get(this.currentTokenIndex++) : StiToken.EOF;
    }

    private void moveNextIfSemiColon() {
        if (this.currentToken.type == StiTokenType.SemiColon) {
            this.moveNext();
        }
    }

    private void moveNextIfRPar() {
        if (this.currentToken.IsRPar()) {
            this.moveNext();
        }
    }

    private int savePosition() {
        return this.currentTokenIndex;
    }

    private void restorePosition(int position) {
        this.currentTokenIndex = position;
    }

    private StiCSharpScriptParser waitAssign() {
        return this.waitAssign(null);
    }

    private StiCSharpScriptParser waitAssign(String message) {
        if (this.currentToken.type != StiTokenType.Assign) {
            throw new ScriptException(message != null ? message : "Expected assignment operator '='.", this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitColon() {
        return this.waitColon(null);
    }

    private StiCSharpScriptParser waitColon(String message) {
        if (this.currentToken.type != StiTokenType.Colon) {
            throw new ScriptException(message != null ? message : "Expected ':'.", this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitComma() {
        return this.waitComma(null);
    }

    private StiCSharpScriptParser waitComma(String message) {
        if (this.currentToken.type != StiTokenType.Comma) {
            throw new ScriptException(message != null ? message : String.format("Expected ','.", new Object[0]), this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitSemiColon() {
        return this.waitSemiColon(null);
    }

    private StiCSharpScriptParser waitSemiColon(String message) {
        if (this.currentToken.type != StiTokenType.SemiColon) {
            throw new ScriptException(message != null ? message : "Expected ';'.", this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitLeft() {
        return this.waitLeft(null);
    }

    private StiCSharpScriptParser waitLeft(String message) {
        if (this.currentToken.type != StiTokenType.Left) {
            throw new ScriptException(message != null ? message : String.format("Expected '<'", new Object[0]), this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitRight() {
        return this.waitRight(null);
    }

    private StiCSharpScriptParser waitRight(String message) {
        if (this.currentToken.type != StiTokenType.Right) {
            throw new ScriptException(message != null ? message : String.format("Expected '>'.", new Object[0]), this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitLBracket() {
        return this.waitLBracket(null);
    }

    private StiCSharpScriptParser waitLBracket(String message) {
        if (!this.currentToken.IsLBracket()) {
            throw new ScriptException(message != null ? message : "Expected opening bracket '['.", this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitRBracket() {
        return this.waitRBracket(null);
    }

    private StiCSharpScriptParser waitRBracket(String message) {
        if (!this.currentToken.IsRBracket()) {
            throw new ScriptException(message != null ? message : "Expected closing bracket ']'.", this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitLBrace() {
        return this.waitLBrace(null);
    }

    private StiCSharpScriptParser waitLBrace(String message) {
        if (this.currentToken.type != StiTokenType.LBrace) {
            throw new ScriptException(message != null ? message : String.format("Expected opening brace '{', but found %1$s.", new Object[]{this.currentToken.type}), this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitRBrace() {
        return this.waitRBrace(null);
    }

    private StiCSharpScriptParser waitRBrace(String message) {
        if (this.currentToken.type != StiTokenType.RBrace) {
            throw new ScriptException(message != null ? message : String.format("Expected closing brace '}', but found %1$s.", new Object[]{this.currentToken.type}), this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitLPar() {
        return this.waitLPar(null);
    }

    private StiCSharpScriptParser waitLPar(String message) {
        if (!this.currentToken.IsLPar()) {
            throw new ScriptException(message != null ? message : "Expected opening parenthesis.", this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitRPar() {
        return this.waitRPar(null);
    }

    private StiCSharpScriptParser waitRPar(String message) {
        if (!this.currentToken.IsRPar()) {
            throw new ScriptException(message != null ? message : "Expected closing parenthesis.", this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitAnyIdentOrKeyword() {
        return this.waitAnyIdentOrKeyword(null);
    }

    private StiCSharpScriptParser waitAnyIdentOrKeyword(String message) {
        if (!this.currentToken.IsIdentOrKeyword()) {
            throw new ScriptException(message != null ? message : "Expected ident or keyword.", this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitAnyIdent() {
        return this.waitAnyIdent(null);
    }

    private StiCSharpScriptParser waitAnyIdent(String message) {
        if (!this.currentToken.isIdent()) {
            throw new ScriptException(message != null ? message : "Expected ident or keyword.", this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitIdent(String ident) {
        return this.waitIdent(ident, null);
    }

    private StiCSharpScriptParser waitIdent(String ident, String message) {
        if (!this.currentToken.isIdent(ident)) {
            throw new ScriptException(message != null ? message : String.format("Expected '%1$s').", ident), this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitIdent() {
        if (!this.currentToken.isIdent()) {
            throw new ScriptException(String.format("Expected ident.).", new Object[0]), this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitDot() {
        if (!this.currentToken.IsDot()) {
            throw new ScriptException(String.format("Expected dot.).", new Object[0]), this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitKeyword(String keyword) {
        return this.waitKeyword(keyword, null);
    }

    private StiCSharpScriptParser waitKeyword(String keyword, String message) {
        if (!this.currentToken.isKeyword(keyword)) {
            throw new ScriptException(message != null ? message : String.format("Expected '%1$s' keyword.", keyword), this.getTokenPosition());
        }
        return this;
    }

    private StiCSharpScriptParser waitIdentOrKeywordType() {
        return this.waitIdentOrKeywordType(null);
    }

    private StiCSharpScriptParser waitIdentOrKeywordType(String message) {
        Class type;
        if (this.currentToken.IsIdentOrKeyword() && (type = this.GetType(this.currentToken.getDataAsString())) != null) {
            return this;
        }
        throw new ScriptException(message != null ? message : "Expected type keyword.", this.getTokenPosition());
    }

    public final ArrayList<StiToken> getTokens() {
        return this.tokens;
    }

    public final ArrayList<TokenPosition> getTokenPositions() {
        return this.tokenPositions;
    }

    private boolean isNullableType(Class type) {
        return true;
    }

    private boolean isIntegerType(Object value) {
        return value instanceof Byte || value instanceof Byte || value instanceof Short || value instanceof Short || value instanceof Integer || value instanceof Integer || value instanceof Long || value instanceof Long;
    }

    private boolean isFloatingType(Object value) {
        return value instanceof Float || value instanceof Double;
    }

    private Object createArray(String typeName, int size) {
        switch (typeName) {
            case "byte": 
            case "Byte": {
                return new int[size];
            }
            case "sbyte": 
            case "SByte": {
                return new int[size];
            }
            case "short": 
            case "Int16": {
                return new int[size];
            }
            case "ushort": {
                return new int[size];
            }
            case "int": 
            case "Int32": {
                return new long[size];
            }
            case "uint": 
            case "UInt32": {
                return new long[size];
            }
            case "long": 
            case "Int64": {
                return new long[size];
            }
            case "ulong": {
                return new long[size];
            }
            case "float": 
            case "Single": {
                return new float[size];
            }
            case "double": {
                return new double[size];
            }
            case "decimal": 
            case "Decimal": {
                return new BigDecimal[size];
            }
            case "char": 
            case "Char": {
                return new char[size];
            }
            case "string": 
            case "String": {
                return new String[size];
            }
            case "bool": 
            case "Boolean": {
                return new boolean[size];
            }
            case "DateTime": {
                return new StiDateTime[size];
            }
            case "DateTimeOffset": {
                return new StiDateTimeOffset[size];
            }
            case "TimeSpan": {
                return new StiTimeSpan[size];
            }
            case "Guid": {
                return new StiGuid[size];
            }
            case "Color": {
                return new StiColor[size];
            }
            case "object": 
            case "Object": {
                return new Object[size];
            }
        }
        return new Object[size];
    }

    private Object convertToType(Object value, String type) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case "byte": 
            case "java.lang.Byte": 
            case "sbyte": 
            case "Byte": 
            case "SByte": {
                return StiValueHelper.tryToInt(value);
            }
            case "short": 
            case "ushort": 
            case "Int16": {
                return StiValueHelper.tryToInt(value);
            }
            case "int": 
            case "uint": 
            case "UInt16": 
            case "Int32": 
            case "UInt32": {
                return StiValueHelper.tryToLong(value);
            }
            case "long": 
            case "ulong": {
                return StiValueHelper.tryToLong(value);
            }
            case "float": 
            case "Single": {
                return StiValueHelper.tryToDecimal(value);
            }
            case "double": 
            case "Double": {
                return StiValueHelper.tryToDecimal(value);
            }
            case "decimal": 
            case "Decimal": {
                return StiValueHelper.tryToDecimal(value);
            }
            case "char": 
            case "Char": {
                return Character.valueOf(StiValueHelper.tryToChar(value));
            }
            case "string": {
                return StiValueHelper.tryToString(value);
            }
            case "bool": 
            case "Boolean": {
                return StiValueHelper.tryToBool(value);
            }
            case "DateTime": {
                return StiValueHelper.tryToDateTime(value);
            }
            case "TimeSpan": {
                return StiValueHelper.TryToTimeSpan(value);
            }
            case "Guid": {
                return StiValueHelper.tryToGuid(value);
            }
            case "object": 
            case "Object": {
                return value;
            }
        }
        Class realType = this.GetType(type);
        if (realType != null) {
            return StiConvert.changeType(value, realType);
        }
        throw new ScriptException("Unsupported parameter type: {type}.", this.getTokenPosition());
    }

    private Object convertToReturnType(Object result, String returnType) {
        if (Objects.equals(returnType, "void")) {
            return null;
        }
        return this.convertToType(result, returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class GetType(String name) {
        Class type;
        if (name == null || StiValidationUtil.isNullOrEmpty((String)name)) {
            return null;
        }
        name = name.replace("Stimulsoft.Report.StiOptions", "StiOptions");
        Pattern pattern = Pattern.compile(".*?StiOptions\\$(.+?)\\$(.+)");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            name = "com.stimulsoft.report.options." + matcher.group(1) + "Options$" + matcher.group(2);
        }
        Object object = lockTypeCache;
        synchronized (object) {
            Object tempVar = this.getNameToTypeCache().get(name);
            type = tempVar instanceof Class ? (Class)tempVar : null;
        }
        if (type != null) {
            return type == NillType.class ? null : type;
        }
        type = this.getStandardType(name);
        if (type != null) {
            object = lockTypeCache;
            synchronized (object) {
                this.getNameToTypeCache().put(name, type);
            }
            return type;
        }
        for (String ns : this.namespaces) {
            String fullName = name.startsWith(ns) ? name : String.format("%1$s.%2$s", ns, name);
            Class tp = StiTypeFinder.getType(fullName);
            if (tp == null && Objects.equals(ns, "System.Collections.Generic")) {
                tp = StiCSharpScriptParser.getGenericCollectionType(name);
            }
            if (tp == null) {
                tp = this.getStandardType(fullName);
            }
            if (tp == null) continue;
            Object object2 = lockTypeCache;
            synchronized (object2) {
                this.getNameToTypeCache().put(name, tp);
            }
            return tp;
        }
        object = lockTypeCache;
        synchronized (object) {
            this.getNameToTypeCache().put(name, NillType.class);
        }
        return null;
    }

    private static Class getGenericCollectionType(String name) {
        Class type = null;
        if (type != null) {
            return type;
        }
        if (Objects.equals(name, "Dictionary") || Objects.equals(name, "System.Collections.Generic.Dictionary")) {
            return HashMap.class;
        }
        if (Objects.equals(name, "SortedList") || Objects.equals(name, "System.Collections.Generic.SortedList")) {
            return SortedList.class;
        }
        return null;
    }

    private Class getStandardType(String name) {
        switch (name) {
            case "byte": 
            case "Byte": {
                return Integer.class;
            }
            case "sbyte": 
            case "SByte": {
                return Integer.class;
            }
            case "short": 
            case "Int16": {
                return Integer.class;
            }
            case "ushort": 
            case "UInt16": {
                return Integer.class;
            }
            case "int": 
            case "Int32": {
                return Long.class;
            }
            case "uint": 
            case "UInt32": {
                return Long.class;
            }
            case "long": 
            case "Int64": {
                return Long.class;
            }
            case "ulong": 
            case "UInt64": {
                return Long.class;
            }
            case "float": 
            case "Single": {
                return Float.class;
            }
            case "double": 
            case "Double": {
                return Double.class;
            }
            case "decimal": 
            case "BigDecimal": 
            case "Decimal": {
                return BigDecimal.class;
            }
            case "char": 
            case "Char": {
                return Character.class;
            }
            case "string": 
            case "System.String": 
            case "String": {
                return String.class;
            }
            case "bool": 
            case "System.Boolean": 
            case "Boolean": {
                return Boolean.class;
            }
            case "datetime": 
            case "DateTime": {
                return StiDateTime.class;
            }
            case "DateTimeOffset": {
                return StiDateTimeOffset.class;
            }
            case "timespan": 
            case "TimeSpan": {
                return StiTimeSpan.class;
            }
            case "guid": 
            case "Guid": {
                return StiGuid.class;
            }
            case "object": 
            case "Object": {
                return Object.class;
            }
            case "void": {
                return Void.TYPE;
            }
            case "HatchStyle": {
                return StiHatchStyle.class;
            }
            case "List": 
            case "ArrayList": 
            case "System.Collections.Generic.List": 
            case "System.Collections.ArrayList": {
                return ArrayList.class;
            }
            case "System.IComparable": {
                return Comparable.class;
            }
            case "System.Exception": {
                return Exception.class;
            }
            case "HashSet": 
            case "System.Collections.Generic.HashSet": {
                return HashSet.class;
            }
            case "Queue": 
            case "System.Collections.Generic.Queue": 
            case "System.Collections.Queue": {
                return Queue.class;
            }
            case "Stack": 
            case "System.Collections.Generic.Stack": 
            case "System.Collections.Stack": {
                return Stack.class;
            }
            case "SortedList": 
            case "System.Collections.Generic.SortedList": 
            case "System.Collections.SortedList": {
                return TreeMap.class;
            }
            case "SizeF": 
            case "SizeD": 
            case "Size": 
            case "Stimulsoft.Base.Drawing.Size": 
            case "Stimulsoft.Base.Drawing.SizeD": 
            case "Stimulsoft.Base.Drawing.SizeF": {
                return StiSize.class;
            }
            case "Rectangle": 
            case "RectangleD": 
            case "RectangleF": 
            case "Stimulsoft.Base.Drawing.RectangleD": 
            case "Stimulsoft.Base.Drawing.RectangleF": 
            case "Stimulsoft.Base.Drawing.Rectangle": {
                return StiRectangle.class;
            }
            case "Point": 
            case "PointD": 
            case "PointF": 
            case "Stimulsoft.Base.Drawing.PointD": 
            case "Stimulsoft.Base.Drawing.PointF": 
            case "Stimulsoft.Base.Drawing.Point": {
                return StiPoint.class;
            }
            case "Font": {
                return StiFont.class;
            }
            case "FontStyle": {
                return StiFontStyle.class;
            }
            case "System.Text.Encoding": {
                try {
                    return Class.forName("com.stimulsoft.base.parser.classes.Encoding");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            case "Stimulsoft.Report.StiReport": {
                try {
                    return Class.forName("com.stimulsoft.report.StiReport");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            case "System.IO.Path": {
                try {
                    return Class.forName("com.stimulsoft.base.parser.classes.Path");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            case "System.Text.StringBuilder": {
                return StringBuilder.class;
            }
            case "Stimulsoft.Report.Dictionary.StiUserFunctionHelper": {
                try {
                    return Class.forName("com.stimulsoft.report.dictionary.userFunction.helpers.StiUserFunctionHelper");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            case "Color": {
                return StiColor.class;
            }
            case "DivideByZeroException": {
                return DivideByZeroException.class;
            }
            case "Stimulsoft.Base.Drawing.StiSolidBrush": 
            case "StiSolidBrush": {
                return StiSolidBrush.class;
            }
            case "Stimulsoft.Base.Drawing.StiGradientBrush": 
            case "StiGradientBrush": {
                return StiGradientBrush.class;
            }
            case "Stimulsoft.Base.Drawing.StiGlareBrush": 
            case "StiGlareBrush": {
                return StiGlareBrush.class;
            }
            case "Stimulsoft.Base.Drawing.StiGlassBrush": 
            case "StiGlassBrush": {
                return StiGlassBrush.class;
            }
            case "Stimulsoft.Base.Drawing.StiHatchBrush": 
            case "StiHatchBrush": {
                return StiHatchBrush.class;
            }
            case "Stimulsoft.Base.Drawing.StiEmptyBrush": 
            case "StiEmptyBrush": {
                return StiEmptyBrush.class;
            }
            case "StiBrush": 
            case "Stimulsoft.Base.Drawing.StiBrush": {
                return StiBrush.class;
            }
            case "Stimulsoft.Report.Components.StiText": {
                try {
                    return Class.forName("com.stimulsoft.report.components.simplecomponents.StiText");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            case "Stimulsoft.Base.Drawing.StiBorder": 
            case "StiBorder": {
                return StiBorder.class;
            }
            case "StiBorderSides": {
                return StiBorderSides.class;
            }
            case "Stimulsoft.Base.Drawing.StiPenStyle": 
            case "StiPenStyle": {
                return StiPenStyle.class;
            }
            case "Convert": {
                try {
                    return Class.forName("com.stimulsoft.report.Func$Convert");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private HashMap getNameToTypeCache() {
        if (this.nameToType == null) {
            this.nameToType = new HashMap();
        }
        return this.nameToType;
    }

    public final void setExternalTypesCache(HashMap nameToType) {
        this.nameToType = nameToType;
    }

    public final void setVariable(String name, Object value) {
        if (this.variables.containsKey(name)) {
            this.variables.put(name, value);
        } else if (this.externalVariablesContains(name)) {
            if (this.externalObjects.isReadOnlyObject(name)) {
                throw new ScriptException(String.format("Variable '%1$s' is read-only and cannot be modified.", name), this.getTokenPosition());
            }
            this.externalObjects.setObject(name, value);
        } else if (this.thisObject != null) {
            Class<?> type = this.thisObject.getClass();
            String dName = name.substring(0, 1).toLowerCase() + name.substring(1);
            String setName = "set" + name;
            Field field = Arrays.asList(type.getFields()).stream().filter(f -> Objects.equals(name, f.getName()) || Objects.equals(dName, f.getName())).findFirst().orElse(null);
            Method method = Arrays.asList(type.getMethods()).stream().filter(f -> Objects.equals(setName, f.getName())).findFirst().orElse(null);
            if (method != null || field != null) {
                this.setPropertyOrField(type, this.thisObject, name, value);
            }
        }
        this.variables.put(name, value);
    }

    private void setVariable(String identifier, List<String> path, Object value) {
        Object instance = null;
        StiRefObject<Object> tempOutInstance = new StiRefObject<Object>(instance);
        if (!this.tryGetVariable(identifier, tempOutInstance)) {
            instance = tempOutInstance.argvalue;
            throw new ScriptException(String.format("Variable '%1$s' not defined.", identifier), this.getTokenPosition());
        }
        instance = tempOutInstance.argvalue;
        path = path.subList(1, path.size());
        int index = 0;
        for (String ident : path) {
            boolean isLast = ++index == path.size();
            Field propertyInfo = StiReflectUtill.getDeclaredField(instance.getClass(), ident);
            if (propertyInfo == null) continue;
        }
    }

    private boolean tryGetVariable(String name, StiRefObject<Object> value) {
        if (StiValidationUtil.isNullOrWhiteSpace((String)name)) {
            value.argvalue = null;
            return false;
        }
        if (this.externalVariablesContains(name)) {
            value.argvalue = this.externalObjects.getObject(name);
            return true;
        }
        if (this.variables.containsKey(name) && (value.argvalue = this.variables.get(name)) == value.argvalue) {
            return true;
        }
        StiRefObject<Object> tempOutResult = new StiRefObject<Object>(null);
        if (this.thisObject != null && this.getPropertyOrField(this.thisObject.getClass(), this.thisObject, name, tempOutResult)) {
            value.argvalue = tempOutResult.argvalue;
            return true;
        }
        return false;
    }

    public final Object getVariable(String name) {
        StiRefObject<Object> tempOutValue = new StiRefObject<Object>(null);
        return this.tryGetVariable(name, tempOutValue) ? tempOutValue.argvalue : null;
    }

    public final Boolean getVariableAsBool(String name) {
        StiRefObject<Object> tempOutValue = new StiRefObject<Object>(null);
        return this.tryGetVariable(name, tempOutValue) ? Boolean.valueOf(StiValueHelper.tryToBool(tempOutValue.argvalue)) : null;
    }

    public final Integer getVariableAsInt(String name) {
        StiRefObject<Object> tempOutValue = new StiRefObject<Object>(null);
        return this.tryGetVariable(name, tempOutValue) ? Integer.valueOf(StiValueHelper.tryToInt(tempOutValue.argvalue)) : null;
    }

    public final Long getVariableAsLong(String name) {
        StiRefObject<Object> tempOutValue = new StiRefObject<Object>(null);
        return this.tryGetVariable(name, tempOutValue) ? Long.valueOf(StiValueHelper.tryToLong(tempOutValue.argvalue)) : null;
    }

    public final Float getVariableAsFloat(String name) {
        StiRefObject<Object> tempOutValue = new StiRefObject<Object>(null);
        return this.tryGetVariable(name, tempOutValue) ? Float.valueOf(StiValueHelper.tryToFloat(tempOutValue.argvalue)) : null;
    }

    public final Double getVariableAsDouble(String name) {
        StiRefObject<Object> tempOutValue = new StiRefObject<Object>(null);
        return this.tryGetVariable(name, tempOutValue) ? Double.valueOf(StiValueHelper.tryToDouble(tempOutValue.argvalue)) : null;
    }

    public final BigDecimal getVariableAsDecimal(String name) {
        StiRefObject<Object> tempOutValue = new StiRefObject<Object>(null);
        return this.tryGetVariable(name, tempOutValue) ? StiValueHelper.tryToDecimal(tempOutValue.argvalue) : null;
    }

    private boolean externalVariablesContains(String typeName) {
        return this.externalObjects != null && this.externalObjects.containsObject(typeName);
    }

    static {
        WRAPPER_TYPE_MAP.put(Integer.TYPE, Integer.class);
        WRAPPER_TYPE_MAP.put(Byte.TYPE, Byte.class);
        WRAPPER_TYPE_MAP.put(Character.TYPE, Character.class);
        WRAPPER_TYPE_MAP.put(Boolean.TYPE, Boolean.class);
        WRAPPER_TYPE_MAP.put(Double.TYPE, Double.class);
        WRAPPER_TYPE_MAP.put(Float.TYPE, Float.class);
        WRAPPER_TYPE_MAP.put(Long.TYPE, Long.class);
        WRAPPER_TYPE_MAP.put(Short.TYPE, Short.class);
        WRAPPER_TYPE_MAP.put(Void.TYPE, Void.class);
        allowUsingSecurityMode = true;
        maxArraySize = 1000000;
        maxLoopIterations = 1000000;
        maxRecursionDepth = 100;
        lockTypeCache = new Object();
    }

    private static class NillType {
        private NillType() {
        }
    }

    private static class TokenState {
        private StiToken token;
        private int index;

        private TokenState() {
        }

        public final StiToken getToken() {
            return this.token;
        }

        public final void setToken(StiToken value) {
            this.token = value;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int value) {
            this.index = value;
        }
    }

    public static class TokenPosition {
        private int line;
        private int column;

        public final int getLine() {
            return this.line;
        }

        public final void setLine(int value) {
            this.line = value;
        }

        public final int getColumn() {
            return this.column;
        }

        public final void setColumn(int value) {
            this.column = value;
        }

        public TokenPosition(int line, int column) {
            this.setLine(line);
            this.setColumn(column);
        }

        public String toString() {
            return String.format("Line %1$s, Column %2$s", this.getLine(), this.getColumn());
        }
    }

    private class CatchClauseInfo {
        public Class catchType;
        public String variableName;
        public TokenState blockStart;

        private CatchClauseInfo() {
        }
    }

    public static interface IExternalObjectsProvider {
        public boolean containsObject(String var1);

        public boolean isReadOnlyObject(String var1);

        public Object getObject(String var1);

        public boolean isObjectSupportsNesting(Object var1);

        public boolean containsNestedObject(Object var1, String var2);

        public boolean getNestedObject(Object var1, String var2, StiRefObject<Object> var3);

        public void setObject(String var1, Object var2);

        public boolean containsFunction(String var1, Class[] var2);

        public Object invokeFunction(String var1, Object[] var2, Class[] var3);
    }

    public static class ScriptSecurityException
    extends ScriptException {
        public String typeName;
        public SecurityCode securityCode;

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder();
            if (!StiValidationUtil.isNullOrEmpty((String)this.typeName)) {
                result.append(String.format(" (Type: %s)", this.typeName));
            }
            result.append(String.format(" (SecurityCode: %s)", new Object[]{this.securityCode}));
            if (this.getTokenPosition() != null && (this.getTokenPosition().getLine() > 0 || this.getTokenPosition().getColumn() > 0)) {
                result.append(String.format(" at Line: %s, Column: %s", this.getTokenPosition().getLine(), this.getTokenPosition().getColumn()));
            }
            return result.toString();
        }

        public ScriptSecurityException(String message, SecurityCode securityCode) {
            super(message);
            this.securityCode = securityCode;
        }

        public ScriptSecurityException(String message, String typeName, SecurityCode securityCode) {
            super(message);
            this.typeName = typeName;
            this.securityCode = securityCode;
        }

        public ScriptSecurityException(String message, String typeName, SecurityCode securityCode, TokenPosition position) {
            super(message, position);
            this.typeName = typeName;
            this.securityCode = securityCode;
        }
    }

    public static class ScriptException
    extends RuntimeException {
        private TokenPosition tokenPosition;

        public final TokenPosition getTokenPosition() {
            return this.tokenPosition;
        }

        public final void setTokenPosition(TokenPosition value) {
            this.tokenPosition = value;
        }

        public ScriptException(String message) {
            super(message);
        }

        public ScriptException(String message, TokenPosition position) {
            super(message);
            this.setTokenPosition(position);
        }

        public ScriptException(String message, RuntimeException innerException, TokenPosition position) {
            super(message, innerException);
            this.setTokenPosition(position);
        }
    }

    public static class ScriptTimeoutException
    extends RuntimeException {
        public ScriptTimeoutException() {
        }

        public ScriptTimeoutException(String message) {
            super(message);
        }
    }

    public static class ContinueStatementScriptException
    extends RuntimeException {
        public ContinueStatementScriptException() {
            super("Continue statement encountered.");
        }
    }

    public static class BreakStatementScriptException
    extends RuntimeException {
        public BreakStatementScriptException() {
            super("Break statement encountered.");
        }
    }
}

