/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.helper;

public class XMLChar {
    private static final byte[] CHARS = new byte[65536];
    public static final int MASK_VALID = 1;
    public static final int MASK_SPACE = 2;
    public static final int MASK_NAME_START = 4;
    public static final int MASK_NAME = 8;
    public static final int MASK_PUBID = 16;
    public static final int MASK_NCNAME_START = 64;
    public static final int MASK_NCNAME = 128;

    public static boolean isValidName(String name) {
        int length = name.length();
        if (length == 0) {
            return false;
        }
        char ch = name.charAt(0);
        if (!XMLChar.isNameStart(ch)) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            ch = name.charAt(i);
            if (XMLChar.isName(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameStart(int c) {
        return c < 65536 && (CHARS[c] & 4) != 0;
    }

    public static boolean isName(int c) {
        return c < 65536 && (CHARS[c] & 8) != 0;
    }

    public static boolean isNCNameStart(int c) {
        return c < 65536 && (CHARS[c] & 0x40) != 0;
    }

    public static boolean isNCName(int c) {
        return c < 65536 && (CHARS[c] & 0x80) != 0;
    }
}

