/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing.enums;

import java.util.HashMap;

public enum StiPenStyle {
    Solid(0),
    Dash(1),
    DashDot(2),
    DashDotDot(3),
    Dot(4),
    Double(5),
    None(6);

    private int intValue;
    private static HashMap<Integer, StiPenStyle> mappings;
    private static float[] dashSolid;
    private static float[] dashDash;
    private static float[] dashDashDot;
    private static float[] dashDashDotDot;
    private static float[] dashDot;
    private static float[] dashNone;

    private static synchronized HashMap<Integer, StiPenStyle> getMappings() {
        if (mappings == null) {
            mappings = new HashMap();
        }
        return mappings;
    }

    private StiPenStyle(int value) {
        this.intValue = value;
        StiPenStyle.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static StiPenStyle forValue(int value) {
        return StiPenStyle.getMappings().get(value);
    }

    public float[] getDash(float width) {
        float[] result = dashSolid;
        switch (this.intValue) {
            case 0: {
                result = dashSolid;
                break;
            }
            case 1: {
                result = dashDash;
                break;
            }
            case 2: {
                result = dashDashDot;
                break;
            }
            case 3: {
                result = dashDashDotDot;
                break;
            }
            case 4: {
                result = dashDot;
                break;
            }
            case 6: {
                result = dashNone;
                break;
            }
            default: {
                result = dashSolid;
            }
        }
        result = (float[])result.clone();
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] * width;
        }
        return result;
    }

    static {
        dashSolid = new float[]{10.0f};
        dashDash = new float[]{3.0f, 1.0f};
        dashDashDot = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
        dashDashDotDot = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        dashDot = new float[]{1.0f, 1.0f};
        dashNone = new float[0];
    }
}

