/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiHtmlTag2;
import com.stimulsoft.base.drawing.StiHtmlTagsState;
import com.stimulsoft.base.drawing.enums.StiHtmlTag;
import java.util.ArrayList;
import java.util.List;

public class StiHtmlState
implements Cloneable {
    public StiHtmlTagsState ts;
    public StringBuilder text;
    public int fontIndex;
    public int posBegin;
    public ArrayList<StiHtmlTagsState> tagsStack;
    public List<Integer> listLevels;
    public boolean unescapeSpecialCharacters;

    public StiHtmlState() {
    }

    public StiHtmlState(String text) {
        this.ts = new StiHtmlTagsState();
        this.ts.tag = new StiHtmlTag2();
        this.text = new StringBuilder(text);
        this.fontIndex = 0;
        this.posBegin = 0;
        this.tagsStack = null;
        this.listLevels = null;
    }

    public StiHtmlState(StiHtmlTagsState ts, int posBegin) {
        this.ts = ts;
        this.text = new StringBuilder();
        this.fontIndex = 0;
        this.posBegin = posBegin;
        this.tagsStack = null;
        this.listLevels = null;
    }

    public StiHtmlState(StiHtmlState state) {
        this.ts = new StiHtmlTagsState(state.ts);
        this.text = new StringBuilder();
        this.fontIndex = 0;
        this.posBegin = state.posBegin;
        this.tagsStack = state.tagsStack != null && state.tagsStack.size() > 0 ? state.tagsStack : null;
        this.listLevels = state.getListLevels();
        if (this.ts.getIndent() < 0) {
            if (this.listLevels != null) {
                this.ts.indent = this.listLevels.size();
            } else {
                this.ts.setIndent(0);
            }
        }
    }

    public StiHtmlState clone() {
        StiHtmlState result = new StiHtmlState(this);
        result.ts = this.ts != null ? this.ts.clone() : null;
        result.text = new StringBuilder(this.text);
        result.tagsStack = new ArrayList();
        result.unescapeSpecialCharacters = this.unescapeSpecialCharacters;
        if (this.tagsStack != null) {
            for (StiHtmlTagsState state : this.tagsStack) {
                result.tagsStack.add(state.clone());
            }
        }
        return result;
    }

    public String toString() {
        return "\"" + this.text.toString().replace("\n", "\\n") + "\" " + (this.ts.tag.tag == StiHtmlTag.None ? "" : this.ts.tag.toString()) + " " + this.ts.lineHeight;
    }

    public StiHtmlTagsState getTs() {
        return this.ts;
    }

    public void setTs(StiHtmlTagsState ts) {
        this.ts = ts;
    }

    public List<Integer> getListLevels() {
        return this.listLevels;
    }

    public void setListLevels(List<Integer> listLevels) {
        this.listLevels = listLevels;
    }

    public StringBuilder getText() {
        return this.text;
    }

    public void setText(StringBuilder text) {
        this.text = text;
    }

    public int getFontIndex() {
        return this.fontIndex;
    }

    public void setFontIndex(int fontIndex) {
        this.fontIndex = fontIndex;
    }

    public int getPosBegin() {
        return this.posBegin;
    }

    public void setPosBegin(int posBegin) {
        this.posBegin = posBegin;
    }

    public ArrayList<StiHtmlTagsState> getTagsStack() {
        return this.tagsStack;
    }

    public void setTagsStack(ArrayList<StiHtmlTagsState> tagsStack) {
        this.tagsStack = tagsStack;
    }
}

