/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StiHTMLConverter {
    private static final Map<String, Integer> HTML_SYMBOLS = new HashMap<String, Integer>();
    private static final Map<String, String> HTML_COLORS = new HashMap<String, String>();
    private static final Map<String, Integer> HTML_BASE_SYMBOLS = new HashMap<String, Integer>();
    private static final String ATTRIBUTE_STR = "('|\")([^('|\")]+)('|\")";
    private static final String HTML_STYLE = "style='";
    private static final Pattern FONT_PATTERN = Pattern.compile("<\\s*font\\s+([^>]*)\\s*>", 2);
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("('|\")([^('|\")]+)('|\")", 2);
    private static final Map<Pattern, String> FONT_ATTRIBUTES = new HashMap<Pattern, String>();

    public static String replaceHtmlSymbols(String text, Boolean allowHtmlTags, Boolean wysiwyg) {
        if (allowHtmlTags.booleanValue()) {
            if (!wysiwyg.booleanValue()) {
                text = text.replaceAll("(?i)<p>", "<br><p>").replaceAll("(?i)<p ", "<br><p ");
                text = text.replaceAll("(?i)<pp>", "<p>").replaceAll("(?i)<pp", "<p ");
                text = text.replaceAll("(?i)<strong>", "<b>").replaceAll("(?i)</strong>", "</b>");
                text = text.replaceAll("(?i)<color", "<font color").replaceAll("(?i)</color>", "</font>");
                text = text.replaceAll("(?i)<em>", "<i>").replaceAll("(?i)</em>", "</i>");
                text = StiHTMLConverter.replaceColorsNames(text);
                text = StiHTMLConverter.setFontStyle(text);
            }
        } else if (!wysiwyg.booleanValue()) {
            text = text.replaceAll("(?i)/&", "&amp;").replace("(?i)<", "&lt;").replace("(?i)>", "&gt;");
        }
        return text;
    }

    private static String setFontStyle(String html) {
        String result = new String(html);
        Matcher fontMatcher = FONT_PATTERN.matcher(html);
        while (fontMatcher.find()) {
            String style = "";
            String font = new String(fontMatcher.group(0));
            for (Pattern pattern : FONT_ATTRIBUTES.keySet()) {
                Matcher matcher = pattern.matcher(fontMatcher.group(0));
                if (!matcher.find()) continue;
                Matcher valueMatcher = ATTRIBUTE_PATTERN.matcher(matcher.group(0));
                valueMatcher.find();
                style = style + FONT_ATTRIBUTES.get(pattern) + valueMatcher.group(0).replaceAll("'", "\"") + ";";
                font = font.replaceAll(matcher.group(0), "");
            }
            if ("".equals(style)) continue;
            font = font.substring(0, font.length() - 1) + HTML_STYLE + style + "'>";
            result = result.replaceAll(fontMatcher.group(0), font);
        }
        return result;
    }

    private static String replaceColorsNames(String text) {
        if (text == null || text.indexOf("<font") < 0 || text.indexOf("color=") < 0) {
            return text;
        }
        String part = text;
        String result = "";
        while (part.indexOf("<font ") >= 0) {
            int startPos = part.indexOf("<font ");
            result = result + part.substring(0, startPos);
            part = part.substring(startPos);
            int endPos = part.indexOf(">");
            int colorPos = part.indexOf(" color=");
            if (colorPos < endPos) {
                startPos = colorPos + 7;
                Character quote = Character.valueOf(part.charAt(startPos));
                result = result + part.substring(0, startPos + 1);
                String name = (part = part.substring(startPos + 1)).substring(0, endPos = part.indexOf(quote.charValue())).toLowerCase();
                if (HTML_COLORS.containsKey(name)) {
                    name = "#" + HTML_COLORS.get(name);
                }
                result = result + name;
                part = part.substring(endPos);
                continue;
            }
            result = result + part.substring(0, endPos + 1);
            part = part.substring(endPos + 1);
        }
        return result + part;
    }

    static {
        FONT_ATTRIBUTES.put(Pattern.compile("face=('|\")([^('|\")]+)('|\")", 2), "font-family : ");
        FONT_ATTRIBUTES.put(Pattern.compile("color=('|\")([^('|\")]+)('|\")", 2), "color : ");
        FONT_ATTRIBUTES.put(Pattern.compile("size=('|\")([^('|\")]+)('|\")", 2), "font-size : ");
        HTML_COLORS.put("aliceblue", "f0f8ff");
        HTML_COLORS.put("antiquewhite", "faebd7");
        HTML_COLORS.put("aqua", "00ffff");
        HTML_COLORS.put("aquamarine", "7fffd4");
        HTML_COLORS.put("azure", "f0ffff");
        HTML_COLORS.put("beige", "f5f5dc");
        HTML_COLORS.put("bisque", "ffe4c4");
        HTML_COLORS.put("black", "000000");
        HTML_COLORS.put("blanchedalmond", "ffebcd");
        HTML_COLORS.put("blue", "0000ff");
        HTML_COLORS.put("blueviolet", "8a2be2");
        HTML_COLORS.put("brown", "a52a2a");
        HTML_COLORS.put("burlywood", "deb887");
        HTML_COLORS.put("cadetblue", "5f9ea0");
        HTML_COLORS.put("chartreuse", "7fff00");
        HTML_COLORS.put("chocolate", "d2691e");
        HTML_COLORS.put("coral", "ff7f50");
        HTML_COLORS.put("cornflowerblue", "6495ed");
        HTML_COLORS.put("cornsilk", "fff8dc");
        HTML_COLORS.put("crimson", "dc143c");
        HTML_COLORS.put("cyan", "00ffff");
        HTML_COLORS.put("darkblue", "00008b");
        HTML_COLORS.put("darkcyan", "008b8b");
        HTML_COLORS.put("darkgoldenrod", "b8860b");
        HTML_COLORS.put("darkgray", "a9a9a9");
        HTML_COLORS.put("darkgrey", "a9a9a9");
        HTML_COLORS.put("darkgreen", "006400");
        HTML_COLORS.put("darkkhaki", "bdb76b");
        HTML_COLORS.put("darkmagenta", "8b008b");
        HTML_COLORS.put("darkolivegreen", "556b2f");
        HTML_COLORS.put("darkorange", "ff8c00");
        HTML_COLORS.put("darkorchid", "9932cc");
        HTML_COLORS.put("darkred", "8b0000");
        HTML_COLORS.put("darksalmon", "e9967a");
        HTML_COLORS.put("darkseagreen", "8fbc8f");
        HTML_COLORS.put("darkslateblue", "483d8b");
        HTML_COLORS.put("darkslategray", "2f4f4f");
        HTML_COLORS.put("darkslategrey", "2f4f4f");
        HTML_COLORS.put("darkturquoise", "00ced1");
        HTML_COLORS.put("darkviolet", "9400d3");
        HTML_COLORS.put("deeppink", "ff1493");
        HTML_COLORS.put("deepskyblue", "00bfff");
        HTML_COLORS.put("dimgray", "696969");
        HTML_COLORS.put("dimgrey", "696969");
        HTML_COLORS.put("dodgerblue", "1e90ff");
        HTML_COLORS.put("firebrick", "b22222");
        HTML_COLORS.put("floralwhite", "fffaf0");
        HTML_COLORS.put("forestgreen", "228b22");
        HTML_COLORS.put("fuchsia", "ff00ff");
        HTML_COLORS.put("gainsboro", "dcdcdc");
        HTML_COLORS.put("ghostwhite", "f8f8ff");
        HTML_COLORS.put("gold", "ffd700");
        HTML_COLORS.put("goldenrod", "daa520");
        HTML_COLORS.put("gray", "808080");
        HTML_COLORS.put("grey", "808080");
        HTML_COLORS.put("green", "008000");
        HTML_COLORS.put("greenyellow", "adff2f");
        HTML_COLORS.put("honeydew", "f0fff0");
        HTML_COLORS.put("hotpink", "ff69b4");
        HTML_COLORS.put("indianred", "cd5c5c");
        HTML_COLORS.put("indigo", "4b0082");
        HTML_COLORS.put("ivory", "fffff0");
        HTML_COLORS.put("khaki", "f0e68c");
        HTML_COLORS.put("lavender", "e6e6fa");
        HTML_COLORS.put("lavenderblush", "fff0f5");
        HTML_COLORS.put("lawngreen", "7cfc00");
        HTML_COLORS.put("lemonchiffon", "fffacd");
        HTML_COLORS.put("lightblue", "add8e6");
        HTML_COLORS.put("lightcoral", "f08080");
        HTML_COLORS.put("lightcyan", "e0ffff");
        HTML_COLORS.put("lightgoldenrodyellow", "fafad2");
        HTML_COLORS.put("lightgray", "d3d3d3");
        HTML_COLORS.put("lightgrey", "d3d3d3");
        HTML_COLORS.put("lightgreen", "90ee90");
        HTML_COLORS.put("lightpink", "ffb6c1");
        HTML_COLORS.put("lightsalmon", "ffa07a");
        HTML_COLORS.put("lightseagreen", "20b2aa");
        HTML_COLORS.put("lightskyblue", "87cefa");
        HTML_COLORS.put("lightslategray", "778899");
        HTML_COLORS.put("lightslategrey", "778899");
        HTML_COLORS.put("lightsteelblue", "b0c4de");
        HTML_COLORS.put("lightyellow", "ffffe0");
        HTML_COLORS.put("lime", "00ff00");
        HTML_COLORS.put("limegreen", "32cd32");
        HTML_COLORS.put("linen", "faf0e6");
        HTML_COLORS.put("magenta", "ff00ff");
        HTML_COLORS.put("maroon", "800000");
        HTML_COLORS.put("mediumaquamarine", "66cdaa");
        HTML_COLORS.put("mediumblue", "0000cd");
        HTML_COLORS.put("mediumorchid", "ba55d3");
        HTML_COLORS.put("mediumpurple", "9370d8");
        HTML_COLORS.put("mediumseagreen", "3cb371");
        HTML_COLORS.put("mediumslateblue", "7b68ee");
        HTML_COLORS.put("mediumspringgreen", "00fa9a");
        HTML_COLORS.put("mediumturquoise", "48d1cc");
        HTML_COLORS.put("mediumvioletred", "c71585");
        HTML_COLORS.put("midnightblue", "191970");
        HTML_COLORS.put("mintcream", "f5fffa");
        HTML_COLORS.put("mistyrose", "ffe4e1");
        HTML_COLORS.put("moccasin", "ffe4b5");
        HTML_COLORS.put("navajowhite", "ffdead");
        HTML_COLORS.put("navy", "000080");
        HTML_COLORS.put("oldlace", "fdf5e6");
        HTML_COLORS.put("olive", "808000");
        HTML_COLORS.put("olivedrab", "6b8e23");
        HTML_COLORS.put("orange", "ffa500");
        HTML_COLORS.put("orangered", "ff4500");
        HTML_COLORS.put("orchid", "da70d6");
        HTML_COLORS.put("palegoldenrod", "eee8aa");
        HTML_COLORS.put("palegreen", "98fb98");
        HTML_COLORS.put("paleturquoise", "afeeee");
        HTML_COLORS.put("palevioletred", "d87093");
        HTML_COLORS.put("papayawhip", "ffefd5");
        HTML_COLORS.put("peachpuff", "ffdab9");
        HTML_COLORS.put("peru", "cd853f");
        HTML_COLORS.put("pink", "ffc0cb");
        HTML_COLORS.put("plum", "dda0dd");
        HTML_COLORS.put("powderblue", "b0e0e6");
        HTML_COLORS.put("purple", "800080");
        HTML_COLORS.put("red", "ff0000");
        HTML_COLORS.put("rosybrown", "bc8f8f");
        HTML_COLORS.put("royalblue", "4169e1");
        HTML_COLORS.put("saddlebrown", "8b4513");
        HTML_COLORS.put("salmon", "fa8072");
        HTML_COLORS.put("sandybrown", "f4a460");
        HTML_COLORS.put("seagreen", "2e8b57");
        HTML_COLORS.put("seashell", "fff5ee");
        HTML_COLORS.put("sienna", "a0522d");
        HTML_COLORS.put("silver", "c0c0c0");
        HTML_COLORS.put("skyblue", "87ceeb");
        HTML_COLORS.put("slateblue", "6a5acd");
        HTML_COLORS.put("slategray", "708090");
        HTML_COLORS.put("slategrey", "708090");
        HTML_COLORS.put("snow", "fffafa");
        HTML_COLORS.put("springgreen", "00ff7f");
        HTML_COLORS.put("steelblue", "4682b4");
        HTML_COLORS.put("tan", "d2b48c");
        HTML_COLORS.put("teal", "008080");
        HTML_COLORS.put("thistle", "d8bfd8");
        HTML_COLORS.put("tomato", "ff6347");
        HTML_COLORS.put("turquoise", "40e0d0");
        HTML_COLORS.put("violet", "ee82ee");
        HTML_COLORS.put("wheat", "f5deb3");
        HTML_COLORS.put("white", "ffffff");
        HTML_COLORS.put("whitesmoke", "f5f5f5");
        HTML_COLORS.put("yellow", "ffff00");
        HTML_COLORS.put("yellowgreen", "9acd32");
        HTML_SYMBOLS.put("&iexcl;", 161);
        HTML_SYMBOLS.put("&cent;", 162);
        HTML_SYMBOLS.put("&pound;", 163);
        HTML_SYMBOLS.put("&curren;", 164);
        HTML_SYMBOLS.put("&yen;", 165);
        HTML_SYMBOLS.put("&brvbar;", 166);
        HTML_SYMBOLS.put("&sect;", 167);
        HTML_SYMBOLS.put("&uml;", 168);
        HTML_SYMBOLS.put("&copy;", 169);
        HTML_SYMBOLS.put("&ordf;", 170);
        HTML_SYMBOLS.put("&laquo;", 171);
        HTML_SYMBOLS.put("&not;", 172);
        HTML_SYMBOLS.put("&shy;", 173);
        HTML_SYMBOLS.put("&reg;", 174);
        HTML_SYMBOLS.put("&macr;", 175);
        HTML_SYMBOLS.put("&deg;", 176);
        HTML_SYMBOLS.put("&plusmn;", 177);
        HTML_SYMBOLS.put("&sup2;", 178);
        HTML_SYMBOLS.put("&sup3;", 179);
        HTML_SYMBOLS.put("&acute;", 180);
        HTML_SYMBOLS.put("&micro;", 181);
        HTML_SYMBOLS.put("&para;", 182);
        HTML_SYMBOLS.put("&middot;", 183);
        HTML_SYMBOLS.put("&cedil;", 184);
        HTML_SYMBOLS.put("&sup1;", 185);
        HTML_SYMBOLS.put("&ordm;", 186);
        HTML_SYMBOLS.put("&raquo;", 187);
        HTML_SYMBOLS.put("&frac14;", 188);
        HTML_SYMBOLS.put("&frac12;", 189);
        HTML_SYMBOLS.put("&frac34;", 190);
        HTML_SYMBOLS.put("&iquest;", 191);
        HTML_SYMBOLS.put("&Agrave;", 192);
        HTML_SYMBOLS.put("&Aacute;", 193);
        HTML_SYMBOLS.put("&Acirc;", 194);
        HTML_SYMBOLS.put("&Atilde;", 195);
        HTML_SYMBOLS.put("&Auml;", 196);
        HTML_SYMBOLS.put("&Aring;", 197);
        HTML_SYMBOLS.put("&AElig;", 198);
        HTML_SYMBOLS.put("&Ccedil;", 199);
        HTML_SYMBOLS.put("&Egrave;", 200);
        HTML_SYMBOLS.put("&Eacute;", 201);
        HTML_SYMBOLS.put("&Ecirc;", 202);
        HTML_SYMBOLS.put("&Euml;", 203);
        HTML_SYMBOLS.put("&Igrave;", 204);
        HTML_SYMBOLS.put("&Iacute;", 205);
        HTML_SYMBOLS.put("&Icirc;", 206);
        HTML_SYMBOLS.put("&Iuml;", 207);
        HTML_SYMBOLS.put("&ETH;", 208);
        HTML_SYMBOLS.put("&Ntilde;", 209);
        HTML_SYMBOLS.put("&Ograve;", 210);
        HTML_SYMBOLS.put("&Oacute;", 211);
        HTML_SYMBOLS.put("&Ocirc;", 212);
        HTML_SYMBOLS.put("&Otilde;", 213);
        HTML_SYMBOLS.put("&Ouml;", 214);
        HTML_SYMBOLS.put("&times;", 215);
        HTML_SYMBOLS.put("&Oslash;", 216);
        HTML_SYMBOLS.put("&Ugrave;", 217);
        HTML_SYMBOLS.put("&Uacute;", 218);
        HTML_SYMBOLS.put("&Ucirc;", 219);
        HTML_SYMBOLS.put("&Uuml;", 220);
        HTML_SYMBOLS.put("&Yacute;", 221);
        HTML_SYMBOLS.put("&THORN;", 222);
        HTML_SYMBOLS.put("&szlig;", 223);
        HTML_SYMBOLS.put("&agrave;", 224);
        HTML_SYMBOLS.put("&aacute;", 225);
        HTML_SYMBOLS.put("&acirc;", 226);
        HTML_SYMBOLS.put("&atilde;", 227);
        HTML_SYMBOLS.put("&auml;", 228);
        HTML_SYMBOLS.put("&aring;", 229);
        HTML_SYMBOLS.put("&aelig;", 230);
        HTML_SYMBOLS.put("&ccedil;", 231);
        HTML_SYMBOLS.put("&egrave;", 232);
        HTML_SYMBOLS.put("&eacute;", 233);
        HTML_SYMBOLS.put("&ecirc;", 234);
        HTML_SYMBOLS.put("&euml;", 235);
        HTML_SYMBOLS.put("&igrave;", 236);
        HTML_SYMBOLS.put("&iacute;", 237);
        HTML_SYMBOLS.put("&icirc;", 238);
        HTML_SYMBOLS.put("&iuml;", 239);
        HTML_SYMBOLS.put("&eth;", 240);
        HTML_SYMBOLS.put("&ntilde;", 241);
        HTML_SYMBOLS.put("&ograve;", 242);
        HTML_SYMBOLS.put("&oacute;", 243);
        HTML_SYMBOLS.put("&ocirc;", 244);
        HTML_SYMBOLS.put("&otilde;", 245);
        HTML_SYMBOLS.put("&ouml;", 246);
        HTML_SYMBOLS.put("&divide;", 247);
        HTML_SYMBOLS.put("&oslash;", 248);
        HTML_SYMBOLS.put("&ugrave;", 249);
        HTML_SYMBOLS.put("&uacute;", 250);
        HTML_SYMBOLS.put("&ucirc;", 251);
        HTML_SYMBOLS.put("&uuml;", 252);
        HTML_SYMBOLS.put("&yacute;", 253);
        HTML_SYMBOLS.put("&thorn;", 254);
        HTML_SYMBOLS.put("&yuml;", 255);
        HTML_SYMBOLS.put("&OElig;", 338);
        HTML_SYMBOLS.put("&oelig;", 339);
        HTML_SYMBOLS.put("&Scaron;", 352);
        HTML_SYMBOLS.put("&scaron;", 353);
        HTML_SYMBOLS.put("&Yuml;", 376);
        HTML_SYMBOLS.put("&fnof;", 402);
        HTML_SYMBOLS.put("&circ;", 710);
        HTML_SYMBOLS.put("&tilde;", 732);
        HTML_SYMBOLS.put("&Alpha;", 913);
        HTML_SYMBOLS.put("&Beta;", 914);
        HTML_SYMBOLS.put("&Gamma;", 915);
        HTML_SYMBOLS.put("&Delta;", 916);
        HTML_SYMBOLS.put("&Epsilon;", 917);
        HTML_SYMBOLS.put("&Zeta;", 918);
        HTML_SYMBOLS.put("&Eta;", 919);
        HTML_SYMBOLS.put("&Theta;", 920);
        HTML_SYMBOLS.put("&Iota;", 921);
        HTML_SYMBOLS.put("&Kappa;", 922);
        HTML_SYMBOLS.put("&Lambda;", 923);
        HTML_SYMBOLS.put("&Mu;", 924);
        HTML_SYMBOLS.put("&Nu;", 925);
        HTML_SYMBOLS.put("&Xi;", 926);
        HTML_SYMBOLS.put("&Omicron;", 927);
        HTML_SYMBOLS.put("&Pi;", 928);
        HTML_SYMBOLS.put("&Rho;", 929);
        HTML_SYMBOLS.put("&Sigma;", 931);
        HTML_SYMBOLS.put("&Tau;", 932);
        HTML_SYMBOLS.put("&Upsilon;", 933);
        HTML_SYMBOLS.put("&Phi;", 934);
        HTML_SYMBOLS.put("&Chi;", 935);
        HTML_SYMBOLS.put("&Psi;", 936);
        HTML_SYMBOLS.put("&Omega;", 937);
        HTML_SYMBOLS.put("&alpha;", 945);
        HTML_SYMBOLS.put("&beta;", 946);
        HTML_SYMBOLS.put("&gamma;", 947);
        HTML_SYMBOLS.put("&delta;", 948);
        HTML_SYMBOLS.put("&epsilon;", 949);
        HTML_SYMBOLS.put("&zeta;", 950);
        HTML_SYMBOLS.put("&eta;", 951);
        HTML_SYMBOLS.put("&theta;", 952);
        HTML_SYMBOLS.put("&iota;", 953);
        HTML_SYMBOLS.put("&kappa;", 954);
        HTML_SYMBOLS.put("&lambda;", 955);
        HTML_SYMBOLS.put("&mu;", 956);
        HTML_SYMBOLS.put("&nu;", 957);
        HTML_SYMBOLS.put("&xi;", 958);
        HTML_SYMBOLS.put("&omicron;", 959);
        HTML_SYMBOLS.put("&pi;", 960);
        HTML_SYMBOLS.put("&rho;", 961);
        HTML_SYMBOLS.put("&sigmaf;", 962);
        HTML_SYMBOLS.put("&sigma;", 963);
        HTML_SYMBOLS.put("&tau;", 964);
        HTML_SYMBOLS.put("&upsilon;", 965);
        HTML_SYMBOLS.put("&phi;", 966);
        HTML_SYMBOLS.put("&chi;", 967);
        HTML_SYMBOLS.put("&psi;", 968);
        HTML_SYMBOLS.put("&omega;", 969);
        HTML_SYMBOLS.put("&thetasym;", 977);
        HTML_SYMBOLS.put("&upsih;", 978);
        HTML_SYMBOLS.put("&piv;", 982);
        HTML_SYMBOLS.put("&ensp;", 8194);
        HTML_SYMBOLS.put("&emsp;", 8195);
        HTML_SYMBOLS.put("&thinsp;", 8201);
        HTML_SYMBOLS.put("&zwnj;", 8204);
        HTML_SYMBOLS.put("&zwj;", 8205);
        HTML_SYMBOLS.put("&lrm;", 8206);
        HTML_SYMBOLS.put("&rlm;", 8207);
        HTML_SYMBOLS.put("&ndash;", 8211);
        HTML_SYMBOLS.put("&mdash;", 8212);
        HTML_SYMBOLS.put("&lsquo;", 8216);
        HTML_SYMBOLS.put("&rsquo;", 8217);
        HTML_SYMBOLS.put("&sbquo;", 8218);
        HTML_SYMBOLS.put("&ldquo;", 8220);
        HTML_SYMBOLS.put("&rdquo;", 8221);
        HTML_SYMBOLS.put("&bdquo;", 8222);
        HTML_SYMBOLS.put("&dagger;", 8224);
        HTML_SYMBOLS.put("&Dagger;", 8225);
        HTML_SYMBOLS.put("&bull;", 8226);
        HTML_SYMBOLS.put("&hellip;", 8230);
        HTML_SYMBOLS.put("&permil;", 8240);
        HTML_SYMBOLS.put("&prime;", 8242);
        HTML_SYMBOLS.put("&Prime;", 8243);
        HTML_SYMBOLS.put("&lsaquo;", 8249);
        HTML_SYMBOLS.put("&rsaquo;", 8250);
        HTML_SYMBOLS.put("&oline;", 8254);
        HTML_SYMBOLS.put("&frasl;", 8260);
        HTML_SYMBOLS.put("&euro;", 8364);
        HTML_SYMBOLS.put("&image;", 8465);
        HTML_SYMBOLS.put("&weierp;", 8472);
        HTML_SYMBOLS.put("&real;", 8476);
        HTML_SYMBOLS.put("&trade;", 8482);
        HTML_SYMBOLS.put("&alefsym;", 8501);
        HTML_SYMBOLS.put("&larr;", 8592);
        HTML_SYMBOLS.put("&uarr;", 8593);
        HTML_SYMBOLS.put("&rarr;", 8594);
        HTML_SYMBOLS.put("&darr;", 8595);
        HTML_SYMBOLS.put("&harr;", 8596);
        HTML_SYMBOLS.put("&crarr;", 8629);
        HTML_SYMBOLS.put("&lArr;", 8656);
        HTML_SYMBOLS.put("&uArr;", 8657);
        HTML_SYMBOLS.put("&rArr;", 8658);
        HTML_SYMBOLS.put("&dArr;", 8659);
        HTML_SYMBOLS.put("&hArr;", 8660);
        HTML_SYMBOLS.put("&forall;", 8704);
        HTML_SYMBOLS.put("&part;", 8706);
        HTML_SYMBOLS.put("&exist;", 8707);
        HTML_SYMBOLS.put("&empty;", 8709);
        HTML_SYMBOLS.put("&nabla;", 8711);
        HTML_SYMBOLS.put("&isin;", 8712);
        HTML_SYMBOLS.put("&notin;", 8713);
        HTML_SYMBOLS.put("&ni;", 8715);
        HTML_SYMBOLS.put("&prod;", 8719);
        HTML_SYMBOLS.put("&sum;", 8721);
        HTML_SYMBOLS.put("&minus;", 8722);
        HTML_SYMBOLS.put("&lowast;", 8727);
        HTML_SYMBOLS.put("&radic;", 8730);
        HTML_SYMBOLS.put("&prop;", 8733);
        HTML_SYMBOLS.put("&infin;", 8734);
        HTML_SYMBOLS.put("&ang;", 8736);
        HTML_SYMBOLS.put("&and;", 8743);
        HTML_SYMBOLS.put("&or;", 8744);
        HTML_SYMBOLS.put("&cap;", 8745);
        HTML_SYMBOLS.put("&cup;", 8746);
        HTML_SYMBOLS.put("&int;", 8747);
        HTML_SYMBOLS.put("&there4;", 8756);
        HTML_SYMBOLS.put("&sim;", 8764);
        HTML_SYMBOLS.put("&cong;", 8773);
        HTML_SYMBOLS.put("&asymp;", 8776);
        HTML_SYMBOLS.put("&ne;", 8800);
        HTML_SYMBOLS.put("&equiv;", 8801);
        HTML_SYMBOLS.put("&le;", 8804);
        HTML_SYMBOLS.put("&ge;", 8805);
        HTML_SYMBOLS.put("&sub;", 8834);
        HTML_SYMBOLS.put("&sup;", 8835);
        HTML_SYMBOLS.put("&nsub;", 8836);
        HTML_SYMBOLS.put("&sube;", 8838);
        HTML_SYMBOLS.put("&supe;", 8839);
        HTML_SYMBOLS.put("&oplus;", 8853);
        HTML_SYMBOLS.put("&otimes;", 8855);
        HTML_SYMBOLS.put("&perp;", 8869);
        HTML_SYMBOLS.put("&sdot;", 8901);
        HTML_SYMBOLS.put("&lceil;", 8968);
        HTML_SYMBOLS.put("&rceil;", 8969);
        HTML_SYMBOLS.put("&lfloor;", 8970);
        HTML_SYMBOLS.put("&rfloor;", 8971);
        HTML_SYMBOLS.put("&lang;", 9001);
        HTML_SYMBOLS.put("&rang;", 9002);
        HTML_SYMBOLS.put("&loz;", 9674);
        HTML_SYMBOLS.put("&spades;", 9824);
        HTML_SYMBOLS.put("&clubs;", 9827);
        HTML_SYMBOLS.put("&hearts;", 9829);
        HTML_SYMBOLS.put("&diams;", 9830);
        HTML_SYMBOLS.put("&#10004;", 10004);
        HTML_BASE_SYMBOLS.put("&quot;", 34);
        HTML_BASE_SYMBOLS.put("&amp;", 38);
        HTML_BASE_SYMBOLS.put("&lt;", 60);
        HTML_BASE_SYMBOLS.put("&gt;", 62);
        HTML_BASE_SYMBOLS.put("&nbsp;", 160);
    }
}

