/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiGraphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class StiGraphicsHelper {
    private static final BufferedImage BUFFERED_IMAGE = new BufferedImage(100, 100, 2);
    public static final Graphics2D IMAGE_GRAPHICS = BUFFERED_IMAGE.createGraphics();
    public static final StiGraphics GRAPHICS = new StiGraphics(BUFFERED_IMAGE.createGraphics());

    public static void setRenderingHints(Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    public static void setDefaultRenderingHints(Graphics2D graphics) {
        graphics.setRenderingHints(IMAGE_GRAPHICS.getRenderingHints());
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        if (img.getWidth() == targetWidth && img.getHeight() == targetHeight) {
            return img;
        }
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth) {
                if ((w /= 2) < targetWidth) {
                    w = targetWidth;
                }
            } else {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight) {
                if ((h /= 2) < targetHeight) {
                    h = targetHeight;
                }
            } else {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }
}

