/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.context.chart.geoms;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.context.chart.geoms.StiGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiGeomType;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;

public class StiFontGeom
extends StiGeom {
    private String fontName = null;
    private double fontSize;
    private StiEnumSet<StiFontStyle> fontStyle = StiEnumSet.of(StiFontStyle.Regular);

    public StiFontGeom(StiFont font) {
        this(font.getName(), font.getSize(), StiFontStyle.forValueSet(font.getStyle()));
    }

    public StiFontGeom(String fontName, double fontSize, StiEnumSet<StiFontStyle> style) {
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.fontStyle = style;
    }

    public static StiFontGeom ChangeFontSize(StiFont font, double newFontSize) {
        return StiFontGeom.ChangeFontSize(font, (float)newFontSize);
    }

    public static StiFontGeom ChangeFontSize(StiFont font, float newFontSize) {
        if (newFontSize < 1.0f) {
            newFontSize = 1.0f;
        }
        return new StiFontGeom(font.getName(), newFontSize, StiFontStyle.forValueSet(font.getStyle()));
    }

    @Override
    public StiGeomType getType() {
        return StiGeomType.Font;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public StiEnumSet<StiFontStyle> getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(StiEnumSet<StiFontStyle> fontStyle) {
        this.fontStyle = fontStyle;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.put("FontName", this.getFontName());
        jObject.put("FontSize", this.getFontSize());
        jObject.put("FontStyle", this.getFontStyle().getValue());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
    }
}

