/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiTimeSpan;
import java.math.BigDecimal;
import java.util.UUID;

public class StiTypeFinder {
    public static Class<?> getType(String className) {
        Class<?> result = StiTypeFinder.getStandardType(className);
        if (result != null) {
            return result;
        }
        if ("java.lang.System".equals(className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return null;
        }
    }

    private static Class<?> getStandardType(String name) {
        switch (name) {
            case "System.Byte": 
            case "System.SByte": 
            case "System.Int16": 
            case "System.UInt16": {
                return Integer.class;
            }
            case "System.Int32": 
            case "System.UInt32": 
            case "System.Int64": 
            case "System.UInt64": {
                return Long.class;
            }
            case "System.Single": {
                return Float.class;
            }
            case "System.Double": {
                return Double.class;
            }
            case "System.Decimal": {
                return BigDecimal.class;
            }
            case "char": {
                return Character.class;
            }
            case "string": {
                return String.class;
            }
            case "bool": {
                return Boolean.class;
            }
            case "datetime": {
                return StiDateTime.class;
            }
            case "timespan": {
                return StiTimeSpan.class;
            }
            case "guid": {
                return UUID.class;
            }
            case "object": {
                return Object.class;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return null;
    }
}

