/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import com.stimulsoft.base.StiPosition;
import com.stimulsoft.base.StiToken;
import com.stimulsoft.base.StiTokenType;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class StiLexer {
    private final char CR = (char)13;
    private final char LF = (char)10;
    private final char TAB = (char)9;
    private static HashSet<String> keywords;
    private static HashSet<String> typeKeywords;
    private StringBuilder text;
    public String baseText;
    public List<Integer> positions = new ArrayList<Integer>();
    public int positionInText;
    public int begToken;

    public StringBuilder getText() {
        return this.text;
    }

    public void setText(StringBuilder value) {
        this.text = value;
        this.baseText = value.toString();
    }

    public void savePosToken() {
        this.begToken = this.positionInText;
        this.positions.add(this.positionInText);
    }

    public StiPosition getPosition(int positionInText) {
        StiPosition pos = new StiPosition(1, 1);
        for (int ps = 0; ps < positionInText; ++ps) {
            ++pos.column;
            if (this.text.charAt(ps) != '\n') continue;
            ++pos.line;
            pos.column = 1;
        }
        return pos;
    }

    public void skipWhitespaceAndComments() {
        while (this.positionInText < this.getText().length()) {
            if (Character.isWhitespace(this.getText().charAt(this.positionInText)) || Character.isISOControl(this.getText().charAt(this.positionInText))) {
                ++this.positionInText;
                continue;
            }
            if (this.positionInText + 1 >= this.getText().length() || this.getText().charAt(this.positionInText) != '/') break;
            if (this.getText().charAt(this.positionInText + 1) == '/') {
                this.positionInText += 2;
                while (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) != '\n') {
                    ++this.positionInText;
                }
                continue;
            }
            if (this.getText().charAt(this.positionInText + 1) != '*') break;
            this.positionInText += 2;
            while (this.positionInText + 1 < this.getText().length() && (this.getText().charAt(this.positionInText) != '*' || this.getText().charAt(this.positionInText + 1) != '/')) {
                ++this.positionInText;
            }
            this.positionInText += 2;
        }
    }

    public boolean waitLparen2() {
        StiToken token = this.getToken();
        return token.type == StiTokenType.LPar;
    }

    public boolean waitComma2() {
        StiToken token = this.getToken();
        return token.type == StiTokenType.Comma;
    }

    public static boolean isKeyword(String ident) {
        return StiLexer.isKeyword(ident, true);
    }

    public static boolean isKeyword(String ident, boolean includingTypes) {
        if (keywords == null) {
            keywords = new HashSet<String>(Arrays.asList("abstract", "array", "as", "base", "break", "case", "catch", "checked", "class", "const", "continue", "default", "delegate", "do", "else", "enum", "event", "explicit", "extern", "false", "finally", "fixed", "for", "foreach", "function", "goto", "if", "implicit", "in", "interface", "internal", "is", "let", "lock", "namespace", "new", "null", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sealed", "sizeof", "stackalloc", "static", "struct", "switch", "this", "throw", "true", "try", "typeof", "unchecked", "unsafe", "using", "var", "virtual", "volatile", "while"));
        }
        if (typeKeywords == null) {
            typeKeywords = new HashSet<String>(Arrays.asList("bool", "byte", "char", "datetime", "decimal", "double", "float", "int", "long", "object", "sbyte", "short", "string", "uint", "ulong", "ushort", "void"));
        }
        return keywords.contains(ident) || includingTypes && typeKeywords.contains(ident);
    }

    public boolean waitAssign2() {
        StiToken token = this.getToken();
        return token.type == StiTokenType.Assign;
    }

    public boolean waitRparen2() {
        StiToken token = this.getToken();
        return token.type == StiTokenType.RPar;
    }

    public boolean waitLbrace2() {
        StiToken token = this.getToken();
        return token.type == StiTokenType.LBrace;
    }

    public boolean waitSemicolon2() {
        StiToken token = this.getToken();
        return token.type == StiTokenType.SemiColon;
    }

    public boolean waitRbrace2() {
        StiToken token = this.getToken();
        return token.type == StiTokenType.RBrace;
    }

    public StiToken scanNumber() {
        int posStart = this.positionInText;
        boolean isFrac = false;
        boolean isDouble = false;
        boolean isFloat = false;
        boolean isLong = false;
        boolean isDecimal = false;
        while (this.positionInText != this.getText().length() && Character.isDigit(this.getText().charAt(this.positionInText))) {
            ++this.positionInText;
        }
        if (this.positionInText != this.getText().length() && this.getText().charAt(this.positionInText) == '.' && this.positionInText + 1 != this.getText().length() && Character.isDigit(this.getText().charAt(this.positionInText + 1))) {
            ++this.positionInText;
            while (this.positionInText != this.getText().length() && Character.isDigit(this.getText().charAt(this.positionInText))) {
                ++this.positionInText;
            }
            isFrac = true;
        }
        if (this.positionInText < this.getText().length() && "mMdDfFlL".indexOf(this.text.charAt(this.positionInText)) >= 0) {
            char suffix = this.text.charAt(this.positionInText);
            ++this.positionInText;
            if (suffix == 'm' || suffix == 'M') {
                isDecimal = true;
            } else if (suffix == 'd' || suffix == 'D') {
                isDouble = true;
            } else if (suffix == 'f' || suffix == 'F') {
                isFloat = true;
            } else if (suffix == 'l' || suffix == 'L') {
                isLong = true;
            }
        }
        String nm = this.baseText.substring(posStart, posStart + this.positionInText - posStart);
        if (isDecimal || isDouble || isFloat || isLong) {
            nm = nm.substring(0, nm.length() - 1);
        }
        if (isDecimal) {
            return new StiToken(StiTokenType.Value, posStart, this.positionInText - posStart, new BigDecimal(nm));
        }
        if (isFrac || isDouble || isFloat) {
            return new StiToken(StiTokenType.Value, posStart, this.positionInText - posStart, Double.parseDouble(nm));
        }
        String valueStr = nm;
        try {
            if (valueStr.length() > 19) {
                return new StiToken(StiTokenType.Value, posStart, this.positionInText - posStart, valueStr);
            }
            Long value = Long.parseLong(valueStr);
            return new StiToken(StiTokenType.Value, posStart, this.positionInText - posStart, value);
        }
        catch (Exception e) {
            if (e instanceof NumberFormatException) {
                return new StiToken(StiTokenType.Value, posStart, this.positionInText - posStart, valueStr);
            }
            throw new RuntimeException(e);
        }
    }

    public StiToken scanIdent() {
        int startIndex = this.positionInText;
        String ident = "";
        while (this.positionInText != this.getText().length() && (Character.isLetterOrDigit(this.getText().charAt(this.positionInText)) || this.getText().charAt(this.positionInText) == '_' || this.getText().charAt(this.positionInText) == '\u2116')) {
            ident = ident + this.getText().charAt(this.positionInText++);
        }
        return new StiToken(StiLexer.isKeyword(ident) ? StiTokenType.Keyword : StiTokenType.Ident, startIndex, this.positionInText - startIndex, ident);
    }

    public StiToken scanString() {
        int startIndex = this.positionInText++;
        String str = "";
        while (this.positionInText != this.getText().length() && this.getText().charAt(this.positionInText) != '\"') {
            str = str + this.getText().charAt(this.positionInText++);
        }
        if (this.positionInText == this.getText().length()) {
            new StiToken(StiTokenType.Value, startIndex, this.positionInText - startIndex, str);
        }
        ++this.positionInText;
        return new StiToken(StiTokenType.Value, startIndex, this.positionInText - startIndex, str);
    }

    public StiToken scanChar() {
        if (++this.positionInText == this.getText().length()) {
            return new StiToken(StiTokenType.Value, this.positionInText - 3, 3, ' ');
        }
        char c = this.getText().charAt(this.positionInText++);
        if (this.positionInText == this.getText().length() || this.getText().charAt(this.positionInText) != '\'') {
            return new StiToken(StiTokenType.Value, this.positionInText - 3, 3, c);
        }
        ++this.positionInText;
        return new StiToken(StiTokenType.Value, this.positionInText - 3, 3, c);
    }

    public void ungetToken() {
        this.positionInText = this.positions.get(this.positions.size() - 1);
        this.positions.remove(this.positions.size() - 1);
    }

    public StiToken getToken() {
        this.skipWhitespaceAndComments();
        if (this.getText().length() <= this.positionInText) {
            return new StiToken(StiTokenType.EOF, this.positionInText, 0);
        }
        if (Character.isLetter(this.getText().charAt(this.positionInText)) || this.getText().charAt(this.positionInText) == '_' || this.getText().charAt(this.positionInText) == '\u2116') {
            int startIndex = this.positionInText;
            this.savePosToken();
            StiToken token = this.scanIdent();
            if ("true".equals(token.data)) {
                return new StiToken(StiTokenType.Value, startIndex, 4, true);
            }
            if ("false".equals(token.data)) {
                return new StiToken(StiTokenType.Value, startIndex, 5, false);
            }
            return token;
        }
        if (Character.isDigit(this.getText().charAt(this.positionInText))) {
            this.savePosToken();
            return this.scanNumber();
        }
        if (this.getText().charAt(this.positionInText) == '\"') {
            this.savePosToken();
            return this.scanString();
        }
        if (this.getText().charAt(this.positionInText) == '\'') {
            this.savePosToken();
            return this.scanChar();
        }
        switch (this.getText().charAt(this.positionInText)) {
            case '\u20ac': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.Euro, this.positionInText - 1, 1);
            }
            case '\u00ae': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.Copyright, this.positionInText - 1, 1);
            }
            case '(': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.LPar, this.positionInText - 1, 1);
            }
            case ')': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.RPar, this.positionInText - 1, 1);
            }
            case '{': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.LBrace, this.positionInText - 1, 1);
            }
            case '}': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.RBrace, this.positionInText - 1, 1);
            }
            case ',': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.Comma, this.positionInText - 1, 1);
            }
            case '.': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.Dot, this.positionInText - 1, 1);
            }
            case ';': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.SemiColon, this.positionInText - 1, 1);
            }
            case ':': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.Colon, this.positionInText - 1, 1);
            }
            case '!': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.NotEqual, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Not, this.positionInText - 1, 1);
            }
            case '*': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.MultAssign, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Mult, this.positionInText - 1, 1);
            }
            case '^': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.XorAssign, this.positionInText - 2, 2);
                }
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '^') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.DoubleXor, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Xor, this.positionInText - 1, 1);
            }
            case '/': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.DivAssign, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Div, this.positionInText - 1, 1);
            }
            case '\\': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.Splash, this.positionInText - 1, 1);
            }
            case '%': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.ModAssign, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Percent, this.positionInText - 1, 1);
            }
            case '#': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.Sharp, this.positionInText - 1, 1);
            }
            case '$': {
                this.savePosToken();
                if (this.positionInText + 1 < this.getText().length() && this.getText().charAt(this.positionInText + 1) == '\"') {
                    ++this.positionInText;
                    return this.scanInterpolatedString();
                }
                ++this.positionInText;
                return new StiToken(StiTokenType.Dollar, this.positionInText - 1, 1);
            }
            case '@': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.Ampersand, this.positionInText - 1, 1);
            }
            case '[': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.LBracket, this.positionInText - 1, 1);
            }
            case ']': {
                this.savePosToken();
                ++this.positionInText;
                return new StiToken(StiTokenType.RBracket, this.positionInText - 1, 1);
            }
            case '?': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '?') {
                    ++this.positionInText;
                    if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                        ++this.positionInText;
                        return new StiToken(StiTokenType.NullCoalescingAssign, this.positionInText - 3, 3);
                    }
                    return new StiToken(StiTokenType.DoubleQuestion, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Question, this.positionInText - 1, 1);
            }
            case '|': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.OrAssign, this.positionInText - 2, 2);
                }
                if (this.positionInText != this.getText().length() && this.getText().charAt(this.positionInText) == '|') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.DoubleOr, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Or, this.positionInText - 1, 1);
            }
            case '&': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.AndAssign, this.positionInText - 2, 2);
                }
                if (this.positionInText != this.getText().length() && this.getText().charAt(this.positionInText) == '&') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.DoubleAnd, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.And, this.positionInText - 1, 1);
            }
            case '+': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.PlusAssign, this.positionInText - 2, 2);
                }
                if (this.positionInText != this.getText().length() && this.getText().charAt(this.positionInText) == '+') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.DoublePlus, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Plus, this.positionInText - 1, 1);
            }
            case '-': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.MinusAssign, this.positionInText - 2, 2);
                }
                if (this.positionInText != this.getText().length() && this.getText().charAt(this.positionInText) == '-') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.DoubleMinus, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Minus, this.positionInText - 1, 1);
            }
            case '=': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText != this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.Equal, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Assign, this.positionInText - 1, 1);
            }
            case '<': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '<') {
                    ++this.positionInText;
                    if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                        ++this.positionInText;
                        return new StiToken(StiTokenType.ShlAssign, this.positionInText - 3, 3);
                    }
                    return new StiToken(StiTokenType.Shl, this.positionInText - 2, 2);
                }
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.LeftEqual, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Left, this.positionInText - 1, 1);
            }
            case '>': {
                this.savePosToken();
                ++this.positionInText;
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '>') {
                    ++this.positionInText;
                    if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                        ++this.positionInText;
                        return new StiToken(StiTokenType.ShrAssign, this.positionInText - 3, 3);
                    }
                    return new StiToken(StiTokenType.Shr, this.positionInText - 2, 2);
                }
                if (this.positionInText < this.getText().length() && this.getText().charAt(this.positionInText) == '=') {
                    ++this.positionInText;
                    return new StiToken(StiTokenType.RightEqual, this.positionInText - 2, 2);
                }
                return new StiToken(StiTokenType.Right, this.positionInText - 1, 1);
            }
        }
        this.savePosToken();
        ++this.positionInText;
        return new StiToken(StiTokenType.Unknown, this.positionInText - 1, 1);
    }

    public void reset() {
        this.positions.clear();
        this.positionInText = 0;
    }

    public final StiToken scanInterpolatedString() {
        int startIndex = this.positionInText - 1;
        ++this.positionInText;
        StringBuilder sb = new StringBuilder();
        boolean inExpression = false;
        int braceDepth = 0;
        while (this.positionInText < this.getText().length()) {
            if (this.getText().charAt(this.positionInText) == '\"' && !inExpression) {
                ++this.positionInText;
                break;
            }
            if (!inExpression && this.getText().charAt(this.positionInText) == '{' && this.positionInText + 1 < this.getText().length() && this.getText().charAt(this.positionInText + 1) == '{') {
                sb.append("{{");
                this.positionInText += 2;
                continue;
            }
            if (!inExpression && this.getText().charAt(this.positionInText) == '}' && this.positionInText + 1 < this.getText().length() && this.getText().charAt(this.positionInText + 1) == '}') {
                sb.append("}}");
                this.positionInText += 2;
                continue;
            }
            if (this.getText().charAt(this.positionInText) == '\\' && this.positionInText + 1 < this.getText().length()) {
                char nextChar = this.getText().charAt(this.positionInText + 1);
                switch (nextChar) {
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    default: {
                        sb.append('\\');
                        sb.append(nextChar);
                    }
                }
                this.positionInText += 2;
                continue;
            }
            if (this.getText().charAt(this.positionInText) == '{' && !inExpression) {
                inExpression = true;
                braceDepth = 1;
                sb.append('{');
                ++this.positionInText;
                continue;
            }
            if (this.getText().charAt(this.positionInText) == '{' && inExpression) {
                ++braceDepth;
                sb.append('{');
                ++this.positionInText;
                continue;
            }
            if (this.getText().charAt(this.positionInText) == '}' && inExpression) {
                sb.append('}');
                ++this.positionInText;
                if (--braceDepth != 0) continue;
                inExpression = false;
                continue;
            }
            sb.append(this.getText().charAt(this.positionInText));
            ++this.positionInText;
        }
        return new StiToken(StiTokenType.InterpolatedString, startIndex, this.positionInText - startIndex, sb.toString());
    }

    public static String replaceWithPrefix(String textValue, String prefix, String oldValue, String newValue) {
        StringBuilder sb = new StringBuilder(textValue);
        StiLexer lexer = new StiLexer(textValue);
        StiToken prefixToken = lexer.getToken();
        if (prefixToken.type == StiTokenType.EOF) {
            return textValue;
        }
        StiToken token = null;
        do {
            token = lexer.getToken();
            if (token.type == StiTokenType.Ident && prefixToken.type == StiTokenType.Ident && StiValidationUtil.equals((Object)prefix, (Object)prefixToken.data) && StiValidationUtil.equals((Object)token.data, (Object)oldValue)) {
                sb = sb.replace(token.index, token.index + token.length, newValue);
                lexer.positionInText += newValue.length();
            }
            prefixToken = token;
        } while (token.type != StiTokenType.EOF);
        return sb.toString();
    }

    public void replaceWithPrefix(String prefix, String oldValue, String newValue) {
        this.reset();
        StiToken prefixToken = this.getToken();
        if (prefixToken.type == StiTokenType.EOF) {
            return;
        }
        StiToken token = null;
        do {
            token = this.getToken();
            if (token.type == StiTokenType.Ident && prefixToken.type == StiTokenType.Ident && StiValidationUtil.equals((Object)prefixToken.data, (Object)prefix) && StiValidationUtil.equals((Object)token.data, (Object)oldValue)) {
                this.text = this.text.replace(token.index, token.index + token.length, newValue);
                this.positionInText += newValue.length();
            }
            prefixToken = token;
        } while (token.type != StiTokenType.EOF);
        this.baseText = this.text.toString();
    }

    public void replaceWithNotEqualPrefix(StiTokenType prefix, String oldValue, String newValue) {
        this.reset();
        StiToken prefixToken = this.getToken();
        if (prefixToken.type == StiTokenType.EOF) {
            return;
        }
        StiToken token = null;
        do {
            token = this.getToken();
            if (token.type == StiTokenType.Ident && prefixToken.type != prefix && StiValidationUtil.equals((Object)token.data, (Object)oldValue)) {
                this.text = this.text.replace(token.index, token.index + token.length, newValue);
                this.positionInText += newValue.length();
            }
            prefixToken = token;
        } while (token.type != StiTokenType.EOF);
        this.baseText = this.text.toString();
    }

    public static boolean identExists(String str, String name, boolean caseSensitive) {
        StiLexer lexer = new StiLexer(str);
        while (true) {
            StiToken token;
            if ((token = lexer.getToken()) == null || token.type == StiTokenType.EOF) {
                return false;
            }
            if (token.type != StiTokenType.Ident || token.data == null) continue;
            if (caseSensitive && StiValidationUtil.equals((Object)token.data.toString(), (Object)name)) {
                return true;
            }
            if (!caseSensitive && StiValidationUtil.equals((Object)token.data.toString().toLowerCase(), (Object)name.toLowerCase())) break;
        }
        return true;
    }

    public static List<StiToken> getAllTokens(String str) {
        ArrayList<StiToken> tokens = new ArrayList<StiToken>();
        StiLexer lexer = new StiLexer(str);
        StiToken token;
        while ((token = lexer.getToken()) != null && token.type != StiTokenType.EOF) {
            tokens.add(token);
        }
        return tokens;
    }

    public StiLexer(String textValue) {
        this.baseText = textValue;
        this.text = new StringBuilder(textValue);
        this.positionInText = 0;
    }
}

