/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.utils.Base64;
import com.stimulsoft.base.utils.StiCharsetHelper;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class StiEncryption {
    private static final int rand_m = 714025;
    private static final int rand_a = 4096;
    private static final int rand_c = 150889;

    public static int[] encrypt(int[] src, int[] key) {
        return StiEncryption.encryptAdv(src, key);
    }

    public static byte[] encrypt(byte[] src, String password) throws NoSuchAlgorithmException {
        int[] byteKey = StiEncryption.getKeyFromPassword(password);
        return StiEncryption.toB(StiEncryption.encryptAdv(StiEncryption.toI(src), byteKey));
    }

    public static byte[] decodeBase64(String value) {
        return Base64.decode(value);
    }

    public static String encrypt(String src, String password) throws NoSuchAlgorithmException {
        int[] byteSrc = StiEncryption.toI(StiCharsetHelper.UTF8.encode(src).array());
        int[] byteKey = StiEncryption.getKeyFromPassword(password);
        int[] dst = StiEncryption.encryptAdv(byteSrc, byteKey);
        return Base64.encode(StiEncryption.toB(dst));
    }

    public static int[] decrypt(int[] src, int[] key) {
        return StiEncryption.decryptAdv(src, key);
    }

    public static int[] decrypt(int[] src, String password) throws NoSuchAlgorithmException {
        int[] byteKey = StiEncryption.getKeyFromPassword(password);
        return StiEncryption.decryptAdv(src, byteKey);
    }

    public static String decrypt(String src, String password) throws NoSuchAlgorithmException {
        int[] byteSrc = StiEncryption.toI(Base64.decode(src));
        int[] byteKey = StiEncryption.getKeyFromPassword(password);
        int[] dst = StiEncryption.decryptAdv(byteSrc, byteKey);
        return StiCharsetHelper.UTF8.decode(ByteBuffer.wrap(StiEncryption.toB(dst))).toString();
    }

    public static int[] generateRandomKey() {
        int[] key = new int[32];
        Random random = new Random();
        for (int index = 0; index < 32; ++index) {
            key[index] = random.nextInt(255);
        }
        return key;
    }

    private static int[] encryptAdv(int[] src, int[] key) {
        int[] dst = new int[src.length];
        dst = StiEncryption.cryptRandom(src, key, true);
        dst = StiEncryption.cryptXor(dst, key);
        dst = StiEncryption.cryptShift(dst, key, true);
        return dst;
    }

    private static int[] decryptAdv(int[] src, int[] key) {
        int[] dst = new int[src.length];
        dst = StiEncryption.cryptShift(src, key, false);
        dst = StiEncryption.cryptXor(dst, key);
        dst = StiEncryption.cryptRandom(dst, key, false);
        return dst;
    }

    private static int[] cryptXor(int[] src, int[] key) {
        int[] dst = new int[src.length];
        int pos = 0;
        int keyPos = 0;
        while (pos < src.length) {
            if (keyPos >= key.length) {
                keyPos = 0;
            }
            dst[pos] = src[pos] ^ key[keyPos];
            ++pos;
            ++keyPos;
        }
        return dst;
    }

    private static int[] cryptShift(int[] src, int[] key, boolean encrypt) {
        int[] dst = new int[src.length];
        int pos = 0;
        int keyPos = 0;
        while (pos < src.length) {
            if (keyPos >= key.length) {
                keyPos = 0;
            }
            dst[pos] = encrypt ? StiEncryption.shiftLeft(src[pos], key[keyPos]) : StiEncryption.shiftRight(src[pos], key[keyPos]);
            ++pos;
            ++keyPos;
        }
        return dst;
    }

    private static int shiftLeft(int value, int count) {
        int res = value << (count & 7);
        res = res & 0xFF | (res & 0xFF00) >> 8;
        return res;
    }

    private static int shiftRight(int value, int count) {
        int res = value << 8 - (count & 7);
        res = res & 0xFF | (res & 0xFF00) >> 8;
        return res;
    }

    private static int[] cryptRandom(int[] src, int[] key, boolean encrypt) {
        int[] dst = new int[src.length];
        long randomSeed = StiEncryption.setRandomSeed(key);
        int[] randomMix = StiEncryption.getMixArray(src.length, randomSeed);
        for (int pos = 0; pos < src.length; ++pos) {
            if (encrypt) {
                dst[pos] = src[randomMix[pos]];
                continue;
            }
            dst[randomMix[pos]] = src[pos];
        }
        return dst;
    }

    private static int[] getMixArray(int count, long randomSeed) {
        int[] check = new int[count];
        int[] mix = new int[count];
        for (int index = 0; index < count; ++index) {
            check[index] = index;
        }
        for (int indexMix = 0; indexMix < count; ++indexMix) {
            StiRefObject<Long> tempRandomSeed = new StiRefObject<Long>(randomSeed);
            int rnd = StiEncryption.getRandom(0, count - indexMix - 1, tempRandomSeed);
            randomSeed = (Long)tempRandomSeed.argvalue;
            mix[indexMix] = check[rnd];
            check[rnd] = check[count - indexMix - 1];
        }
        return mix;
    }

    private static long setRandomSeed(int[] key) {
        long randomSeed = key[0] | key[1] << 8 | key[key.length - 2] << 16 | key[key.length - 1] << 24;
        if (randomSeed < 0L) {
            randomSeed = 0x100000000L + randomSeed;
        }
        if ((randomSeed %= 714025L) < 0L) {
            randomSeed = 0xFFFFFFL - randomSeed & 0xFFFFFFL;
        }
        return randomSeed;
    }

    private static int getRandom(int min, int max, StiRefObject<Long> randomSeed) {
        randomSeed.argvalue = ((Long)randomSeed.argvalue * 4096L + 150889L) % 714025L;
        int jran = (int)((long)min + (long)(max - min + 1) * (Long)randomSeed.argvalue / 714025L);
        return jran;
    }

    private static int[] getKeyFromPassword(String password) throws NoSuchAlgorithmException {
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] encodedPass = StiCharsetHelper.UTF8.encode(password).array();
        if ("8pTP&%#5uK889910".equals(password)) {
            byte[] hashFix = new byte[16];
            System.arraycopy(encodedPass, 0, hashFix, 0, 16);
            encodedPass = hashFix;
        }
        byte[] hash = md.digest(encodedPass);
        ms.write(hash, 0, hash.length);
        for (int pos = hash.length; pos < password.length(); pos += hash.length) {
            ms.write(hash, 0, pos + (hash = md.digest(StiCharsetHelper.UTF8.encode(password.substring(0, pos)).array())).length < password.length() ? hash.length : password.length() - pos);
        }
        return StiEncryption.toI(ms.toByteArray());
    }

    public static byte[] toB(int[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = (byte)in[i];
        }
        return out;
    }

    public static int[] toI(byte[] in) {
        int[] out = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i] < 0 ? 256 + in[i] : in[i];
        }
        return out;
    }
}

