/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.base.utils.StiXmlTextWriter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.helper.StiGaugeSvgHelper;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.infographics.gauge.StiGaugeCalculationMode;
import com.stimulsoft.report.infographics.gauge.StiGaugeType;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeV2InitHelper;
import com.stimulsoft.report.infographics.gauge.indicators.StiIndicatorRangeInfo;
import com.stimulsoft.report.infographics.gauge.indicators.StiLinearBar;
import com.stimulsoft.report.infographics.gauge.indicators.StiLinearIndicatorRangeInfo;
import com.stimulsoft.report.infographics.gauge.indicators.StiRadialBar;
import com.stimulsoft.report.infographics.gauge.indicators.StiRadialIndicatorRangeInfo;
import com.stimulsoft.report.infographics.gauge.indicators.StiStateIndicator;
import com.stimulsoft.report.infographics.gauge.indicators.StiStateIndicatorFilter;
import com.stimulsoft.report.infographics.gauge.interfaces.IStiTickCustom;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.indicators.StiBarBase;
import com.stimulsoft.report.infographics.gauge.primitives.indicators.StiIndicatorBase;
import com.stimulsoft.report.infographics.gauge.primitives.range.StiRangeBase;
import com.stimulsoft.report.infographics.gauge.primitives.range.StiScaleRangeList;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import com.stimulsoft.report.infographics.gauge.range.StiLinearRange;
import com.stimulsoft.report.infographics.gauge.range.StiLinearRangeList;
import com.stimulsoft.report.infographics.gauge.range.StiRadialRange;
import com.stimulsoft.report.infographics.gauge.range.StiRadialRangeList;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;
import com.stimulsoft.report.infographics.gauge.styles.core.StiCustomGaugeStyleCoreXF;
import com.stimulsoft.report.infographics.gauge.styles.view.StiCustomGaugeStyle;
import com.stimulsoft.report.infographics.gauge.styles.view.StiGaugeStyleXF;
import com.stimulsoft.report.infographics.gauge.tick.StiCustomValueBase;
import com.stimulsoft.report.infographics.gauge.tick.linear.label.StiLinearTickLabelCustom;
import com.stimulsoft.report.infographics.gauge.tick.linear.label.StiLinearTickLabelCustomValue;
import com.stimulsoft.report.infographics.gauge.tick.linear.mark.StiLinearTickMarkCustom;
import com.stimulsoft.report.infographics.gauge.tick.linear.mark.StiLinearTickMarkCustomValue;
import com.stimulsoft.report.infographics.gauge.tick.radial.label.StiRadialTickLabelCustom;
import com.stimulsoft.report.infographics.gauge.tick.radial.label.StiRadialTickLabelCustomValue;
import com.stimulsoft.report.infographics.gauge.tick.radial.mark.StiRadialTickMarkCustom;
import com.stimulsoft.report.infographics.gauge.tick.radial.mark.StiRadialTickMarkCustomValue;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiGaugeStyle;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

public class StiGaugeHelper {
    public static HashMap<String, Object> getGaugeProperties(StiGauge gauge) throws IOException, TransformerException, ParserConfigurationException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", gauge.getName());
        properties.put("type", gauge.getType());
        properties.put("minimum", gauge.getMinimum());
        properties.put("maximum", gauge.getMaximum());
        properties.put("calculationMode", gauge.getCalculationMode());
        properties.put("indicatorColumn", StiGaugeHelper.getIndicatorColumn(gauge));
        return properties;
    }

    public static void setGaugeProperties(StiReport report, HashMap param, HashMap callbackResult) throws Exception {
        StiGauge gauge = (StiGauge)report.getPages().GetComponentByName((String)param.get("componentName"));
        if (gauge != null) {
            HashMap props = (HashMap)param.get("properties");
            gauge.setType(StiGaugeType.valueOf((String)((String)props.get("type"))));
            gauge.setCalculationMode(StiGaugeCalculationMode.valueOf((String)((String)props.get("calculationMode"))));
            gauge.setMinimum(Func.Convert.toDecimal(props.get("minimum")));
            gauge.setMaximum(Func.Convert.toDecimal(props.get("maximum")));
            StiGaugeHelper.setIndicatorColumn(gauge, (String)props.get("indicatorColumn"));
            StiGaugeV2InitHelper.init((StiGauge)gauge, (StiGaugeType)gauge.getType(), (boolean)true, (boolean)false);
            callbackResult.put("svgContent", StiReportEdit.getSvgContent((StiComponent)gauge, 1.0));
            callbackResult.put("componentName", param.get("componentName"));
        }
    }

    private static String getIndicatorColumn(StiGauge gauge) {
        StiIndicatorBase indicator = gauge.getScales().size() > 0 ? (StiIndicatorBase)((StiScaleBase)gauge.getScales().get(0)).getItems().stream().filter(x -> x instanceof StiIndicatorBase).findFirst().orElseGet(null) : null;
        return indicator != null && indicator.getValue() != null ? indicator.getValue().getValue() : null;
    }

    private static HashMap<String, Object> gaugeScaleItem(StiScaleBase gaugeScale) {
        HashMap<String, Object> gaugeScaleItem = new HashMap<String, Object>();
        gaugeScaleItem.put("typeItem", "ScaleItem");
        gaugeScaleItem.put("type", gaugeScale.getClass().getName());
        gaugeScaleItem.put("text", gaugeScale.getClass().getName().substring(3));
        gaugeScaleItem.put("elements", StiGaugeHelper.getGaugeElements(gaugeScale));
        gaugeScaleItem.put("scaleIndex", gaugeScale.getGauge().getScales().indexOf((Object)gaugeScale));
        return gaugeScaleItem;
    }

    private static HashMap<String, Object> gaugeElementItem(StiGaugeElement gaugeElement) {
        HashMap<String, Object> gaugeElementItem = new HashMap<String, Object>();
        gaugeElementItem.put("typeItem", "ElementItem");
        gaugeElementItem.put("type", gaugeElement.getClass().getName());
        gaugeElementItem.put("text", gaugeElement.getClass().getName().substring(3));
        gaugeElementItem.put("elementIndex", gaugeElement.getScale().getItems().indexOf((Object)gaugeElement));
        if (gaugeElement instanceof StiLinearTickMarkCustom || gaugeElement instanceof StiLinearTickLabelCustom) {
            gaugeElementItem.put("tickCustomValues", StiGaugeHelper.getTickCustomValues((IStiTickCustom)gaugeElement));
        } else if (gaugeElement instanceof StiLinearRangeList) {
            gaugeElementItem.put("linearRanges", StiGaugeHelper.getLinearRanges((StiLinearRangeList)gaugeElement));
        } else if (gaugeElement instanceof StiRadialRangeList) {
            gaugeElementItem.put("radialRanges", StiGaugeHelper.getRadialRanges((StiRadialRangeList)gaugeElement));
        } else if (gaugeElement instanceof StiLinearBar || gaugeElement instanceof StiRadialBar) {
            gaugeElementItem.put("barRanges", StiGaugeHelper.getBarRanges((StiBarBase)gaugeElement));
        } else if (gaugeElement instanceof StiStateIndicator) {
            gaugeElementItem.put("indicatorStateFilters", StiGaugeHelper.getIndicatorStateFilters((StiStateIndicator)gaugeElement));
            gaugeElementItem.put("iconType", gaugeElement.getScale() instanceof StiLinearScale ? "LinearStateIndicator" : "RadialStateIndicator");
        }
        return gaugeElementItem;
    }

    private static HashMap<String, Object> tickCustomValueItem(StiCustomValueBase tickCustomValue) {
        HashMap<String, Object> tickCustomValueItem = new HashMap<String, Object>();
        tickCustomValueItem.put("typeItem", "ChildElementItem");
        tickCustomValueItem.put("type", tickCustomValue.getClass().getName());
        tickCustomValueItem.put("iconType", "TickCustomValue");
        tickCustomValueItem.put("text", String.format("%s: Value=%s", tickCustomValue.getLocalizedName(), tickCustomValue.value));
        return tickCustomValueItem;
    }

    private static HashMap<String, Object> linearRangeItem(StiLinearRange linearRange) {
        HashMap<String, Object> linearRangeItem = new HashMap<String, Object>();
        linearRangeItem.put("typeItem", "ChildElementItem");
        linearRangeItem.put("type", linearRange.getClass().getName());
        linearRangeItem.put("iconType", "LinearRange");
        linearRangeItem.put("text", String.format("Range: %s-%s", linearRange.getStartValue(), linearRange.getEndValue()));
        return linearRangeItem;
    }

    private static HashMap<String, Object> radialRangeItem(StiRadialRange radialRange) {
        HashMap<String, Object> radialRangeItem = new HashMap<String, Object>();
        radialRangeItem.put("typeItem", "ChildElementItem");
        radialRangeItem.put("type", radialRange.getClass().getName());
        radialRangeItem.put("iconType", "RadialRange");
        radialRangeItem.put("text", String.format("Range: %s-%s", radialRange.getStartValue(), radialRange.getEndValue()));
        return radialRangeItem;
    }

    private static HashMap<String, Object> barRangeItem(StiIndicatorRangeInfo barRange) {
        HashMap<String, Object> barRangeItem = new HashMap<String, Object>();
        barRangeItem.put("typeItem", "ChildElementItem");
        barRangeItem.put("type", barRange.getClass().getName());
        barRangeItem.put("iconType", "BarRangeList");
        barRangeItem.put("text", "IndicatorRangeInfo: Value=" + barRange.getValue());
        return barRangeItem;
    }

    private static HashMap<String, Object> indicatorStateFilterItem(StiStateIndicatorFilter indicatorStateFilter) {
        HashMap<String, Object> indicatorStateFilterItem = new HashMap<String, Object>();
        indicatorStateFilterItem.put("typeItem", "ChildElementItem");
        indicatorStateFilterItem.put("type", indicatorStateFilter.getClass().getName());
        indicatorStateFilterItem.put("iconType", "StateIndicatorFilter");
        indicatorStateFilterItem.put("text", indicatorStateFilter.toString());
        return indicatorStateFilterItem;
    }

    private static ArrayList<HashMap<String, Object>> getGaugeScales(StiGauge gauge) {
        ArrayList<HashMap<String, Object>> gaugeItems = new ArrayList<HashMap<String, Object>>();
        for (StiScaleBase scale : gauge.getScales()) {
            gaugeItems.add(StiGaugeHelper.gaugeScaleItem(scale));
        }
        return gaugeItems;
    }

    private static ArrayList<HashMap<String, Object>> getGaugeElements(StiScaleBase gaugeScale) {
        ArrayList<HashMap<String, Object>> gaugeElements = new ArrayList<HashMap<String, Object>>();
        for (StiGaugeElement element : gaugeScale.getItems()) {
            gaugeElements.add(StiGaugeHelper.gaugeElementItem(element));
        }
        return gaugeElements;
    }

    private static ArrayList<HashMap<String, Object>> getTickCustomValues(IStiTickCustom tickCustom) {
        ArrayList<HashMap<String, Object>> tickCustomValues = new ArrayList<HashMap<String, Object>>();
        for (StiCustomValueBase tickCustomValue : tickCustom.getValues()) {
            tickCustomValues.add(StiGaugeHelper.tickCustomValueItem(tickCustomValue));
        }
        return tickCustomValues;
    }

    private static ArrayList<HashMap<String, Object>> getLinearRanges(StiLinearRangeList rangeList) {
        ArrayList<HashMap<String, Object>> linearRanges = new ArrayList<HashMap<String, Object>>();
        for (StiRangeBase range : rangeList.getRanges()) {
            linearRanges.add(StiGaugeHelper.linearRangeItem((StiLinearRange)range));
        }
        return linearRanges;
    }

    private static ArrayList<HashMap<String, Object>> getRadialRanges(StiRadialRangeList rangeList) {
        ArrayList<HashMap<String, Object>> radialRanges = new ArrayList<HashMap<String, Object>>();
        for (StiRangeBase range : rangeList.getRanges()) {
            radialRanges.add(StiGaugeHelper.radialRangeItem((StiRadialRange)range));
        }
        return radialRanges;
    }

    private static ArrayList<HashMap<String, Object>> getBarRanges(StiBarBase bar) {
        ArrayList<HashMap<String, Object>> barRanges = new ArrayList<HashMap<String, Object>>();
        for (StiIndicatorRangeInfo barRange : bar.getRangeList()) {
            barRanges.add(StiGaugeHelper.barRangeItem(barRange));
        }
        return barRanges;
    }

    private static ArrayList<HashMap<String, Object>> getIndicatorStateFilters(StiStateIndicator indicator) {
        ArrayList<HashMap<String, Object>> indicatorFilters = new ArrayList<HashMap<String, Object>>();
        for (StiStateIndicatorFilter filter : indicator.getFilters()) {
            indicatorFilters.add(StiGaugeHelper.indicatorStateFilterItem(filter));
        }
        return indicatorFilters;
    }

    public static HashMap<String, Object> getStyle(StiGauge gauge) {
        HashMap<String, Object> style = new HashMap<String, Object>();
        style.put("type", !StiValidationUtil.isNullOrEmpty((String)gauge.getCustomStyleName()) ? "StiCustomGaugeStyle" : gauge.getStyle().getClass().getName().substring(gauge.getStyle().getClass().getName().lastIndexOf(".") + 1));
        style.put("name", !StiValidationUtil.isNullOrEmpty((String)gauge.getCustomStyleName()) ? gauge.getCustomStyleName() : ((StiGaugeStyleXF)gauge.getStyle()).getServiceName());
        return style;
    }

    private static List<StiGaugeStyleXF> getGaugeStyles(StiReport report) {
        ArrayList<StiGaugeStyleXF> gaugeStyles = new ArrayList<StiGaugeStyleXF>();
        for (StiBaseStyle style : report.getStyles()) {
            if (!(style instanceof StiGaugeStyle)) continue;
            StiCustomGaugeStyle customStyle = new StiCustomGaugeStyle((StiGaugeStyle)style);
            gaugeStyles.add((StiGaugeStyleXF)customStyle);
        }
        gaugeStyles.addAll(StiOptions.Services.getGaugeStyles());
        return gaugeStyles;
    }

    public static String getGaugeSampleImage(StiGauge gauge, int width, int height, float zoom) throws IOException, TransformerException, ParserConfigurationException {
        StiSvgExportService.StiSvgHelper.StiSvgData svgData = new StiSvgExportService.StiSvgHelper.StiSvgData();
        svgData.X = 0.0;
        svgData.Y = 0.0;
        svgData.Width = width;
        svgData.Height = height;
        svgData.Component = gauge;
        StringBuilder sb = new StringBuilder();
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("svg");
        writer.writeAttributeString("version", "1.1");
        writer.writeAttributeString("baseProfile", "full");
        writer.writeAttributeString("xmlns", "http://www.w3.org/2000/svg");
        writer.writeAttributeString("xmlns:xlink", "http://www.w3.org/1999/xlink");
        writer.writeAttributeString("xmlns:ev", "http://www.w3.org/2001/xml-events");
        writer.writeAttributeString("height", String.valueOf(svgData.Height));
        writer.writeAttributeString("width", String.valueOf(svgData.Width));
        writer.writeStartElement("rect");
        writer.writeAttributeString("height", String.valueOf(svgData.Height));
        writer.writeAttributeString("width", String.valueOf(svgData.Width));
        writer.writeAttributeString("style", StiGaugeSvgHelper.writeFillBrush((StiXmlTextWriter)writer, (Object)gauge.getBrush(), (StiRectangle)new StiRectangle(0.0, 0.0, svgData.Width, svgData.Height)));
        writer.writeFullEndElement();
        StiGaugeSvgHelper.writeGauge((StiXmlTextWriter)writer, (StiSvgExportService.StiSvgHelper.StiSvgData)svgData, (double)zoom, (Boolean)false);
        writer.writeFullEndElement();
        String result = StiXmlHelper.serialize((Document)writer.getDocument());
        return result.substring(result.indexOf(">") + 1);
    }

    public static void setGaugeStyle(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        StiGauge gauge;
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        String styleType = (String)param.get("styleType");
        String styleName = (String)param.get("styleName");
        if (component == null) {
            return;
        }
        StiGauge stiGauge = gauge = component instanceof StiGauge ? (StiGauge)component : null;
        if ("StiCustomGaugeStyle".equals(styleType)) {
            StiGaugeStyle reportStyle = (StiGaugeStyle)gauge.getReport().getStyles().stream().filter(x -> StiValidationUtil.equals((Object)x.getName(), (Object)styleName)).findFirst().orElseGet(null);
            if (reportStyle != null) {
                gauge.setStyle((IStiGaugeStyle)new StiCustomGaugeStyle(reportStyle));
                gauge.setCustomStyleName(reportStyle.getName());
            }
        } else {
            StiGaugeStyleXF baseStyle = null;
            try {
                baseStyle = (StiGaugeStyleXF)Class.forName("com.stimulsoft.report.infographics.gauge.styles.view." + styleType).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (baseStyle != null) {
                gauge.setStyle(baseStyle);
                gauge.setCustomStyleName("");
            }
        }
        gauge.applyStyle(gauge.getStyle());
    }

    public static void getStylesContent(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult, boolean forStylesControl) throws IOException, TransformerException, ParserConfigurationException {
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        StiGauge gaugeCloned = null;
        if (component != null) {
            gaugeCloned = (StiGauge)component.clone();
        } else {
            gaugeCloned = new StiGauge();
            StiGaugeV2InitHelper.init((StiGauge)gaugeCloned, (StiGaugeType)StiGaugeType.FullCircular, (boolean)true, (boolean)false);
        }
        ArrayList stylesContent = new ArrayList();
        if (gaugeCloned != null) {
            for (StiGaugeStyleXF style : StiGaugeHelper.getGaugeStyles(report)) {
                gaugeCloned.setCustomStyleName(style instanceof StiCustomGaugeStyle ? style.getName() : "");
                gaugeCloned.setStyle((IStiGaugeStyle)style);
                gaugeCloned.setCalculationMode(StiGaugeCalculationMode.Custom);
                gaugeCloned.applyStyle(gaugeCloned.getStyle());
                StiGaugeHelper.setIndicatorColumn(gaugeCloned, "50");
                int width = forStylesControl ? 125 : 80;
                int height = forStylesControl ? 50 : 80;
                HashMap<String, Object> content = new HashMap<String, Object>();
                content.put("image", StiGaugeHelper.getGaugeSampleImage(gaugeCloned, width, height, 0.5f));
                content.put("type", gaugeCloned.getStyle().getClass().getName().substring(gaugeCloned.getStyle().getClass().getName().lastIndexOf(".") + 1));
                content.put("name", gaugeCloned.getStyle() instanceof StiCustomGaugeStyle ? ((StiCustomGaugeStyleCoreXF)gaugeCloned.getStyle().getCore()).getReportStyleName() : ((StiGaugeStyleXF)gaugeCloned.getStyle()).getServiceName());
                content.put("width", width);
                content.put("height", height);
                stylesContent.add(content);
            }
        }
        callbackResult.put("stylesContent", stylesContent);
    }

    private static void setIndicatorColumn(StiGauge gauge, String value) {
        StiIndicatorBase indicator;
        StiIndicatorBase stiIndicatorBase = indicator = gauge.getScales().size() > 0 ? (StiIndicatorBase)((StiScaleBase)gauge.getScales().get(0)).getItems().stream().filter(x -> x instanceof StiIndicatorBase).findFirst().orElseGet(null) : null;
        if (indicator != null) {
            indicator.getValue().setValue(value);
        }
    }

    public static void executeJSCommand(StiGauge gauge, HashMap<String, Object> parameters, HashMap<String, Object> callbackResult) throws IOException, TransformerException, ParserConfigurationException {
        HashMap<String, Object> updateResult = new HashMap<String, Object>();
        updateResult.put("command", parameters.get("command"));
        if ("AddGaugeItem".equals(parameters.get("command"))) {
            String itemType = (String)parameters.get("itemType");
            String itemBaseType = (String)parameters.get("itemBaseType");
            HashMap itemIndexes = (HashMap)parameters.get("itemIndexes");
            if ("Scale".equals(itemBaseType)) {
                StiGaugeHelper.addNewScale(gauge, itemType, updateResult);
            } else if ("Element".equals(itemBaseType)) {
                StiGaugeHelper.addNewGaugeElement(gauge, itemType, itemIndexes, updateResult);
            } else if ("ChildElement".equals(itemBaseType)) {
                if ("StiRadialRange".equals(itemType) || "StiLinearRange".equals(itemType)) {
                    StiGaugeHelper.addNewRange(gauge, itemType, itemIndexes, updateResult);
                } else if ("StiTickCustomValue".equals(itemType)) {
                    StiGaugeHelper.addNewTickCustomValue(gauge, itemType, itemIndexes, updateResult);
                } else if ("StiBarRangeList".equals(itemType)) {
                    StiGaugeHelper.addNewBarRangeList(gauge, itemType, itemIndexes, updateResult);
                } else if ("StiStateIndicatorFilter".equals(itemType)) {
                    StiGaugeHelper.addNewStateIndicatorFilter(gauge, itemType, itemIndexes, updateResult);
                }
            }
            updateResult.put("scales", StiGaugeHelper.getGaugeScales(gauge));
        } else if ("RemoveGaugeItem".equals(parameters.get("command"))) {
            HashMap itemIndexes = (HashMap)parameters.get("itemIndexes");
            StiGaugeHelper.removeGaugeItem(gauge, itemIndexes);
            updateResult.put("itemIndexes", itemIndexes);
        }
        updateResult.put("gaugeImage", StiGaugeHelper.getGaugeSampleImage(gauge, 400, 400, 1.0f));
        callbackResult.put("updateResult", updateResult);
    }

    private static StiScaleBase getGaugeScaleBySelectedItem(StiGauge gauge, HashMap<String, Object> itemIndexes) {
        if (itemIndexes != null && itemIndexes.get("scaleIndex") != null) {
            int scaleIndex = (int)Func.Convert.toInt32((Object)itemIndexes.get("scaleIndex"));
            if (gauge.getScales().size() > 0 && gauge.getScales().size() > scaleIndex) {
                return (StiScaleBase)gauge.getScales().get(scaleIndex);
            }
        }
        return null;
    }

    private static StiGaugeElement getGaugeElementBySelectedItem(StiGauge gauge, HashMap<String, Object> itemIndexes) {
        StiScaleBase scale = StiGaugeHelper.getGaugeScaleBySelectedItem(gauge, itemIndexes);
        if (scale != null && itemIndexes != null && itemIndexes.get("elementIndex") != null) {
            int elementIndex = (int)Func.Convert.toInt32((Object)itemIndexes.get("elementIndex"));
            if (scale.getItems().size() > 0 && scale.getItems().size() > elementIndex) {
                return (StiGaugeElement)scale.getItems().get(elementIndex);
            }
        }
        return null;
    }

    private static void addNewScale(StiGauge gauge, String scaleType, HashMap<String, Object> updateResult) {
        StiScaleBase scale = null;
        try {
            scale = (StiScaleBase)Class.forName("com.stimulsoft.report.infographics.gauge.scales." + scaleType).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (scale != null) {
            gauge.getScales().add(scale);
            updateResult.put("scaleIndex", gauge.getScales().indexOf((Object)scale));
        }
    }

    private static void addNewGaugeElement(StiGauge gauge, String elementType, HashMap<String, Object> itemIndexes, HashMap<String, Object> updateResult) {
        StiScaleBase scale = StiGaugeHelper.getGaugeScaleBySelectedItem(gauge, itemIndexes);
        if (scale != null) {
            StiGaugeElement element = null;
            try {
                element = (StiGaugeElement)Class.forName("com.stimulsoft.report.infographics.gauge.indicators." + elementType).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (element != null) {
                scale.getItems().add(element);
                updateResult.put("scaleIndex", gauge.getScales().indexOf((Object)scale));
                updateResult.put("elementIndex", scale.getItems().indexOf((Object)element));
            }
        }
    }

    private static void addNewRange(StiGauge gauge, String elementType, HashMap<String, Object> itemIndexes, HashMap<String, Object> updateResult) {
        StiScaleRangeList rangeList;
        StiScaleRangeList stiScaleRangeList = rangeList = StiGaugeHelper.getGaugeElementBySelectedItem(gauge, itemIndexes) instanceof StiScaleRangeList ? (StiScaleRangeList)StiGaugeHelper.getGaugeElementBySelectedItem(gauge, itemIndexes) : null;
        if (rangeList != null) {
            StiRangeBase rangeBase = null;
            try {
                rangeBase = (StiRangeBase)Class.forName("com.stimulsoft.report.infographics.gauge.range." + elementType).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (rangeBase != null) {
                rangeList.getRanges().add(rangeBase);
                updateResult.put("scaleIndex", gauge.getScales().indexOf((Object)rangeList.getScale()));
                updateResult.put("elementIndex", rangeList.getScale().getItems().indexOf((Object)rangeList));
                updateResult.put("childElementIndex", rangeList.getRanges().indexOf((Object)rangeBase));
            }
        }
    }

    private static void addNewTickCustomValue(StiGauge gauge, String elementType, HashMap<String, Object> itemIndexes, HashMap<String, Object> updateResult) {
        IStiTickCustom gaugeElement;
        StiLinearTickLabelCustomValue customValue = null;
        StiScaleBase scale = StiGaugeHelper.getGaugeScaleBySelectedItem(gauge, itemIndexes);
        IStiTickCustom iStiTickCustom = gaugeElement = StiGaugeHelper.getGaugeElementBySelectedItem(gauge, itemIndexes) instanceof IStiTickCustom ? (IStiTickCustom)StiGaugeHelper.getGaugeElementBySelectedItem(gauge, itemIndexes) : null;
        if (gaugeElement != null) {
            if (gaugeElement instanceof StiLinearTickLabelCustom) {
                customValue = new StiLinearTickLabelCustomValue();
            } else if (gaugeElement instanceof StiLinearTickMarkCustom) {
                customValue = new StiLinearTickMarkCustomValue();
            } else if (gaugeElement instanceof StiRadialTickLabelCustom) {
                customValue = new StiRadialTickLabelCustomValue();
            } else if (gaugeElement instanceof StiRadialTickMarkCustom) {
                customValue = new StiRadialTickMarkCustomValue();
            }
            if (customValue != null) {
                gaugeElement.getValues().add((Object)customValue);
                updateResult.put("scaleIndex", gauge.getScales().indexOf((Object)scale));
                updateResult.put("elementIndex", scale.getItems().indexOf((Object)gaugeElement));
                updateResult.put("childElementIndex", gaugeElement.getValues().indexOf((Object)customValue));
            }
        }
    }

    private static void addNewBarRangeList(StiGauge gauge, String elementType, HashMap<String, Object> itemIndexes, HashMap<String, Object> updateResult) {
        StiBarBase barBase;
        Object rangeInfo = null;
        StiBarBase stiBarBase = barBase = StiGaugeHelper.getGaugeElementBySelectedItem(gauge, itemIndexes) instanceof StiBarBase ? (StiBarBase)StiGaugeHelper.getGaugeElementBySelectedItem(gauge, itemIndexes) : null;
        if (barBase != null) {
            rangeInfo = barBase instanceof StiRadialBar ? new StiRadialIndicatorRangeInfo() : new StiLinearIndicatorRangeInfo();
            barBase.getRangeList().add(rangeInfo);
            updateResult.put("scaleIndex", gauge.getScales().indexOf((Object)barBase.getScale()));
            updateResult.put("elementIndex", barBase.getScale().getItems().indexOf((Object)barBase));
            updateResult.put("childElementIndex", barBase.getRangeList().indexOf(rangeInfo));
        }
    }

    private static void addNewStateIndicatorFilter(StiGauge gauge, String elementType, HashMap<String, Object> itemIndexes, HashMap<String, Object> updateResult) {
        StiStateIndicator stateIndicator;
        StiStateIndicator stiStateIndicator = stateIndicator = StiGaugeHelper.getGaugeElementBySelectedItem(gauge, itemIndexes) instanceof StiStateIndicator ? (StiStateIndicator)StiGaugeHelper.getGaugeElementBySelectedItem(gauge, itemIndexes) : null;
        if (stateIndicator != null) {
            StiStateIndicatorFilter statFilter = new StiStateIndicatorFilter();
            stateIndicator.getFilters().add((Object)statFilter);
            updateResult.put("scaleIndex", gauge.getScales().indexOf((Object)stateIndicator.getScale()));
            updateResult.put("elementIndex", stateIndicator.getScale().getItems().indexOf((Object)stateIndicator));
            updateResult.put("childElementIndex", stateIndicator.getFilters().indexOf((Object)statFilter));
        }
    }

    private static void removeGaugeItem(StiGauge gauge, HashMap<String, Object> itemIndexes) {
        StiScaleBase scale = StiGaugeHelper.getGaugeScaleBySelectedItem(gauge, itemIndexes);
        if (scale != null) {
            if (itemIndexes.get("elementIndex") != null) {
                StiGaugeElement element = StiGaugeHelper.getGaugeElementBySelectedItem(gauge, itemIndexes);
                if (itemIndexes.get("childElementIndex") != null) {
                    int index = (int)Func.Convert.toInt32((Object)itemIndexes.get("childElementIndex"));
                    if (element instanceof StiScaleRangeList) {
                        ((StiScaleRangeList)element).getRanges().remove(index);
                    } else if (element instanceof IStiTickCustom) {
                        ((IStiTickCustom)element).getValues().remove(index);
                    } else if (element instanceof StiBarBase) {
                        ((StiBarBase)element).getRangeList().remove(index);
                    } else if (element instanceof StiStateIndicator) {
                        ((StiStateIndicator)element).getFilters().remove(index);
                    }
                } else if (scale.getItems().contains((Object)element)) {
                    scale.getItems().remove(element);
                }
            } else if (gauge.getScales().contains((Object)scale)) {
                gauge.getScales().remove(scale);
            }
        }
    }
}

