/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.helper.StiWebResourceHelper;
import com.stimulsoft.webdesigner.StiWebDesigner;
import com.stimulsoft.webdesigner.enums.StiWebDesignerTheme;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.HashMap;

public class StiDesignerResourcesHelper {
    public static StiWebActionResult get(StiRequestParams requestParams) throws IOException {
        if ("scripts".equals(requestParams.resource)) {
            byte[] bytes = StiDesignerResourcesHelper.getScripts(requestParams);
            return new StiWebActionResult(bytes, "text/javascript");
        }
        if ("images".equals(requestParams.resource)) {
            HashMap<String, Object> callbackResult = StiDesignerResourcesHelper.getImagesArray(requestParams, null, true);
            HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
            result.put("images", callbackResult);
            return StiWebActionResult.jsonResult((StiRequestParams)requestParams, result);
        }
        if (requestParams.resource != null && (requestParams.resource.endsWith(".png") || requestParams.resource.endsWith(".gif") || requestParams.resource.endsWith(".cur") || requestParams.resource.endsWith(".svg"))) {
            byte[] bytes = StiDesignerResourcesHelper.getImage(requestParams);
            String contentType = "";
            contentType = requestParams.resource.endsWith(".cur") ? "application/octet-stream" : (requestParams.resource.endsWith(".svg") ? "image/svg+xml" : "image/" + requestParams.resource.substring(requestParams.resource.length() - 3));
            return new StiWebActionResult(bytes, contentType);
        }
        if (!StiValidationUtil.isNullOrEmpty((String)requestParams.resource)) {
            byte[] bytes = StiDesignerResourcesHelper.getScripts(requestParams);
            return new StiWebActionResult(bytes, "text/javascript");
        }
        if (!StiValidationUtil.isNullOrEmpty((String)requestParams.theme)) {
            byte[] bytes = StiDesignerResourcesHelper.getStyles(requestParams);
            return new StiWebActionResult(bytes, "text/css");
        }
        return new StiWebActionResult();
    }

    public static byte[] getScripts(StiRequestParams requestParams) throws UnsupportedEncodingException, IOException {
        StringBuilder script = new StringBuilder();
        if (requestParams.resource.startsWith("BlocklyScripts;") || "scripts".equals(requestParams.resource)) {
            String[] blocklyResourceNames;
            String blocklyPath = "/com/stimulsoft/webdesigner/blockly/";
            String locName = "en";
            if (requestParams.resource.split(";").length > 1) {
                locName = requestParams.resource.split(";")[1];
            }
            if (locName != "en" && StiDesignerResourcesHelper.class.getResourceAsStream(String.format("%slocalizations/%s.js", blocklyPath, locName)) == null) {
                locName = "en";
            }
            for (String resourceName : blocklyResourceNames = new String[]{String.format("%sjs/blockly_compressed.js", blocklyPath), String.format("%slocalizations/%s.js", blocklyPath, locName), String.format("%sjs/blocks_compressed.js", blocklyPath), "/webdesigner/Scripts/Initialize/Form/InitializeBlocklyEditorForm_NotLoad.js"}) {
                InputStream stream = StiDesignerResourcesHelper.class.getResourceAsStream(resourceName);
                script.append(StiIOUtil.toString((InputStream)stream));
                script.append("\r\n");
            }
            if ("scripts".equals(requestParams.resource)) {
                return script.toString().getBytes("UTF-8");
            }
        }
        HashMap result = new HashMap();
        try {
            StiWebResourceHelper.getResources(StiWebDesigner.class, (String)"webdesigner", (String)"webdesigner/Scripts/", null, (String)StiWebDesignerTheme.Blue.name(), null, result);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        for (String file : result.keySet()) {
            if (file.indexOf("/LoginControls") >= 0 || !(file.endsWith("js") && ("DesignerScripts".equals(requestParams.resource) && !file.endsWith("_NotLoad.js") || "AllNotLoadedScripts".equals(requestParams.resource) && file.endsWith("_NotLoad.js") || "scripts".equals(requestParams.resource))) && file.indexOf(requestParams.resource) < 0) continue;
            try {
                script.append(StiIOUtil.toString((InputStream)StiResourceUtil.getStream((String)("/" + file))) + "\r\n");
            }
            catch (Exception e) {
                System.out.println("File not foud: " + file);
                e.printStackTrace();
            }
        }
        return script.toString().getBytes("UTF-8");
    }

    public static HashMap<String, String> getStylesConstants(String css) {
        HashMap<String, String> constants = new HashMap<String, String>();
        String[] constantsArray = css.split(";");
        for (int i = 0; i < constantsArray.length; ++i) {
            int index = constantsArray[i].indexOf(64);
            String[] values = constantsArray[i].substring(index >= 0 ? index : 0).split("=");
            if (values.length != 2) continue;
            constants.put(values[0].trim(), values[1].trim());
        }
        return constants;
    }

    public static byte[] getStyles(StiRequestParams requestParams) throws UnsupportedEncodingException {
        StringBuilder css = new StringBuilder();
        String stylesFolder = "Office2013";
        HashMap names = new HashMap();
        String path = "webdesigner/Styles/" + stylesFolder + "/";
        try {
            StiWebResourceHelper.getResources(StiWebDesigner.class, (String)"webdesigner", (String)path, null, (String)stylesFolder, null, names);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, String> constants = null;
        for (String name : names.keySet()) {
            if (!name.endsWith(".css") || name.indexOf("/LoginControls") >= 0) continue;
            name = name.replaceAll("//", "/");
            StringBuffer cssText = null;
            try {
                cssText = StiIOUtil.toStringBuffer((InputStream)StiResourceUtil.getStream((String)("/" + name)));
            }
            catch (IOException e) {
                StiLoggingUtil.showWarning((String)("Error get stream for " + name), (Exception)e);
            }
            if (name.endsWith("Constants.css") && name.indexOf(requestParams.theme + "/Constants.css") > 0) {
                constants = StiDesignerResourcesHelper.getStylesConstants(cssText.toString());
                continue;
            }
            if (name.endsWith("Constants.css")) continue;
            css.append(cssText + "\r\n");
        }
        if (constants != null) {
            for (String key : constants.keySet()) {
                int i;
                int len = key.length();
                String val = (String)constants.get(key);
                while ((i = css.indexOf(key)) >= 0) {
                    css.replace(i, i + len, val);
                }
            }
        }
        return css.toString().getBytes("UTF-8");
    }

    public static byte[] getImage(StiRequestParams requestParams) {
        return StiResourceUtil.getResource((String)("/webdesigner/Images/Office2013/" + requestParams.resource.replace('.', '/').replace("/svg", ".svg").replace("/png", ".png").replace("/gif", ".gif").replace("/cur", ".cur").replace("Data/", "Data.")));
    }

    public static HashMap<String, Object> getImagesArray(StiRequestParams requestParams, String resourcesUrl, boolean ignoreFirstLoadingImages) throws IOException {
        HashMap imgs = StiWebResourceHelper.getImages(StiWebDesigner.class, (String)"webdesigner", (String)"webdesigner/Images/Office2013/", null, (String)"Office2013", (boolean)false);
        HashMap<String, Object> images = new HashMap<String, Object>();
        for (String name : imgs.keySet()) {
            if (!name.endsWith(".png") && !name.endsWith(".gif") && !name.endsWith(".cur") && !name.endsWith(".svg") || name.indexOf("/LoginControls") >= 0) continue;
            if (StiValidationUtil.isNullOrEmpty((String)resourcesUrl) || name.indexOf("_FirstLoadingImages") >= 0) {
                if (ignoreFirstLoadingImages && name.indexOf("_FirstLoadingImages") >= 0) continue;
                String imageName = name.replace("_FirstLoadingImages.", "");
                byte[] buffer = StiResourceUtil.getResource((String)("/webdesigner/Images/Office2013/" + name.replace('.', '/').replace("/png", ".png").replace("/gif", ".gif").replace("/cur", ".cur").replace("/svg", ".svg").replace("Data/", "Data.")));
                if (name.endsWith(".cur")) {
                    images.put(imageName, String.format("data:application/cur;base64,%s", new String(StiBase64EncoderUtil.encode((byte[])buffer))));
                    continue;
                }
                String imageType = imageName.substring(imageName.length() - 3);
                if (imageType.equals("svg")) {
                    imageType = "svg+xml";
                }
                images.put(imageName, String.format("data:image/%s;base64,%s", imageType, new String(StiBase64EncoderUtil.encode((byte[])buffer))));
                continue;
            }
            images.put(name, resourcesUrl + name);
        }
        return images;
    }
}

