/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.component;

import com.stimulsoft.report.StiCustomFunction;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.dataSources.StiDataTableSource;
import com.stimulsoft.report.dictionary.databases.StiXmlDatabase;
import com.stimulsoft.report.utils.data.StiDataColumnsUtil;
import com.stimulsoft.report.utils.data.StiSqlField;
import com.stimulsoft.report.utils.data.StiXmlTable;
import com.stimulsoft.report.utils.data.StiXmlTableFieldsRequest;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.webdesigner.StiWebDesigerHandler;
import com.stimulsoft.webdesigner.StiWebDesignerCommands;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class StiTestWebDesignerBean {
    StiWebDesignerOptions options;
    String designerID = "StimulsoftWebDesigner";

    public StiWebDesigerHandler getHandler() {
        String xmlPath = "d:/Demo.xml";
        String xsdPath = "d:/Demo.xsd";
        StiWebDesigerHandler handler = new StiWebDesigerHandler(){

            @Override
            public StiReport getEditedReport(HttpServletRequest request) {
                try {
                    StiReport report = StiWebDesignerCommands.getNewReport(null);
                    report.getCustomFunctions().add(new StiCustomFunction(){

                        public Object invoke(List<Object> args) {
                            return ((String)args.get(0)).substring(((Long)args.get(1)).intValue(), ((Long)args.get(2)).intValue());
                        }

                        public List<Class> getParametersList() {
                            return new ArrayList<Class>(Arrays.asList(String.class, Long.class, Long.class));
                        }

                        public String getFunctionName() {
                            return "subStr";
                        }
                    });
                    return report;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public void onOpenReportTemplate(StiReport report, HttpServletRequest request) {
                report.getDictionary().getDatabases().add((Object)new StiXmlDatabase("Demo", "d:/Demo.xsd", "d:/Demo.xml"));
            }

            @Override
            public void onNewReportTemplate(StiReport report, HttpServletRequest request) {
                report.getDictionary().getDatabases().add((Object)new StiXmlDatabase("Demo", "d:/Demo.xsd", "d:/Demo.xml"));
                try {
                    StiXmlTableFieldsRequest tables = StiDataColumnsUtil.parceXSDSchema((InputStream)new FileInputStream("d:/Demo.xsd"));
                    for (StiXmlTable table : tables.getTables()) {
                        StiDataTableSource tableSource = new StiDataTableSource("Demo." + table.getName(), table.getName(), table.getName());
                        tableSource.setColumns(new StiDataColumnsCollection());
                        for (StiSqlField field : table.getColumns()) {
                            StiDataColumn column = new StiDataColumn(field.getName(), field.getName(), field.getSystemType());
                            tableSource.getColumns().add(column);
                        }
                        tableSource.setDictionary(report.getDictionary());
                        report.getDictionary().getDataSources().add((Object)tableSource);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onSaveReportTemplate(StiReport report, StiRequestParams requestParams, HttpServletRequest request) {
                try {
                    FileOutputStream fos = new FileOutputStream("C:\\0\\" + requestParams.designer.fileName);
                    StiSerializeManager.serializeReport((StiReport)report, (OutputStream)fos);
                    fos.flush();
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        return handler;
    }

    public StiWebDesignerOptions getOptions() {
        this.options = new StiWebDesignerOptions();
        this.options.setShowPreviewButton(false);
        return this.options;
    }

    public String getDesignerID() {
        return this.designerID;
    }
}

