/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.blockly.parser;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.StiFunctionCategory;
import com.stimulsoft.report.dictionary.StiUserFunction;
import com.stimulsoft.report.dictionary.StiUserFunctionsCollection;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import com.stimulsoft.report.dictionary.functions.StiFunctions;
import com.stimulsoft.report.dictionary.userFunction.helpers.StiUserFunctionHelper;
import com.stimulsoft.webdesigner.blockly.blocks.StiBlocklyBlock;
import com.stimulsoft.webdesigner.blockly.blocks.StiFunctionBlocklyBlock;
import com.stimulsoft.webdesigner.blockly.blocks.StiUserFunctionBlocklyBlock;
import com.stimulsoft.webdesigner.blockly.parser.StiBlocksParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;

public class StiFunctionBlocksParser {
    public static String getInitFunctionBlocks(StiUserFunctionsCollection userFunctions) {
        String blocksJs = "";
        StiFunction[] functions = StiFunctions.getFunctions((boolean)false);
        int index = 0;
        for (StiFunction func : functions) {
            StiFunctionBlocklyBlock functionBlock = new StiFunctionBlocklyBlock(func);
            blocksJs = blocksJs + functionBlock.getJsDefinition();
            ++index;
        }
        if (userFunctions != null) {
            for (StiUserFunction userFunc : userFunctions) {
                StiUserFunctionBlocklyBlock userFunctionBlock = new StiUserFunctionBlocklyBlock(userFunc);
                blocksJs = blocksJs + userFunctionBlock.getJsDefinition();
                ++index;
            }
        }
        return blocksJs;
    }

    public static String getFunctionsGrouppedInCategoriesBlocks(StiUserFunctionsCollection userFunctions) {
        Hashtable hash = StiFunctions.getFunctionsGrouppedInCategories();
        ArrayList<Object> categories = new ArrayList<Object>();
        for (Object key : hash.keySet()) {
            categories.add(key);
        }
        StiUserFunctionsCollection allUserFunctions = userFunctions;
        for (StiUserFunction userFunction : allUserFunctions) {
            if (userFunction.getCategory() != StiFunctionCategory.Custom || StiValidationUtil.isNullOrEmpty((String)userFunction.getCustomCategory()) || categories.contains(userFunction.getCustomCategory())) continue;
            categories.add(userFunction.getCustomCategory());
        }
        Collections.sort(categories);
        StringBuilder result = new StringBuilder();
        for (String string : categories) {
            StiBlocklyBlock functionBlock;
            String categoryContent = "";
            if (hash.containsKey(string)) {
                List functionList = (List)hash.get(string);
                for (StiFunction func : functionList.stream().sorted(Comparator.comparing(StiFunction::getFunctionName)).collect(Collectors.toList())) {
                    functionBlock = new StiFunctionBlocklyBlock(func);
                    categoryContent = categoryContent + functionBlock.getXmlToolboxDefinition();
                }
            }
            List userFunctionsCategory = userFunctions.stream().filter(f -> StiValidationUtil.equals((Object)StiUserFunctionHelper.getCategoryName((StiUserFunction)f), (Object)category)).collect(Collectors.toList());
            for (StiUserFunction userFunction : userFunctionsCategory.stream().sorted(Comparator.comparing(StiUserFunction::getName)).collect(Collectors.toList())) {
                functionBlock = new StiUserFunctionBlocklyBlock(userFunction);
                categoryContent = categoryContent + functionBlock.getXmlToolboxDefinition();
            }
            result.append(StiBlocksParser.getCategoryBlock(string, "#4e85c3", categoryContent));
        }
        return result.toString();
    }
}

