/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.blockly.blocks;

import com.stimulsoft.webdesigner.blockly.blocks.StiBlocklyInput;
import java.util.ArrayList;
import java.util.List;

public abstract class StiBlocklyBlock {
    public String id;
    public String name;
    public String tooltip;
    public String helpUrl;
    public Boolean previousStatement = false;
    public Boolean nextStatement = false;
    public Boolean inputsInline = false;
    public Boolean output = true;
    public List<StiBlocklyInput> valueInputs = new ArrayList<StiBlocklyInput>();
    public String color = "#2969b0";

    public String getXmlToolboxDefinition() {
        return String.format("<block type=\"%s\"></block>", this.id);
    }

    public String getJsDefinition() {
        String inputDefinitions = this.getInputJsDefinitions();
        String result = String.format("Blockly.Blocks['%s'] = {init: function() {" + inputDefinitions + "this.setInputsInline(%s);this.setPreviousStatement(%s, null);this.setNextStatement(%s, null);this.setOutput(%s, null);this.setColour(\"%s\");this.setTooltip(\"%s\");this.setHelpUrl(\"\");}};", this.id, this.inputsInline.toString(), this.previousStatement.toString(), this.nextStatement.toString(), this.output.toString(), this.color, this.getTooltip() != null ? null : this.getTooltip().replace("\"", "\\\""), this.helpUrl);
        return result;
    }

    private String getInputJsDefinitions() {
        String result = "";
        for (StiBlocklyInput item : this.valueInputs) {
            result = result + item.getDefinitions();
        }
        return result;
    }

    public abstract String getTooltip();
}

